/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.BatchItemError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteGeofenceError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDeleteGeofenceError> {
    private static final SdkField<BatchItemError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(BatchDeleteGeofenceError.getter(BatchDeleteGeofenceError::error)).setter(BatchDeleteGeofenceError.setter(Builder::error)).constructor(BatchItemError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<String> GEOFENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeofenceId").getter(BatchDeleteGeofenceError.getter(BatchDeleteGeofenceError::geofenceId)).setter(BatchDeleteGeofenceError.setter(Builder::geofenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeofenceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, GEOFENCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final BatchItemError error;
    private final String geofenceId;

    private BatchDeleteGeofenceError(BuilderImpl builder) {
        this.error = builder.error;
        this.geofenceId = builder.geofenceId;
    }

    public BatchItemError error() {
        return this.error;
    }

    public String geofenceId() {
        return this.geofenceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.geofenceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteGeofenceError)) {
            return false;
        }
        BatchDeleteGeofenceError other = (BatchDeleteGeofenceError)obj;
        return Objects.equals(this.error(), other.error()) && Objects.equals(this.geofenceId(), other.geofenceId());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteGeofenceError").add("Error", (Object)this.error()).add("GeofenceId", (Object)this.geofenceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "GeofenceId": {
                return Optional.ofNullable(clazz.cast(this.geofenceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteGeofenceError, T> g) {
        return obj -> g.apply((BatchDeleteGeofenceError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BatchItemError error;
        private String geofenceId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteGeofenceError model) {
            this.error(model.error);
            this.geofenceId(model.geofenceId);
        }

        public final BatchItemError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        @Override
        public final Builder error(BatchItemError error) {
            this.error = error;
            return this;
        }

        public final void setError(BatchItemError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        public final String getGeofenceId() {
            return this.geofenceId;
        }

        @Override
        public final Builder geofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
            return this;
        }

        public final void setGeofenceId(String geofenceId) {
            this.geofenceId = geofenceId;
        }

        public BatchDeleteGeofenceError build() {
            return new BatchDeleteGeofenceError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDeleteGeofenceError> {
        public Builder error(BatchItemError var1);

        default public Builder error(Consumer<BatchItemError.Builder> error) {
            return this.error((BatchItemError)((BatchItemError.Builder)BatchItemError.builder().applyMutation(error)).build());
        }

        public Builder geofenceId(String var1);
    }
}

