/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.InstancePlatform;
import software.amazon.awssdk.services.lightsail.model.InstancePlatformListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Bundle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Bundle> {
    private static final SdkField<Float> PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(Bundle.getter(Bundle::price)).setter(Bundle.setter(Builder::price)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("price").build()}).build();
    private static final SdkField<Integer> CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Bundle.getter(Bundle::cpuCount)).setter(Bundle.setter(Builder::cpuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCount").build()}).build();
    private static final SdkField<Integer> DISK_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Bundle.getter(Bundle::diskSizeInGb)).setter(Bundle.setter(Builder::diskSizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSizeInGb").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Bundle.getter(Bundle::bundleId)).setter(Bundle.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Bundle.getter(Bundle::instanceType)).setter(Bundle.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Bundle.getter(Bundle::isActive)).setter(Bundle.setter(Builder::isActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Bundle.getter(Bundle::name)).setter(Bundle.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> POWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Bundle.getter(Bundle::power)).setter(Bundle.setter(Builder::power)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("power").build()}).build();
    private static final SdkField<Float> RAM_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(Bundle.getter(Bundle::ramSizeInGb)).setter(Bundle.setter(Builder::ramSizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramSizeInGb").build()}).build();
    private static final SdkField<Integer> TRANSFER_PER_MONTH_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Bundle.getter(Bundle::transferPerMonthInGb)).setter(Bundle.setter(Builder::transferPerMonthInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferPerMonthInGb").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Bundle.getter(Bundle::supportedPlatformsAsStrings)).setter(Bundle.setter(Builder::supportedPlatformsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedPlatforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICE_FIELD, CPU_COUNT_FIELD, DISK_SIZE_IN_GB_FIELD, BUNDLE_ID_FIELD, INSTANCE_TYPE_FIELD, IS_ACTIVE_FIELD, NAME_FIELD, POWER_FIELD, RAM_SIZE_IN_GB_FIELD, TRANSFER_PER_MONTH_IN_GB_FIELD, SUPPORTED_PLATFORMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float price;
    private final Integer cpuCount;
    private final Integer diskSizeInGb;
    private final String bundleId;
    private final String instanceType;
    private final Boolean isActive;
    private final String name;
    private final Integer power;
    private final Float ramSizeInGb;
    private final Integer transferPerMonthInGb;
    private final List<String> supportedPlatforms;

    private Bundle(BuilderImpl builder) {
        this.price = builder.price;
        this.cpuCount = builder.cpuCount;
        this.diskSizeInGb = builder.diskSizeInGb;
        this.bundleId = builder.bundleId;
        this.instanceType = builder.instanceType;
        this.isActive = builder.isActive;
        this.name = builder.name;
        this.power = builder.power;
        this.ramSizeInGb = builder.ramSizeInGb;
        this.transferPerMonthInGb = builder.transferPerMonthInGb;
        this.supportedPlatforms = builder.supportedPlatforms;
    }

    public Float price() {
        return this.price;
    }

    public Integer cpuCount() {
        return this.cpuCount;
    }

    public Integer diskSizeInGb() {
        return this.diskSizeInGb;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Boolean isActive() {
        return this.isActive;
    }

    public String name() {
        return this.name;
    }

    public Integer power() {
        return this.power;
    }

    public Float ramSizeInGb() {
        return this.ramSizeInGb;
    }

    public Integer transferPerMonthInGb() {
        return this.transferPerMonthInGb;
    }

    public List<InstancePlatform> supportedPlatforms() {
        return InstancePlatformListCopier.copyStringToEnum(this.supportedPlatforms);
    }

    public List<String> supportedPlatformsAsStrings() {
        return this.supportedPlatforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.price());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActive());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.power());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferPerMonthInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedPlatformsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bundle)) {
            return false;
        }
        Bundle other = (Bundle)obj;
        return Objects.equals(this.price(), other.price()) && Objects.equals(this.cpuCount(), other.cpuCount()) && Objects.equals(this.diskSizeInGb(), other.diskSizeInGb()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.isActive(), other.isActive()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.power(), other.power()) && Objects.equals(this.ramSizeInGb(), other.ramSizeInGb()) && Objects.equals(this.transferPerMonthInGb(), other.transferPerMonthInGb()) && Objects.equals(this.supportedPlatformsAsStrings(), other.supportedPlatformsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"Bundle").add("Price", (Object)this.price()).add("CpuCount", (Object)this.cpuCount()).add("DiskSizeInGb", (Object)this.diskSizeInGb()).add("BundleId", (Object)this.bundleId()).add("InstanceType", (Object)this.instanceType()).add("IsActive", (Object)this.isActive()).add("Name", (Object)this.name()).add("Power", (Object)this.power()).add("RamSizeInGb", (Object)this.ramSizeInGb()).add("TransferPerMonthInGb", (Object)this.transferPerMonthInGb()).add("SupportedPlatforms", this.supportedPlatformsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "price": {
                return Optional.ofNullable(clazz.cast(this.price()));
            }
            case "cpuCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCount()));
            }
            case "diskSizeInGb": {
                return Optional.ofNullable(clazz.cast(this.diskSizeInGb()));
            }
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "isActive": {
                return Optional.ofNullable(clazz.cast(this.isActive()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "power": {
                return Optional.ofNullable(clazz.cast(this.power()));
            }
            case "ramSizeInGb": {
                return Optional.ofNullable(clazz.cast(this.ramSizeInGb()));
            }
            case "transferPerMonthInGb": {
                return Optional.ofNullable(clazz.cast(this.transferPerMonthInGb()));
            }
            case "supportedPlatforms": {
                return Optional.ofNullable(clazz.cast(this.supportedPlatformsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Bundle, T> g) {
        return obj -> g.apply((Bundle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float price;
        private Integer cpuCount;
        private Integer diskSizeInGb;
        private String bundleId;
        private String instanceType;
        private Boolean isActive;
        private String name;
        private Integer power;
        private Float ramSizeInGb;
        private Integer transferPerMonthInGb;
        private List<String> supportedPlatforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Bundle model) {
            this.price(model.price);
            this.cpuCount(model.cpuCount);
            this.diskSizeInGb(model.diskSizeInGb);
            this.bundleId(model.bundleId);
            this.instanceType(model.instanceType);
            this.isActive(model.isActive);
            this.name(model.name);
            this.power(model.power);
            this.ramSizeInGb(model.ramSizeInGb);
            this.transferPerMonthInGb(model.transferPerMonthInGb);
            this.supportedPlatformsWithStrings(model.supportedPlatforms);
        }

        public final Float getPrice() {
            return this.price;
        }

        @Override
        public final Builder price(Float price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Float price) {
            this.price = price;
        }

        public final Integer getCpuCount() {
            return this.cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Integer getDiskSizeInGb() {
            return this.diskSizeInGb;
        }

        @Override
        public final Builder diskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
            return this;
        }

        public final void setDiskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Boolean getIsActive() {
            return this.isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPower() {
            return this.power;
        }

        @Override
        public final Builder power(Integer power) {
            this.power = power;
            return this;
        }

        public final void setPower(Integer power) {
            this.power = power;
        }

        public final Float getRamSizeInGb() {
            return this.ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        public final Integer getTransferPerMonthInGb() {
            return this.transferPerMonthInGb;
        }

        @Override
        public final Builder transferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
            return this;
        }

        public final void setTransferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
        }

        public final Collection<String> getSupportedPlatformsAsStrings() {
            return this.supportedPlatforms;
        }

        @Override
        public final Builder supportedPlatformsWithStrings(Collection<String> supportedPlatforms) {
            this.supportedPlatforms = InstancePlatformListCopier.copy(supportedPlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPlatformsWithStrings(String ... supportedPlatforms) {
            this.supportedPlatformsWithStrings(Arrays.asList(supportedPlatforms));
            return this;
        }

        @Override
        public final Builder supportedPlatforms(Collection<InstancePlatform> supportedPlatforms) {
            this.supportedPlatforms = InstancePlatformListCopier.copyEnumToString(supportedPlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPlatforms(InstancePlatform ... supportedPlatforms) {
            this.supportedPlatforms(Arrays.asList(supportedPlatforms));
            return this;
        }

        public final void setSupportedPlatformsWithStrings(Collection<String> supportedPlatforms) {
            this.supportedPlatforms = InstancePlatformListCopier.copy(supportedPlatforms);
        }

        public Bundle build() {
            return new Bundle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Bundle> {
        public Builder price(Float var1);

        public Builder cpuCount(Integer var1);

        public Builder diskSizeInGb(Integer var1);

        public Builder bundleId(String var1);

        public Builder instanceType(String var1);

        public Builder isActive(Boolean var1);

        public Builder name(String var1);

        public Builder power(Integer var1);

        public Builder ramSizeInGb(Float var1);

        public Builder transferPerMonthInGb(Integer var1);

        public Builder supportedPlatformsWithStrings(Collection<String> var1);

        public Builder supportedPlatformsWithStrings(String ... var1);

        public Builder supportedPlatforms(Collection<InstancePlatform> var1);

        public Builder supportedPlatforms(InstancePlatform ... var1);
    }
}

