/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerTlsCertificateDomainValidationRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancerTlsCertificateDomainValidationRecord> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(LoadBalancerTlsCertificateDomainValidationRecord.getter(LoadBalancerTlsCertificateDomainValidationRecord::name)).setter(LoadBalancerTlsCertificateDomainValidationRecord.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(LoadBalancerTlsCertificateDomainValidationRecord.getter(LoadBalancerTlsCertificateDomainValidationRecord::type)).setter(LoadBalancerTlsCertificateDomainValidationRecord.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(LoadBalancerTlsCertificateDomainValidationRecord.getter(LoadBalancerTlsCertificateDomainValidationRecord::value)).setter(LoadBalancerTlsCertificateDomainValidationRecord.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationStatus").getter(LoadBalancerTlsCertificateDomainValidationRecord.getter(LoadBalancerTlsCertificateDomainValidationRecord::validationStatusAsString)).setter(LoadBalancerTlsCertificateDomainValidationRecord.setter(Builder::validationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationStatus").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(LoadBalancerTlsCertificateDomainValidationRecord.getter(LoadBalancerTlsCertificateDomainValidationRecord::domainName)).setter(LoadBalancerTlsCertificateDomainValidationRecord.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<LoadBalancerTlsCertificateDnsRecordCreationState> DNS_RECORD_CREATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dnsRecordCreationState").getter(LoadBalancerTlsCertificateDomainValidationRecord.getter(LoadBalancerTlsCertificateDomainValidationRecord::dnsRecordCreationState)).setter(LoadBalancerTlsCertificateDomainValidationRecord.setter(Builder::dnsRecordCreationState)).constructor(LoadBalancerTlsCertificateDnsRecordCreationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsRecordCreationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, VALUE_FIELD, VALIDATION_STATUS_FIELD, DOMAIN_NAME_FIELD, DNS_RECORD_CREATION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LoadBalancerTlsCertificateDomainValidationRecord.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String value;
    private final String validationStatus;
    private final String domainName;
    private final LoadBalancerTlsCertificateDnsRecordCreationState dnsRecordCreationState;

    private LoadBalancerTlsCertificateDomainValidationRecord(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.value = builder.value;
        this.validationStatus = builder.validationStatus;
        this.domainName = builder.domainName;
        this.dnsRecordCreationState = builder.dnsRecordCreationState;
    }

    public final String name() {
        return this.name;
    }

    public final String type() {
        return this.type;
    }

    public final String value() {
        return this.value;
    }

    public final LoadBalancerTlsCertificateDomainStatus validationStatus() {
        return LoadBalancerTlsCertificateDomainStatus.fromValue(this.validationStatus);
    }

    public final String validationStatusAsString() {
        return this.validationStatus;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final LoadBalancerTlsCertificateDnsRecordCreationState dnsRecordCreationState() {
        return this.dnsRecordCreationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsRecordCreationState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificateDomainValidationRecord)) {
            return false;
        }
        LoadBalancerTlsCertificateDomainValidationRecord other = (LoadBalancerTlsCertificateDomainValidationRecord)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.dnsRecordCreationState(), other.dnsRecordCreationState());
    }

    public final String toString() {
        return ToString.builder((String)"LoadBalancerTlsCertificateDomainValidationRecord").add("Name", (Object)this.name()).add("Type", (Object)this.type()).add("Value", (Object)this.value()).add("ValidationStatus", (Object)this.validationStatusAsString()).add("DomainName", (Object)this.domainName()).add("DnsRecordCreationState", (Object)this.dnsRecordCreationState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "validationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "dnsRecordCreationState": {
                return Optional.ofNullable(clazz.cast(this.dnsRecordCreationState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("validationStatus", VALIDATION_STATUS_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("dnsRecordCreationState", DNS_RECORD_CREATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerTlsCertificateDomainValidationRecord, T> g) {
        return obj -> g.apply((LoadBalancerTlsCertificateDomainValidationRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String value;
        private String validationStatus;
        private String domainName;
        private LoadBalancerTlsCertificateDnsRecordCreationState dnsRecordCreationState;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificateDomainValidationRecord model) {
            this.name(model.name);
            this.type(model.type);
            this.value(model.value);
            this.validationStatus(model.validationStatus);
            this.domainName(model.domainName);
            this.dnsRecordCreationState(model.dnsRecordCreationState);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(LoadBalancerTlsCertificateDomainStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final LoadBalancerTlsCertificateDnsRecordCreationState.Builder getDnsRecordCreationState() {
            return this.dnsRecordCreationState != null ? this.dnsRecordCreationState.toBuilder() : null;
        }

        public final void setDnsRecordCreationState(LoadBalancerTlsCertificateDnsRecordCreationState.BuilderImpl dnsRecordCreationState) {
            this.dnsRecordCreationState = dnsRecordCreationState != null ? dnsRecordCreationState.build() : null;
        }

        @Override
        public final Builder dnsRecordCreationState(LoadBalancerTlsCertificateDnsRecordCreationState dnsRecordCreationState) {
            this.dnsRecordCreationState = dnsRecordCreationState;
            return this;
        }

        public LoadBalancerTlsCertificateDomainValidationRecord build() {
            return new LoadBalancerTlsCertificateDomainValidationRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancerTlsCertificateDomainValidationRecord> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder value(String var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(LoadBalancerTlsCertificateDomainStatus var1);

        public Builder domainName(String var1);

        public Builder dnsRecordCreationState(LoadBalancerTlsCertificateDnsRecordCreationState var1);

        default public Builder dnsRecordCreationState(Consumer<LoadBalancerTlsCertificateDnsRecordCreationState.Builder> dnsRecordCreationState) {
            return this.dnsRecordCreationState((LoadBalancerTlsCertificateDnsRecordCreationState)((LoadBalancerTlsCertificateDnsRecordCreationState.Builder)LoadBalancerTlsCertificateDnsRecordCreationState.builder().applyMutation(dnsRecordCreationState)).build());
        }
    }
}

