/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.DistributionMetricName;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.MetricStatistic;
import software.amazon.awssdk.services.lightsail.model.MetricStatisticListCopier;
import software.amazon.awssdk.services.lightsail.model.MetricUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDistributionMetricDataRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetDistributionMetricDataRequest> {
    private static final SdkField<String> DISTRIBUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distributionName").getter(GetDistributionMetricDataRequest.getter(GetDistributionMetricDataRequest::distributionName)).setter(GetDistributionMetricDataRequest.setter(Builder::distributionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionName").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(GetDistributionMetricDataRequest.getter(GetDistributionMetricDataRequest::metricNameAsString)).setter(GetDistributionMetricDataRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetDistributionMetricDataRequest.getter(GetDistributionMetricDataRequest::startTime)).setter(GetDistributionMetricDataRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetDistributionMetricDataRequest.getter(GetDistributionMetricDataRequest::endTime)).setter(GetDistributionMetricDataRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("period").getter(GetDistributionMetricDataRequest.getter(GetDistributionMetricDataRequest::period)).setter(GetDistributionMetricDataRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(GetDistributionMetricDataRequest.getter(GetDistributionMetricDataRequest::unitAsString)).setter(GetDistributionMetricDataRequest.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statistics").getter(GetDistributionMetricDataRequest.getter(GetDistributionMetricDataRequest::statisticsAsStrings)).setter(GetDistributionMetricDataRequest.setter(Builder::statisticsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_NAME_FIELD, METRIC_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERIOD_FIELD, UNIT_FIELD, STATISTICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("distributionName", DISTRIBUTION_NAME_FIELD);
            this.put("metricName", METRIC_NAME_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("endTime", END_TIME_FIELD);
            this.put("period", PERIOD_FIELD);
            this.put("unit", UNIT_FIELD);
            this.put("statistics", STATISTICS_FIELD);
        }
    });
    private final String distributionName;
    private final String metricName;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer period;
    private final String unit;
    private final List<String> statistics;

    private GetDistributionMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.distributionName = builder.distributionName;
        this.metricName = builder.metricName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.period = builder.period;
        this.unit = builder.unit;
        this.statistics = builder.statistics;
    }

    public final String distributionName() {
        return this.distributionName;
    }

    public final DistributionMetricName metricName() {
        return DistributionMetricName.fromValue(this.metricName);
    }

    public final String metricNameAsString() {
        return this.metricName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer period() {
        return this.period;
    }

    public final MetricUnit unit() {
        return MetricUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final List<MetricStatistic> statistics() {
        return MetricStatisticListCopier.copyStringToEnum(this.statistics);
    }

    public final boolean hasStatistics() {
        return this.statistics != null && !(this.statistics instanceof SdkAutoConstructList);
    }

    public final List<String> statisticsAsStrings() {
        return this.statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatistics() ? this.statisticsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionMetricDataRequest)) {
            return false;
        }
        GetDistributionMetricDataRequest other = (GetDistributionMetricDataRequest)((Object)obj);
        return Objects.equals(this.distributionName(), other.distributionName()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.unitAsString(), other.unitAsString()) && this.hasStatistics() == other.hasStatistics() && Objects.equals(this.statisticsAsStrings(), other.statisticsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetDistributionMetricDataRequest").add("DistributionName", (Object)this.distributionName()).add("MetricName", (Object)this.metricNameAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Period", (Object)this.period()).add("Unit", (Object)this.unitAsString()).add("Statistics", this.hasStatistics() ? this.statisticsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "distributionName": {
                return Optional.ofNullable(clazz.cast(this.distributionName()));
            }
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statisticsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionMetricDataRequest, T> g) {
        return obj -> g.apply((GetDistributionMetricDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String distributionName;
        private String metricName;
        private Instant startTime;
        private Instant endTime;
        private Integer period;
        private String unit;
        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionMetricDataRequest model) {
            super(model);
            this.distributionName(model.distributionName);
            this.metricName(model.metricName);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.period(model.period);
            this.unit(model.unit);
            this.statisticsWithStrings(model.statistics);
        }

        public final String getDistributionName() {
            return this.distributionName;
        }

        public final void setDistributionName(String distributionName) {
            this.distributionName = distributionName;
        }

        @Override
        public final Builder distributionName(String distributionName) {
            this.distributionName = distributionName;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(DistributionMetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Collection<String> getStatistics() {
            if (this.statistics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statistics;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String ... statistics) {
            this.statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<MetricStatistic> statistics) {
            this.statistics = MetricStatisticListCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(MetricStatistic ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDistributionMetricDataRequest build() {
            return new GetDistributionMetricDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDistributionMetricDataRequest> {
        public Builder distributionName(String var1);

        public Builder metricName(String var1);

        public Builder metricName(DistributionMetricName var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder period(Integer var1);

        public Builder unit(String var1);

        public Builder unit(MetricUnit var1);

        public Builder statisticsWithStrings(Collection<String> var1);

        public Builder statisticsWithStrings(String ... var1);

        public Builder statistics(Collection<MetricStatistic> var1);

        public Builder statistics(MetricStatistic ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

