/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.MetricDatapoint;
import software.amazon.awssdk.services.lightsail.model.MetricDatapointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContainerServiceMetricDataResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetContainerServiceMetricDataResponse> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(GetContainerServiceMetricDataResponse.getter(GetContainerServiceMetricDataResponse::metricNameAsString)).setter(GetContainerServiceMetricDataResponse.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<List<MetricDatapoint>> METRIC_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricData").getter(GetContainerServiceMetricDataResponse.getter(GetContainerServiceMetricDataResponse::metricData)).setter(GetContainerServiceMetricDataResponse.setter(Builder::metricData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDatapoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, METRIC_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("metricName", METRIC_NAME_FIELD);
            this.put("metricData", METRIC_DATA_FIELD);
        }
    });
    private final String metricName;
    private final List<MetricDatapoint> metricData;

    private GetContainerServiceMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.metricData = builder.metricData;
    }

    public final ContainerServiceMetricName metricName() {
        return ContainerServiceMetricName.fromValue(this.metricName);
    }

    public final String metricNameAsString() {
        return this.metricName;
    }

    public final boolean hasMetricData() {
        return this.metricData != null && !(this.metricData instanceof SdkAutoConstructList);
    }

    public final List<MetricDatapoint> metricData() {
        return this.metricData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricData() ? this.metricData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerServiceMetricDataResponse)) {
            return false;
        }
        GetContainerServiceMetricDataResponse other = (GetContainerServiceMetricDataResponse)((Object)obj);
        return Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && this.hasMetricData() == other.hasMetricData() && Objects.equals(this.metricData(), other.metricData());
    }

    public final String toString() {
        return ToString.builder((String)"GetContainerServiceMetricDataResponse").add("MetricName", (Object)this.metricNameAsString()).add("MetricData", this.hasMetricData() ? this.metricData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "metricData": {
                return Optional.ofNullable(clazz.cast(this.metricData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerServiceMetricDataResponse, T> g) {
        return obj -> g.apply((GetContainerServiceMetricDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private String metricName;
        private List<MetricDatapoint> metricData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerServiceMetricDataResponse model) {
            super(model);
            this.metricName(model.metricName);
            this.metricData(model.metricData);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(ContainerServiceMetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final List<MetricDatapoint.Builder> getMetricData() {
            List<MetricDatapoint.Builder> result = MetricDatapointListCopier.copyToBuilder(this.metricData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricData(Collection<MetricDatapoint.BuilderImpl> metricData) {
            this.metricData = MetricDatapointListCopier.copyFromBuilder(metricData);
        }

        @Override
        public final Builder metricData(Collection<MetricDatapoint> metricData) {
            this.metricData = MetricDatapointListCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatapoint ... metricData) {
            this.metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(Consumer<MetricDatapoint.Builder> ... metricData) {
            this.metricData(Stream.of(metricData).map(c -> (MetricDatapoint)((MetricDatapoint.Builder)MetricDatapoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetContainerServiceMetricDataResponse build() {
            return new GetContainerServiceMetricDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContainerServiceMetricDataResponse> {
        public Builder metricName(String var1);

        public Builder metricName(ContainerServiceMetricName var1);

        public Builder metricData(Collection<MetricDatapoint> var1);

        public Builder metricData(MetricDatapoint ... var1);

        public Builder metricData(Consumer<MetricDatapoint.Builder> ... var1);
    }
}

