/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.Currency;
import software.amazon.awssdk.services.lightsail.model.PricingUnit;
import software.amazon.awssdk.services.lightsail.model.TimePeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EstimateByTime
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EstimateByTime> {
    private static final SdkField<Double> USAGE_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("usageCost").getter(EstimateByTime.getter(EstimateByTime::usageCost)).setter(EstimateByTime.setter(Builder::usageCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageCost").build()}).build();
    private static final SdkField<String> PRICING_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pricingUnit").getter(EstimateByTime.getter(EstimateByTime::pricingUnitAsString)).setter(EstimateByTime.setter(Builder::pricingUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricingUnit").build()}).build();
    private static final SdkField<Double> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("unit").getter(EstimateByTime.getter(EstimateByTime::unit)).setter(EstimateByTime.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currency").getter(EstimateByTime.getter(EstimateByTime::currencyAsString)).setter(EstimateByTime.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<TimePeriod> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timePeriod").getter(EstimateByTime.getter(EstimateByTime::timePeriod)).setter(EstimateByTime.setter(Builder::timePeriod)).constructor(TimePeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_COST_FIELD, PRICING_UNIT_FIELD, UNIT_FIELD, CURRENCY_FIELD, TIME_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("usageCost", USAGE_COST_FIELD);
            this.put("pricingUnit", PRICING_UNIT_FIELD);
            this.put("unit", UNIT_FIELD);
            this.put("currency", CURRENCY_FIELD);
            this.put("timePeriod", TIME_PERIOD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double usageCost;
    private final String pricingUnit;
    private final Double unit;
    private final String currency;
    private final TimePeriod timePeriod;

    private EstimateByTime(BuilderImpl builder) {
        this.usageCost = builder.usageCost;
        this.pricingUnit = builder.pricingUnit;
        this.unit = builder.unit;
        this.currency = builder.currency;
        this.timePeriod = builder.timePeriod;
    }

    public final Double usageCost() {
        return this.usageCost;
    }

    public final PricingUnit pricingUnit() {
        return PricingUnit.fromValue(this.pricingUnit);
    }

    public final String pricingUnitAsString() {
        return this.pricingUnit;
    }

    public final Double unit() {
        return this.unit;
    }

    public final Currency currency() {
        return Currency.fromValue(this.currency);
    }

    public final String currencyAsString() {
        return this.currency;
    }

    public final TimePeriod timePeriod() {
        return this.timePeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usageCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EstimateByTime)) {
            return false;
        }
        EstimateByTime other = (EstimateByTime)obj;
        return Objects.equals(this.usageCost(), other.usageCost()) && Objects.equals(this.pricingUnitAsString(), other.pricingUnitAsString()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.currencyAsString(), other.currencyAsString()) && Objects.equals(this.timePeriod(), other.timePeriod());
    }

    public final String toString() {
        return ToString.builder((String)"EstimateByTime").add("UsageCost", (Object)this.usageCost()).add("PricingUnit", (Object)this.pricingUnitAsString()).add("Unit", (Object)this.unit()).add("Currency", (Object)this.currencyAsString()).add("TimePeriod", (Object)this.timePeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "usageCost": {
                return Optional.ofNullable(clazz.cast(this.usageCost()));
            }
            case "pricingUnit": {
                return Optional.ofNullable(clazz.cast(this.pricingUnitAsString()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currencyAsString()));
            }
            case "timePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EstimateByTime, T> g) {
        return obj -> g.apply((EstimateByTime)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double usageCost;
        private String pricingUnit;
        private Double unit;
        private String currency;
        private TimePeriod timePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(EstimateByTime model) {
            this.usageCost(model.usageCost);
            this.pricingUnit(model.pricingUnit);
            this.unit(model.unit);
            this.currency(model.currency);
            this.timePeriod(model.timePeriod);
        }

        public final Double getUsageCost() {
            return this.usageCost;
        }

        public final void setUsageCost(Double usageCost) {
            this.usageCost = usageCost;
        }

        @Override
        public final Builder usageCost(Double usageCost) {
            this.usageCost = usageCost;
            return this;
        }

        public final String getPricingUnit() {
            return this.pricingUnit;
        }

        public final void setPricingUnit(String pricingUnit) {
            this.pricingUnit = pricingUnit;
        }

        @Override
        public final Builder pricingUnit(String pricingUnit) {
            this.pricingUnit = pricingUnit;
            return this;
        }

        @Override
        public final Builder pricingUnit(PricingUnit pricingUnit) {
            this.pricingUnit(pricingUnit == null ? null : pricingUnit.toString());
            return this;
        }

        public final Double getUnit() {
            return this.unit;
        }

        public final void setUnit(Double unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(Double unit) {
            this.unit = unit;
            return this;
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(Currency currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final TimePeriod.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(TimePeriod.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(TimePeriod timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public EstimateByTime build() {
            return new EstimateByTime(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EstimateByTime> {
        public Builder usageCost(Double var1);

        public Builder pricingUnit(String var1);

        public Builder pricingUnit(PricingUnit var1);

        public Builder unit(Double var1);

        public Builder currency(String var1);

        public Builder currency(Currency var1);

        public Builder timePeriod(TimePeriod var1);

        default public Builder timePeriod(Consumer<TimePeriod.Builder> timePeriod) {
            return this.timePeriod((TimePeriod)((TimePeriod.Builder)TimePeriod.builder().applyMutation(timePeriod)).build());
        }
    }
}

