/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.Disk;
import software.amazon.awssdk.services.lightsail.model.DiskListCopier;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshotState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceSnapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceSnapshot> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(InstanceSnapshot.getter(InstanceSnapshot::name)).setter(InstanceSnapshot.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(InstanceSnapshot.getter(InstanceSnapshot::arn)).setter(InstanceSnapshot.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("supportCode").getter(InstanceSnapshot.getter(InstanceSnapshot::supportCode)).setter(InstanceSnapshot.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(InstanceSnapshot.getter(InstanceSnapshot::createdAt)).setter(InstanceSnapshot.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(InstanceSnapshot.getter(InstanceSnapshot::location)).setter(InstanceSnapshot.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(InstanceSnapshot.getter(InstanceSnapshot::resourceTypeAsString)).setter(InstanceSnapshot.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(InstanceSnapshot.getter(InstanceSnapshot::tags)).setter(InstanceSnapshot.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(InstanceSnapshot.getter(InstanceSnapshot::stateAsString)).setter(InstanceSnapshot.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("progress").getter(InstanceSnapshot.getter(InstanceSnapshot::progress)).setter(InstanceSnapshot.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progress").build()}).build();
    private static final SdkField<List<Disk>> FROM_ATTACHED_DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fromAttachedDisks").getter(InstanceSnapshot.getter(InstanceSnapshot::fromAttachedDisks)).setter(InstanceSnapshot.setter(Builder::fromAttachedDisks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromAttachedDisks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Disk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FROM_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fromInstanceName").getter(InstanceSnapshot.getter(InstanceSnapshot::fromInstanceName)).setter(InstanceSnapshot.setter(Builder::fromInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromInstanceName").build()}).build();
    private static final SdkField<String> FROM_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fromInstanceArn").getter(InstanceSnapshot.getter(InstanceSnapshot::fromInstanceArn)).setter(InstanceSnapshot.setter(Builder::fromInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromInstanceArn").build()}).build();
    private static final SdkField<String> FROM_BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fromBlueprintId").getter(InstanceSnapshot.getter(InstanceSnapshot::fromBlueprintId)).setter(InstanceSnapshot.setter(Builder::fromBlueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromBlueprintId").build()}).build();
    private static final SdkField<String> FROM_BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fromBundleId").getter(InstanceSnapshot.getter(InstanceSnapshot::fromBundleId)).setter(InstanceSnapshot.setter(Builder::fromBundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromBundleId").build()}).build();
    private static final SdkField<Boolean> IS_FROM_AUTO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isFromAutoSnapshot").getter(InstanceSnapshot.getter(InstanceSnapshot::isFromAutoSnapshot)).setter(InstanceSnapshot.setter(Builder::isFromAutoSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isFromAutoSnapshot").build()}).build();
    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sizeInGb").getter(InstanceSnapshot.getter(InstanceSnapshot::sizeInGb)).setter(InstanceSnapshot.setter(Builder::sizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, STATE_FIELD, PROGRESS_FIELD, FROM_ATTACHED_DISKS_FIELD, FROM_INSTANCE_NAME_FIELD, FROM_INSTANCE_ARN_FIELD, FROM_BLUEPRINT_ID_FIELD, FROM_BUNDLE_ID_FIELD, IS_FROM_AUTO_SNAPSHOT_FIELD, SIZE_IN_GB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("supportCode", SUPPORT_CODE_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("location", LOCATION_FIELD);
            this.put("resourceType", RESOURCE_TYPE_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("state", STATE_FIELD);
            this.put("progress", PROGRESS_FIELD);
            this.put("fromAttachedDisks", FROM_ATTACHED_DISKS_FIELD);
            this.put("fromInstanceName", FROM_INSTANCE_NAME_FIELD);
            this.put("fromInstanceArn", FROM_INSTANCE_ARN_FIELD);
            this.put("fromBlueprintId", FROM_BLUEPRINT_ID_FIELD);
            this.put("fromBundleId", FROM_BUNDLE_ID_FIELD);
            this.put("isFromAutoSnapshot", IS_FROM_AUTO_SNAPSHOT_FIELD);
            this.put("sizeInGb", SIZE_IN_GB_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final List<Tag> tags;
    private final String state;
    private final String progress;
    private final List<Disk> fromAttachedDisks;
    private final String fromInstanceName;
    private final String fromInstanceArn;
    private final String fromBlueprintId;
    private final String fromBundleId;
    private final Boolean isFromAutoSnapshot;
    private final Integer sizeInGb;

    private InstanceSnapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.state = builder.state;
        this.progress = builder.progress;
        this.fromAttachedDisks = builder.fromAttachedDisks;
        this.fromInstanceName = builder.fromInstanceName;
        this.fromInstanceArn = builder.fromInstanceArn;
        this.fromBlueprintId = builder.fromBlueprintId;
        this.fromBundleId = builder.fromBundleId;
        this.isFromAutoSnapshot = builder.isFromAutoSnapshot;
        this.sizeInGb = builder.sizeInGb;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String supportCode() {
        return this.supportCode;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ResourceLocation location() {
        return this.location;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final InstanceSnapshotState state() {
        return InstanceSnapshotState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String progress() {
        return this.progress;
    }

    public final boolean hasFromAttachedDisks() {
        return this.fromAttachedDisks != null && !(this.fromAttachedDisks instanceof SdkAutoConstructList);
    }

    public final List<Disk> fromAttachedDisks() {
        return this.fromAttachedDisks;
    }

    public final String fromInstanceName() {
        return this.fromInstanceName;
    }

    public final String fromInstanceArn() {
        return this.fromInstanceArn;
    }

    public final String fromBlueprintId() {
        return this.fromBlueprintId;
    }

    public final String fromBundleId() {
        return this.fromBundleId;
    }

    public final Boolean isFromAutoSnapshot() {
        return this.isFromAutoSnapshot;
    }

    public final Integer sizeInGb() {
        return this.sizeInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFromAttachedDisks() ? this.fromAttachedDisks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fromInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromBundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isFromAutoSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSnapshot)) {
            return false;
        }
        InstanceSnapshot other = (InstanceSnapshot)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.progress(), other.progress()) && this.hasFromAttachedDisks() == other.hasFromAttachedDisks() && Objects.equals(this.fromAttachedDisks(), other.fromAttachedDisks()) && Objects.equals(this.fromInstanceName(), other.fromInstanceName()) && Objects.equals(this.fromInstanceArn(), other.fromInstanceArn()) && Objects.equals(this.fromBlueprintId(), other.fromBlueprintId()) && Objects.equals(this.fromBundleId(), other.fromBundleId()) && Objects.equals(this.isFromAutoSnapshot(), other.isFromAutoSnapshot()) && Objects.equals(this.sizeInGb(), other.sizeInGb());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceSnapshot").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("State", (Object)this.stateAsString()).add("Progress", (Object)this.progress()).add("FromAttachedDisks", this.hasFromAttachedDisks() ? this.fromAttachedDisks() : null).add("FromInstanceName", (Object)this.fromInstanceName()).add("FromInstanceArn", (Object)this.fromInstanceArn()).add("FromBlueprintId", (Object)this.fromBlueprintId()).add("FromBundleId", (Object)this.fromBundleId()).add("IsFromAutoSnapshot", (Object)this.isFromAutoSnapshot()).add("SizeInGb", (Object)this.sizeInGb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "fromAttachedDisks": {
                return Optional.ofNullable(clazz.cast(this.fromAttachedDisks()));
            }
            case "fromInstanceName": {
                return Optional.ofNullable(clazz.cast(this.fromInstanceName()));
            }
            case "fromInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.fromInstanceArn()));
            }
            case "fromBlueprintId": {
                return Optional.ofNullable(clazz.cast(this.fromBlueprintId()));
            }
            case "fromBundleId": {
                return Optional.ofNullable(clazz.cast(this.fromBundleId()));
            }
            case "isFromAutoSnapshot": {
                return Optional.ofNullable(clazz.cast(this.isFromAutoSnapshot()));
            }
            case "sizeInGb": {
                return Optional.ofNullable(clazz.cast(this.sizeInGb()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceSnapshot, T> g) {
        return obj -> g.apply((InstanceSnapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private String progress;
        private List<Disk> fromAttachedDisks = DefaultSdkAutoConstructList.getInstance();
        private String fromInstanceName;
        private String fromInstanceArn;
        private String fromBlueprintId;
        private String fromBundleId;
        private Boolean isFromAutoSnapshot;
        private Integer sizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSnapshot model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.tags(model.tags);
            this.state(model.state);
            this.progress(model.progress);
            this.fromAttachedDisks(model.fromAttachedDisks);
            this.fromInstanceName(model.fromInstanceName);
            this.fromInstanceArn(model.fromInstanceArn);
            this.fromBlueprintId(model.fromBlueprintId);
            this.fromBundleId(model.fromBundleId);
            this.isFromAutoSnapshot(model.isFromAutoSnapshot);
            this.sizeInGb(model.sizeInGb);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceSnapshotState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getProgress() {
            return this.progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final List<Disk.Builder> getFromAttachedDisks() {
            List<Disk.Builder> result = DiskListCopier.copyToBuilder(this.fromAttachedDisks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFromAttachedDisks(Collection<Disk.BuilderImpl> fromAttachedDisks) {
            this.fromAttachedDisks = DiskListCopier.copyFromBuilder(fromAttachedDisks);
        }

        @Override
        public final Builder fromAttachedDisks(Collection<Disk> fromAttachedDisks) {
            this.fromAttachedDisks = DiskListCopier.copy(fromAttachedDisks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromAttachedDisks(Disk ... fromAttachedDisks) {
            this.fromAttachedDisks(Arrays.asList(fromAttachedDisks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromAttachedDisks(Consumer<Disk.Builder> ... fromAttachedDisks) {
            this.fromAttachedDisks(Stream.of(fromAttachedDisks).map(c -> (Disk)((Disk.Builder)Disk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFromInstanceName() {
            return this.fromInstanceName;
        }

        public final void setFromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
        }

        @Override
        public final Builder fromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
            return this;
        }

        public final String getFromInstanceArn() {
            return this.fromInstanceArn;
        }

        public final void setFromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
        }

        @Override
        public final Builder fromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
            return this;
        }

        public final String getFromBlueprintId() {
            return this.fromBlueprintId;
        }

        public final void setFromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
        }

        @Override
        public final Builder fromBlueprintId(String fromBlueprintId) {
            this.fromBlueprintId = fromBlueprintId;
            return this;
        }

        public final String getFromBundleId() {
            return this.fromBundleId;
        }

        public final void setFromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
        }

        @Override
        public final Builder fromBundleId(String fromBundleId) {
            this.fromBundleId = fromBundleId;
            return this;
        }

        public final Boolean getIsFromAutoSnapshot() {
            return this.isFromAutoSnapshot;
        }

        public final void setIsFromAutoSnapshot(Boolean isFromAutoSnapshot) {
            this.isFromAutoSnapshot = isFromAutoSnapshot;
        }

        @Override
        public final Builder isFromAutoSnapshot(Boolean isFromAutoSnapshot) {
            this.isFromAutoSnapshot = isFromAutoSnapshot;
            return this;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public InstanceSnapshot build() {
            return new InstanceSnapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceSnapshot> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(InstanceSnapshotState var1);

        public Builder progress(String var1);

        public Builder fromAttachedDisks(Collection<Disk> var1);

        public Builder fromAttachedDisks(Disk ... var1);

        public Builder fromAttachedDisks(Consumer<Disk.Builder> ... var1);

        public Builder fromInstanceName(String var1);

        public Builder fromInstanceArn(String var1);

        public Builder fromBlueprintId(String var1);

        public Builder fromBundleId(String var1);

        public Builder isFromAutoSnapshot(Boolean var1);

        public Builder sizeInGb(Integer var1);
    }
}

