/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsPolicy;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsPolicyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLoadBalancerTlsPoliciesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetLoadBalancerTlsPoliciesResponse> {
    private static final SdkField<List<LoadBalancerTlsPolicy>> TLS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tlsPolicies").getter(GetLoadBalancerTlsPoliciesResponse.getter(GetLoadBalancerTlsPoliciesResponse::tlsPolicies)).setter(GetLoadBalancerTlsPoliciesResponse.setter(Builder::tlsPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tlsPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancerTlsPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetLoadBalancerTlsPoliciesResponse.getter(GetLoadBalancerTlsPoliciesResponse::nextPageToken)).setter(GetLoadBalancerTlsPoliciesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TLS_POLICIES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("tlsPolicies", TLS_POLICIES_FIELD);
            this.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        }
    });
    private final List<LoadBalancerTlsPolicy> tlsPolicies;
    private final String nextPageToken;

    private GetLoadBalancerTlsPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.tlsPolicies = builder.tlsPolicies;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasTlsPolicies() {
        return this.tlsPolicies != null && !(this.tlsPolicies instanceof SdkAutoConstructList);
    }

    public final List<LoadBalancerTlsPolicy> tlsPolicies() {
        return this.tlsPolicies;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTlsPolicies() ? this.tlsPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoadBalancerTlsPoliciesResponse)) {
            return false;
        }
        GetLoadBalancerTlsPoliciesResponse other = (GetLoadBalancerTlsPoliciesResponse)((Object)obj);
        return this.hasTlsPolicies() == other.hasTlsPolicies() && Objects.equals(this.tlsPolicies(), other.tlsPolicies()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetLoadBalancerTlsPoliciesResponse").add("TlsPolicies", this.hasTlsPolicies() ? this.tlsPolicies() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tlsPolicies": {
                return Optional.ofNullable(clazz.cast(this.tlsPolicies()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLoadBalancerTlsPoliciesResponse, T> g) {
        return obj -> g.apply((GetLoadBalancerTlsPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<LoadBalancerTlsPolicy> tlsPolicies = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoadBalancerTlsPoliciesResponse model) {
            super(model);
            this.tlsPolicies(model.tlsPolicies);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<LoadBalancerTlsPolicy.Builder> getTlsPolicies() {
            List<LoadBalancerTlsPolicy.Builder> result = LoadBalancerTlsPolicyListCopier.copyToBuilder(this.tlsPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTlsPolicies(Collection<LoadBalancerTlsPolicy.BuilderImpl> tlsPolicies) {
            this.tlsPolicies = LoadBalancerTlsPolicyListCopier.copyFromBuilder(tlsPolicies);
        }

        @Override
        public final Builder tlsPolicies(Collection<LoadBalancerTlsPolicy> tlsPolicies) {
            this.tlsPolicies = LoadBalancerTlsPolicyListCopier.copy(tlsPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsPolicies(LoadBalancerTlsPolicy ... tlsPolicies) {
            this.tlsPolicies(Arrays.asList(tlsPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsPolicies(Consumer<LoadBalancerTlsPolicy.Builder> ... tlsPolicies) {
            this.tlsPolicies(Stream.of(tlsPolicies).map(c -> (LoadBalancerTlsPolicy)((LoadBalancerTlsPolicy.Builder)LoadBalancerTlsPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetLoadBalancerTlsPoliciesResponse build() {
            return new GetLoadBalancerTlsPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLoadBalancerTlsPoliciesResponse> {
        public Builder tlsPolicies(Collection<LoadBalancerTlsPolicy> var1);

        public Builder tlsPolicies(LoadBalancerTlsPolicy ... var1);

        public Builder tlsPolicies(Consumer<LoadBalancerTlsPolicy.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

