/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed;
import software.amazon.awssdk.services.lightsail.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessKey> {
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessKeyId").getter(AccessKey.getter(AccessKey::accessKeyId)).setter(AccessKey.setter(Builder::accessKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyId").build()}).build();
    private static final SdkField<String> SECRET_ACCESS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretAccessKey").getter(AccessKey.getter(AccessKey::secretAccessKey)).setter(AccessKey.setter(Builder::secretAccessKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretAccessKey").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AccessKey.getter(AccessKey::statusAsString)).setter(AccessKey.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AccessKey.getter(AccessKey::createdAt)).setter(AccessKey.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<AccessKeyLastUsed> LAST_USED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastUsed").getter(AccessKey.getter(AccessKey::lastUsed)).setter(AccessKey.setter(Builder::lastUsed)).constructor(AccessKeyLastUsed::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUsed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_ID_FIELD, SECRET_ACCESS_KEY_FIELD, STATUS_FIELD, CREATED_AT_FIELD, LAST_USED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String status;
    private final Instant createdAt;
    private final AccessKeyLastUsed lastUsed;

    private AccessKey(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.secretAccessKey = builder.secretAccessKey;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUsed = builder.lastUsed;
    }

    public final String accessKeyId() {
        return this.accessKeyId;
    }

    public final String secretAccessKey() {
        return this.secretAccessKey;
    }

    public final StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final AccessKeyLastUsed lastUsed() {
        return this.lastUsed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUsed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessKey)) {
            return false;
        }
        AccessKey other = (AccessKey)obj;
        return Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.secretAccessKey(), other.secretAccessKey()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUsed(), other.lastUsed());
    }

    public final String toString() {
        return ToString.builder((String)"AccessKey").add("AccessKeyId", (Object)(this.accessKeyId() == null ? null : "*** Sensitive Data Redacted ***")).add("SecretAccessKey", (Object)this.secretAccessKey()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("LastUsed", (Object)this.lastUsed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessKeyId": {
                return Optional.ofNullable(clazz.cast(this.accessKeyId()));
            }
            case "secretAccessKey": {
                return Optional.ofNullable(clazz.cast(this.secretAccessKey()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUsed": {
                return Optional.ofNullable(clazz.cast(this.lastUsed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessKey, T> g) {
        return obj -> g.apply((AccessKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessKeyId;
        private String secretAccessKey;
        private String status;
        private Instant createdAt;
        private AccessKeyLastUsed lastUsed;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessKey model) {
            this.accessKeyId(model.accessKeyId);
            this.secretAccessKey(model.secretAccessKey);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.lastUsed(model.lastUsed);
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        @Override
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final AccessKeyLastUsed.Builder getLastUsed() {
            return this.lastUsed != null ? this.lastUsed.toBuilder() : null;
        }

        public final void setLastUsed(AccessKeyLastUsed.BuilderImpl lastUsed) {
            this.lastUsed = lastUsed != null ? lastUsed.build() : null;
        }

        @Override
        public final Builder lastUsed(AccessKeyLastUsed lastUsed) {
            this.lastUsed = lastUsed;
            return this;
        }

        public AccessKey build() {
            return new AccessKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessKey> {
        public Builder accessKeyId(String var1);

        public Builder secretAccessKey(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder createdAt(Instant var1);

        public Builder lastUsed(AccessKeyLastUsed var1);

        default public Builder lastUsed(Consumer<AccessKeyLastUsed.Builder> lastUsed) {
            return this.lastUsed((AccessKeyLastUsed)((AccessKeyLastUsed.Builder)AccessKeyLastUsed.builder().applyMutation(lastUsed)).build());
        }
    }
}

