/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a blueprint (a virtual private server image).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Blueprint implements SdkPojo, Serializable, ToCopyableBuilder<Blueprint.Builder, Blueprint> {
    private static final SdkField<String> BLUEPRINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintId").getter(getter(Blueprint::blueprintId)).setter(setter(Builder::blueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Blueprint::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("group")
            .getter(getter(Blueprint::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Blueprint::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Blueprint::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isActive").getter(getter(Blueprint::isActive)).setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()).build();

    private static final SdkField<Integer> MIN_POWER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minPower").getter(getter(Blueprint::minPower)).setter(setter(Builder::minPower))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minPower").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(Blueprint::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> VERSION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionCode").getter(getter(Blueprint::versionCode)).setter(setter(Builder::versionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionCode").build()).build();

    private static final SdkField<String> PRODUCT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productUrl").getter(getter(Blueprint::productUrl)).setter(setter(Builder::productUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productUrl").build()).build();

    private static final SdkField<String> LICENSE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseUrl").getter(getter(Blueprint::licenseUrl)).setter(setter(Builder::licenseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseUrl").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(Blueprint::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> APP_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appCategory").getter(getter(Blueprint::appCategoryAsString)).setter(setter(Builder::appCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appCategory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ID_FIELD,
            NAME_FIELD, GROUP_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, IS_ACTIVE_FIELD, MIN_POWER_FIELD, VERSION_FIELD,
            VERSION_CODE_FIELD, PRODUCT_URL_FIELD, LICENSE_URL_FIELD, PLATFORM_FIELD, APP_CATEGORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String blueprintId;

    private final String name;

    private final String group;

    private final String type;

    private final String description;

    private final Boolean isActive;

    private final Integer minPower;

    private final String version;

    private final String versionCode;

    private final String productUrl;

    private final String licenseUrl;

    private final String platform;

    private final String appCategory;

    private Blueprint(BuilderImpl builder) {
        this.blueprintId = builder.blueprintId;
        this.name = builder.name;
        this.group = builder.group;
        this.type = builder.type;
        this.description = builder.description;
        this.isActive = builder.isActive;
        this.minPower = builder.minPower;
        this.version = builder.version;
        this.versionCode = builder.versionCode;
        this.productUrl = builder.productUrl;
        this.licenseUrl = builder.licenseUrl;
        this.platform = builder.platform;
        this.appCategory = builder.appCategory;
    }

    /**
     * <p>
     * The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or <code>app_lamp_7_0</code>).
     * </p>
     * 
     * @return The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
     *         <code>app_lamp_7_0</code>).
     */
    public final String blueprintId() {
        return blueprintId;
    }

    /**
     * <p>
     * The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
     * </p>
     * 
     * @return The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The group name of the blueprint (e.g., <code>amazon-linux</code>).
     * </p>
     * 
     * @return The group name of the blueprint (e.g., <code>amazon-linux</code>).
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BlueprintType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
     * @see BlueprintType
     */
    public final BlueprintType type() {
        return BlueprintType.fromValue(type);
    }

    /**
     * <p>
     * The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link BlueprintType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
     * @see BlueprintType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The description of the blueprint.
     * </p>
     * 
     * @return The description of the blueprint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A Boolean value indicating whether the blueprint is active. Inactive blueprints are listed to support customers
     * with existing instances but are not necessarily available for launch of new instances. Blueprints are marked
     * inactive when they become outdated due to operating system updates or new application releases.
     * </p>
     * 
     * @return A Boolean value indicating whether the blueprint is active. Inactive blueprints are listed to support
     *         customers with existing instances but are not necessarily available for launch of new instances.
     *         Blueprints are marked inactive when they become outdated due to operating system updates or new
     *         application releases.
     */
    public final Boolean isActive() {
        return isActive;
    }

    /**
     * <p>
     * The minimum bundle power required to run this blueprint. For example, you need a bundle with a power value of 500
     * or more to create an instance that uses a blueprint with a minimum power value of 500. <code>0</code> indicates
     * that the blueprint runs on all instance sizes.
     * </p>
     * 
     * @return The minimum bundle power required to run this blueprint. For example, you need a bundle with a power
     *         value of 500 or more to create an instance that uses a blueprint with a minimum power value of 500.
     *         <code>0</code> indicates that the blueprint runs on all instance sizes.
     */
    public final Integer minPower() {
        return minPower;
    }

    /**
     * <p>
     * The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
     * </p>
     * 
     * @return The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The version code.
     * </p>
     * 
     * @return The version code.
     */
    public final String versionCode() {
        return versionCode;
    }

    /**
     * <p>
     * The product URL to learn more about the image or blueprint.
     * </p>
     * 
     * @return The product URL to learn more about the image or blueprint.
     */
    public final String productUrl() {
        return productUrl;
    }

    /**
     * <p>
     * The end-user license agreement URL for the image or blueprint.
     * </p>
     * 
     * @return The end-user license agreement URL for the image or blueprint.
     */
    public final String licenseUrl() {
        return licenseUrl;
    }

    /**
     * <p>
     * The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link InstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
     * @see InstancePlatform
     */
    public final InstancePlatform platform() {
        return InstancePlatform.fromValue(platform);
    }

    /**
     * <p>
     * The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link InstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
     * @see InstancePlatform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * Virtual computer blueprints that are supported by Lightsail for Research.
     * </p>
     * <important>
     * <p>
     * This parameter only applies to Lightsail for Research resources.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appCategory} will
     * return {@link AppCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appCategoryAsString}.
     * </p>
     * 
     * @return Virtual computer blueprints that are supported by Lightsail for Research.</p> <important>
     *         <p>
     *         This parameter only applies to Lightsail for Research resources.
     *         </p>
     * @see AppCategory
     */
    public final AppCategory appCategory() {
        return AppCategory.fromValue(appCategory);
    }

    /**
     * <p>
     * Virtual computer blueprints that are supported by Lightsail for Research.
     * </p>
     * <important>
     * <p>
     * This parameter only applies to Lightsail for Research resources.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appCategory} will
     * return {@link AppCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appCategoryAsString}.
     * </p>
     * 
     * @return Virtual computer blueprints that are supported by Lightsail for Research.</p> <important>
     *         <p>
     *         This parameter only applies to Lightsail for Research resources.
     *         </p>
     * @see AppCategory
     */
    public final String appCategoryAsString() {
        return appCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        hashCode = 31 * hashCode + Objects.hashCode(minPower());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(versionCode());
        hashCode = 31 * hashCode + Objects.hashCode(productUrl());
        hashCode = 31 * hashCode + Objects.hashCode(licenseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(appCategoryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint) obj;
        return Objects.equals(blueprintId(), other.blueprintId()) && Objects.equals(name(), other.name())
                && Objects.equals(group(), other.group()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(isActive(), other.isActive())
                && Objects.equals(minPower(), other.minPower()) && Objects.equals(version(), other.version())
                && Objects.equals(versionCode(), other.versionCode()) && Objects.equals(productUrl(), other.productUrl())
                && Objects.equals(licenseUrl(), other.licenseUrl())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(appCategoryAsString(), other.appCategoryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Blueprint").add("BlueprintId", blueprintId()).add("Name", name()).add("Group", group())
                .add("Type", typeAsString()).add("Description", description()).add("IsActive", isActive())
                .add("MinPower", minPower()).add("Version", version()).add("VersionCode", versionCode())
                .add("ProductUrl", productUrl()).add("LicenseUrl", licenseUrl()).add("Platform", platformAsString())
                .add("AppCategory", appCategoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprintId":
            return Optional.ofNullable(clazz.cast(blueprintId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "isActive":
            return Optional.ofNullable(clazz.cast(isActive()));
        case "minPower":
            return Optional.ofNullable(clazz.cast(minPower()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "versionCode":
            return Optional.ofNullable(clazz.cast(versionCode()));
        case "productUrl":
            return Optional.ofNullable(clazz.cast(productUrl()));
        case "licenseUrl":
            return Optional.ofNullable(clazz.cast(licenseUrl()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "appCategory":
            return Optional.ofNullable(clazz.cast(appCategoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Blueprint, T> g) {
        return obj -> g.apply((Blueprint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Blueprint> {
        /**
         * <p>
         * The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
         * <code>app_lamp_7_0</code>).
         * </p>
         * 
         * @param blueprintId
         *        The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
         *        <code>app_lamp_7_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintId(String blueprintId);

        /**
         * <p>
         * The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
         * </p>
         * 
         * @param name
         *        The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The group name of the blueprint (e.g., <code>amazon-linux</code>).
         * </p>
         * 
         * @param group
         *        The group name of the blueprint (e.g., <code>amazon-linux</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * </p>
         * 
         * @param type
         *        The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * @see BlueprintType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * </p>
         * 
         * @param type
         *        The type of the blueprint (e.g., <code>os</code> or <code>app</code>).
         * @see BlueprintType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlueprintType
         */
        Builder type(BlueprintType type);

        /**
         * <p>
         * The description of the blueprint.
         * </p>
         * 
         * @param description
         *        The description of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A Boolean value indicating whether the blueprint is active. Inactive blueprints are listed to support
         * customers with existing instances but are not necessarily available for launch of new instances. Blueprints
         * are marked inactive when they become outdated due to operating system updates or new application releases.
         * </p>
         * 
         * @param isActive
         *        A Boolean value indicating whether the blueprint is active. Inactive blueprints are listed to support
         *        customers with existing instances but are not necessarily available for launch of new instances.
         *        Blueprints are marked inactive when they become outdated due to operating system updates or new
         *        application releases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);

        /**
         * <p>
         * The minimum bundle power required to run this blueprint. For example, you need a bundle with a power value of
         * 500 or more to create an instance that uses a blueprint with a minimum power value of 500. <code>0</code>
         * indicates that the blueprint runs on all instance sizes.
         * </p>
         * 
         * @param minPower
         *        The minimum bundle power required to run this blueprint. For example, you need a bundle with a power
         *        value of 500 or more to create an instance that uses a blueprint with a minimum power value of 500.
         *        <code>0</code> indicates that the blueprint runs on all instance sizes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minPower(Integer minPower);

        /**
         * <p>
         * The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
         * </p>
         * 
         * @param version
         *        The version number of the operating system, application, or stack (e.g., <code>2016.03.0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The version code.
         * </p>
         * 
         * @param versionCode
         *        The version code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionCode(String versionCode);

        /**
         * <p>
         * The product URL to learn more about the image or blueprint.
         * </p>
         * 
         * @param productUrl
         *        The product URL to learn more about the image or blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productUrl(String productUrl);

        /**
         * <p>
         * The end-user license agreement URL for the image or blueprint.
         * </p>
         * 
         * @param licenseUrl
         *        The end-user license agreement URL for the image or blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseUrl(String licenseUrl);

        /**
         * <p>
         * The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
         * </p>
         * 
         * @param platform
         *        The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
         * @see InstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstancePlatform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
         * </p>
         * 
         * @param platform
         *        The operating system platform (either Linux/Unix-based or Windows Server-based) of the blueprint.
         * @see InstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstancePlatform
         */
        Builder platform(InstancePlatform platform);

        /**
         * <p>
         * Virtual computer blueprints that are supported by Lightsail for Research.
         * </p>
         * <important>
         * <p>
         * This parameter only applies to Lightsail for Research resources.
         * </p>
         * </important>
         * 
         * @param appCategory
         *        Virtual computer blueprints that are supported by Lightsail for Research.</p> <important>
         *        <p>
         *        This parameter only applies to Lightsail for Research resources.
         *        </p>
         * @see AppCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppCategory
         */
        Builder appCategory(String appCategory);

        /**
         * <p>
         * Virtual computer blueprints that are supported by Lightsail for Research.
         * </p>
         * <important>
         * <p>
         * This parameter only applies to Lightsail for Research resources.
         * </p>
         * </important>
         * 
         * @param appCategory
         *        Virtual computer blueprints that are supported by Lightsail for Research.</p> <important>
         *        <p>
         *        This parameter only applies to Lightsail for Research resources.
         *        </p>
         * @see AppCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppCategory
         */
        Builder appCategory(AppCategory appCategory);
    }

    static final class BuilderImpl implements Builder {
        private String blueprintId;

        private String name;

        private String group;

        private String type;

        private String description;

        private Boolean isActive;

        private Integer minPower;

        private String version;

        private String versionCode;

        private String productUrl;

        private String licenseUrl;

        private String platform;

        private String appCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(Blueprint model) {
            blueprintId(model.blueprintId);
            name(model.name);
            group(model.group);
            type(model.type);
            description(model.description);
            isActive(model.isActive);
            minPower(model.minPower);
            version(model.version);
            versionCode(model.versionCode);
            productUrl(model.productUrl);
            licenseUrl(model.licenseUrl);
            platform(model.platform);
            appCategory(model.appCategory);
        }

        public final String getBlueprintId() {
            return blueprintId;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BlueprintType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final Integer getMinPower() {
            return minPower;
        }

        public final void setMinPower(Integer minPower) {
            this.minPower = minPower;
        }

        @Override
        public final Builder minPower(Integer minPower) {
            this.minPower = minPower;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getVersionCode() {
            return versionCode;
        }

        public final void setVersionCode(String versionCode) {
            this.versionCode = versionCode;
        }

        @Override
        public final Builder versionCode(String versionCode) {
            this.versionCode = versionCode;
            return this;
        }

        public final String getProductUrl() {
            return productUrl;
        }

        public final void setProductUrl(String productUrl) {
            this.productUrl = productUrl;
        }

        @Override
        public final Builder productUrl(String productUrl) {
            this.productUrl = productUrl;
            return this;
        }

        public final String getLicenseUrl() {
            return licenseUrl;
        }

        public final void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        @Override
        public final Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(InstancePlatform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getAppCategory() {
            return appCategory;
        }

        public final void setAppCategory(String appCategory) {
            this.appCategory = appCategory;
        }

        @Override
        public final Builder appCategory(String appCategory) {
            this.appCategory = appCategory;
            return this;
        }

        @Override
        public final Builder appCategory(AppCategory appCategory) {
            this.appCategory(appCategory == null ? null : appCategory.toString());
            return this;
        }

        @Override
        public Blueprint build() {
            return new Blueprint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
