/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AccessKey;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.services.lightsail.model.OperationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBucketAccessKeyResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, CreateBucketAccessKeyResponse> {
    private static final SdkField<AccessKey> ACCESS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessKey").getter(CreateBucketAccessKeyResponse.getter(CreateBucketAccessKeyResponse::accessKey)).setter(CreateBucketAccessKeyResponse.setter(Builder::accessKey)).constructor(AccessKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKey").build()}).build();
    private static final SdkField<List<Operation>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("operations").getter(CreateBucketAccessKeyResponse.getter(CreateBucketAccessKeyResponse::operations)).setter(CreateBucketAccessKeyResponse.setter(Builder::operations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Operation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_FIELD, OPERATIONS_FIELD));
    private final AccessKey accessKey;
    private final List<Operation> operations;

    private CreateBucketAccessKeyResponse(BuilderImpl builder) {
        super(builder);
        this.accessKey = builder.accessKey;
        this.operations = builder.operations;
    }

    public final AccessKey accessKey() {
        return this.accessKey;
    }

    public final boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public final List<Operation> operations() {
        return this.operations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperations() ? this.operations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBucketAccessKeyResponse)) {
            return false;
        }
        CreateBucketAccessKeyResponse other = (CreateBucketAccessKeyResponse)((Object)obj);
        return Objects.equals(this.accessKey(), other.accessKey()) && this.hasOperations() == other.hasOperations() && Objects.equals(this.operations(), other.operations());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBucketAccessKeyResponse").add("AccessKey", (Object)this.accessKey()).add("Operations", this.hasOperations() ? this.operations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessKey": {
                return Optional.ofNullable(clazz.cast(this.accessKey()));
            }
            case "operations": {
                return Optional.ofNullable(clazz.cast(this.operations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBucketAccessKeyResponse, T> g) {
        return obj -> g.apply((CreateBucketAccessKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private AccessKey accessKey;
        private List<Operation> operations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBucketAccessKeyResponse model) {
            super(model);
            this.accessKey(model.accessKey);
            this.operations(model.operations);
        }

        public final AccessKey.Builder getAccessKey() {
            return this.accessKey != null ? this.accessKey.toBuilder() : null;
        }

        public final void setAccessKey(AccessKey.BuilderImpl accessKey) {
            this.accessKey = accessKey != null ? accessKey.build() : null;
        }

        @Override
        @Transient
        public final Builder accessKey(AccessKey accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public final List<Operation.Builder> getOperations() {
            List<Operation.Builder> result = OperationListCopier.copyToBuilder(this.operations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        @Override
        @Transient
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder operations(Operation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder operations(Consumer<Operation.Builder> ... operations) {
            this.operations(Stream.of(operations).map(c -> (Operation)((Operation.Builder)Operation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateBucketAccessKeyResponse build() {
            return new CreateBucketAccessKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBucketAccessKeyResponse> {
        public Builder accessKey(AccessKey var1);

        default public Builder accessKey(Consumer<AccessKey.Builder> accessKey) {
            return this.accessKey((AccessKey)((AccessKey.Builder)AccessKey.builder().applyMutation(accessKey)).build());
        }

        public Builder operations(Collection<Operation> var1);

        public Builder operations(Operation ... var1);

        public Builder operations(Consumer<Operation.Builder> ... var1);
    }
}

