/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.InstancePortInfo;
import software.amazon.awssdk.services.lightsail.model.InstancePortInfoListCopier;
import software.amazon.awssdk.services.lightsail.model.MonthlyTransfer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceNetworking
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceNetworking> {
    private static final SdkField<MonthlyTransfer> MONTHLY_TRANSFER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("monthlyTransfer").getter(InstanceNetworking.getter(InstanceNetworking::monthlyTransfer)).setter(InstanceNetworking.setter(Builder::monthlyTransfer)).constructor(MonthlyTransfer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlyTransfer").build()}).build();
    private static final SdkField<List<InstancePortInfo>> PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ports").getter(InstanceNetworking.getter(InstanceNetworking::ports)).setter(InstanceNetworking.setter(Builder::ports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstancePortInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONTHLY_TRANSFER_FIELD, PORTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final MonthlyTransfer monthlyTransfer;
    private final List<InstancePortInfo> ports;

    private InstanceNetworking(BuilderImpl builder) {
        this.monthlyTransfer = builder.monthlyTransfer;
        this.ports = builder.ports;
    }

    public final MonthlyTransfer monthlyTransfer() {
        return this.monthlyTransfer;
    }

    public final boolean hasPorts() {
        return this.ports != null && !(this.ports instanceof SdkAutoConstructList);
    }

    public final List<InstancePortInfo> ports() {
        return this.ports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monthlyTransfer());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPorts() ? this.ports() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworking)) {
            return false;
        }
        InstanceNetworking other = (InstanceNetworking)obj;
        return Objects.equals(this.monthlyTransfer(), other.monthlyTransfer()) && this.hasPorts() == other.hasPorts() && Objects.equals(this.ports(), other.ports());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceNetworking").add("MonthlyTransfer", (Object)this.monthlyTransfer()).add("Ports", this.hasPorts() ? this.ports() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monthlyTransfer": {
                return Optional.ofNullable(clazz.cast(this.monthlyTransfer()));
            }
            case "ports": {
                return Optional.ofNullable(clazz.cast(this.ports()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceNetworking, T> g) {
        return obj -> g.apply((InstanceNetworking)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MonthlyTransfer monthlyTransfer;
        private List<InstancePortInfo> ports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworking model) {
            this.monthlyTransfer(model.monthlyTransfer);
            this.ports(model.ports);
        }

        public final MonthlyTransfer.Builder getMonthlyTransfer() {
            return this.monthlyTransfer != null ? this.monthlyTransfer.toBuilder() : null;
        }

        public final void setMonthlyTransfer(MonthlyTransfer.BuilderImpl monthlyTransfer) {
            this.monthlyTransfer = monthlyTransfer != null ? monthlyTransfer.build() : null;
        }

        @Override
        @Transient
        public final Builder monthlyTransfer(MonthlyTransfer monthlyTransfer) {
            this.monthlyTransfer = monthlyTransfer;
            return this;
        }

        public final List<InstancePortInfo.Builder> getPorts() {
            List<InstancePortInfo.Builder> result = InstancePortInfoListCopier.copyToBuilder(this.ports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPorts(Collection<InstancePortInfo.BuilderImpl> ports) {
            this.ports = InstancePortInfoListCopier.copyFromBuilder(ports);
        }

        @Override
        @Transient
        public final Builder ports(Collection<InstancePortInfo> ports) {
            this.ports = InstancePortInfoListCopier.copy(ports);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ports(InstancePortInfo ... ports) {
            this.ports(Arrays.asList(ports));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ports(Consumer<InstancePortInfo.Builder> ... ports) {
            this.ports(Stream.of(ports).map(c -> (InstancePortInfo)((InstancePortInfo.Builder)InstancePortInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InstanceNetworking build() {
            return new InstanceNetworking(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceNetworking> {
        public Builder monthlyTransfer(MonthlyTransfer var1);

        default public Builder monthlyTransfer(Consumer<MonthlyTransfer.Builder> monthlyTransfer) {
            return this.monthlyTransfer((MonthlyTransfer)((MonthlyTransfer.Builder)MonthlyTransfer.builder().applyMutation(monthlyTransfer)).build());
        }

        public Builder ports(Collection<InstancePortInfo> var1);

        public Builder ports(InstancePortInfo ... var1);

        public Builder ports(Consumer<InstancePortInfo.Builder> ... var1);
    }
}

