/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InstanceMetricName {
    CPU_UTILIZATION("CPUUtilization"),
    NETWORK_IN("NetworkIn"),
    NETWORK_OUT("NetworkOut"),
    STATUS_CHECK_FAILED("StatusCheckFailed"),
    STATUS_CHECK_FAILED_INSTANCE("StatusCheckFailed_Instance"),
    STATUS_CHECK_FAILED_SYSTEM("StatusCheckFailed_System"),
    BURST_CAPACITY_TIME("BurstCapacityTime"),
    BURST_CAPACITY_PERCENTAGE("BurstCapacityPercentage"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InstanceMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InstanceMetricName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceMetricName> knownValues() {
        return Stream.of(InstanceMetricName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

