/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lightsail.LightsailAsyncClient;
import software.amazon.awssdk.services.lightsail.model.AccessDeniedException;
import software.amazon.awssdk.services.lightsail.model.AccountSetupInProgressException;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.AttachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.AttachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyRequest;
import software.amazon.awssdk.services.lightsail.model.CreateBucketAccessKeyResponse;
import software.amazon.awssdk.services.lightsail.model.CreateBucketRequest;
import software.amazon.awssdk.services.lightsail.model.CreateBucketResponse;
import software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContactMethodResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteBucketResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContactMethodResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerImageResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.DetachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DetachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse;
import software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest;
import software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetBucketsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBucketsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest;
import software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDisksRequest;
import software.amazon.awssdk.services.lightsail.model.GetDisksResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainsResponse;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsPoliciesResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRegionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRegionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.InvalidInputException;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse;
import software.amazon.awssdk.services.lightsail.model.LightsailException;
import software.amazon.awssdk.services.lightsail.model.NotFoundException;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.OperationFailureException;
import software.amazon.awssdk.services.lightsail.model.PeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.PeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.PutAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.PutAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest;
import software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest;
import software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse;
import software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest;
import software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationResponse;
import software.amazon.awssdk.services.lightsail.model.ServiceException;
import software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest;
import software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketResponse;
import software.amazon.awssdk.services.lightsail.model.StartInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StartInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.StopInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StopInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.TagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.TagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.TestAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.TestAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.UnauthenticatedException;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.UntagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.UntagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateBucketResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.transform.AllocateStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachCertificateToDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachInstancesToLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CloseInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateBucketAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateCloudFormationStackRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContactMethodRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceDeploymentRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceRegistryLoginRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteAutoSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteBucketAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContactMethodRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContainerImageRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKnownHostKeysRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachCertificateFromDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachInstancesFromLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DisableAddOnRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DownloadDefaultKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.EnableAddOnRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ExportSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetActiveNamesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetAlarmsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetAutoSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketAccessKeysRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBucketsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetCertificatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetCloudFormationStackRecordsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContactMethodsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerApiMetadataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerImagesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerLogRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServiceDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServiceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServicePowersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServicesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDisksRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionLatestCacheResetRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetExportSnapshotRecordsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceAccessDetailsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancePortStatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceStateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerTlsCertificatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerTlsPoliciesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRegionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseEventsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseLogEventsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseLogStreamsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseMasterUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseParametersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabasesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.IsVpcPeeredRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.OpenInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RegisterContainerImageRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ReleaseStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ResetDistributionCacheRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SendContactMethodVerificationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SetIpAddressTypeRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SetResourceAccessForBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.TestAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UnpeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateBucketBundleRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateBucketRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDistributionBundleRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateLoadBalancerAttributeRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateRelationalDatabaseParametersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultLightsailAsyncClient
implements LightsailAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLightsailAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLightsailAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "lightsail";
    }

    @Override
    public CompletableFuture<AllocateStaticIpResponse> allocateStaticIp(AllocateStaticIpRequest allocateStaticIpRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, allocateStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AllocateStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AllocateStaticIpResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AllocateStaticIp").withMarshaller((Marshaller)new AllocateStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)allocateStaticIpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$allocateStaticIp$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$allocateStaticIp$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachCertificateToDistributionResponse> attachCertificateToDistribution(AttachCertificateToDistributionRequest attachCertificateToDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, attachCertificateToDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachCertificateToDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachCertificateToDistributionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachCertificateToDistribution").withMarshaller((Marshaller)new AttachCertificateToDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachCertificateToDistributionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$attachCertificateToDistribution$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$attachCertificateToDistribution$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachDiskResponse> attachDisk(AttachDiskRequest attachDiskRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, attachDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachDiskResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachDisk").withMarshaller((Marshaller)new AttachDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachDiskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$attachDisk$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$attachDisk$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachInstancesToLoadBalancerResponse> attachInstancesToLoadBalancer(AttachInstancesToLoadBalancerRequest attachInstancesToLoadBalancerRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, attachInstancesToLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachInstancesToLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachInstancesToLoadBalancerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachInstancesToLoadBalancer").withMarshaller((Marshaller)new AttachInstancesToLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachInstancesToLoadBalancerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$attachInstancesToLoadBalancer$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$attachInstancesToLoadBalancer$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachLoadBalancerTlsCertificateResponse> attachLoadBalancerTlsCertificate(AttachLoadBalancerTlsCertificateRequest attachLoadBalancerTlsCertificateRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, attachLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachLoadBalancerTlsCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachLoadBalancerTlsCertificateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachLoadBalancerTlsCertificate").withMarshaller((Marshaller)new AttachLoadBalancerTlsCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachLoadBalancerTlsCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$attachLoadBalancerTlsCertificate$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$attachLoadBalancerTlsCertificate$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachStaticIpResponse> attachStaticIp(AttachStaticIpRequest attachStaticIpRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, attachStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachStaticIpResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachStaticIp").withMarshaller((Marshaller)new AttachStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachStaticIpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$attachStaticIp$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$attachStaticIp$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CloseInstancePublicPortsResponse> closeInstancePublicPorts(CloseInstancePublicPortsRequest closeInstancePublicPortsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, closeInstancePublicPortsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CloseInstancePublicPorts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CloseInstancePublicPortsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CloseInstancePublicPorts").withMarshaller((Marshaller)new CloseInstancePublicPortsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)closeInstancePublicPortsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$closeInstancePublicPorts$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$closeInstancePublicPorts$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, copySnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CopySnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopySnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopySnapshot").withMarshaller((Marshaller)new CopySnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)copySnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$copySnapshot$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$copySnapshot$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBucketResponse> createBucket(CreateBucketRequest createBucketRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBucket");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBucketResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucket").withMarshaller((Marshaller)new CreateBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBucketRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createBucket$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createBucket$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBucketAccessKeyResponse> createBucketAccessKey(CreateBucketAccessKeyRequest createBucketAccessKeyRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createBucketAccessKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBucketAccessKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBucketAccessKeyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucketAccessKey").withMarshaller((Marshaller)new CreateBucketAccessKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBucketAccessKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createBucketAccessKey$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createBucketAccessKey$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCertificateResponse> createCertificate(CreateCertificateRequest createCertificateRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCertificateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCertificate").withMarshaller((Marshaller)new CreateCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createCertificate$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createCertificate$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCloudFormationStackResponse> createCloudFormationStack(CreateCloudFormationStackRequest createCloudFormationStackRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createCloudFormationStackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCloudFormationStack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCloudFormationStackResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCloudFormationStack").withMarshaller((Marshaller)new CreateCloudFormationStackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCloudFormationStackRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createCloudFormationStack$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createCloudFormationStack$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateContactMethodResponse> createContactMethod(CreateContactMethodRequest createContactMethodRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createContactMethodRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContactMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContactMethodResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContactMethod").withMarshaller((Marshaller)new CreateContactMethodRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createContactMethodRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createContactMethod$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createContactMethod$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateContainerServiceResponse> createContainerService(CreateContainerServiceRequest createContainerServiceRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createContainerServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContainerService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContainerServiceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContainerService").withMarshaller((Marshaller)new CreateContainerServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createContainerServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createContainerService$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createContainerService$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateContainerServiceDeploymentResponse> createContainerServiceDeployment(CreateContainerServiceDeploymentRequest createContainerServiceDeploymentRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createContainerServiceDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContainerServiceDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContainerServiceDeploymentResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContainerServiceDeployment").withMarshaller((Marshaller)new CreateContainerServiceDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createContainerServiceDeploymentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createContainerServiceDeployment$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createContainerServiceDeployment$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateContainerServiceRegistryLoginResponse> createContainerServiceRegistryLogin(CreateContainerServiceRegistryLoginRequest createContainerServiceRegistryLoginRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createContainerServiceRegistryLoginRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateContainerServiceRegistryLogin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateContainerServiceRegistryLoginResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateContainerServiceRegistryLogin").withMarshaller((Marshaller)new CreateContainerServiceRegistryLoginRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createContainerServiceRegistryLoginRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createContainerServiceRegistryLogin$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createContainerServiceRegistryLogin$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDiskResponse> createDisk(CreateDiskRequest createDiskRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDiskResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDisk").withMarshaller((Marshaller)new CreateDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDiskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDisk$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDisk$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDiskFromSnapshotResponse> createDiskFromSnapshot(CreateDiskFromSnapshotRequest createDiskFromSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDiskFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDiskFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDiskFromSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDiskFromSnapshot").withMarshaller((Marshaller)new CreateDiskFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDiskFromSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDiskFromSnapshot$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDiskFromSnapshot$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDiskSnapshotResponse> createDiskSnapshot(CreateDiskSnapshotRequest createDiskSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDiskSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDiskSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDiskSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDiskSnapshot").withMarshaller((Marshaller)new CreateDiskSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDiskSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDiskSnapshot$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDiskSnapshot$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDistributionResponse> createDistribution(CreateDistributionRequest createDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDistributionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDistribution").withMarshaller((Marshaller)new CreateDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDistributionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDistribution$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDistribution$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomain").withMarshaller((Marshaller)new CreateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDomain$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDomain$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDomainEntryResponse> createDomainEntry(CreateDomainEntryRequest createDomainEntryRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDomainEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomainEntry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainEntryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomainEntry").withMarshaller((Marshaller)new CreateDomainEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDomainEntryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createDomainEntry$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createDomainEntry$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateInstanceSnapshotResponse> createInstanceSnapshot(CreateInstanceSnapshotRequest createInstanceSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createInstanceSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInstanceSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstanceSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstanceSnapshot").withMarshaller((Marshaller)new CreateInstanceSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createInstanceSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createInstanceSnapshot$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createInstanceSnapshot$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateInstancesResponse> createInstances(CreateInstancesRequest createInstancesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstancesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstances").withMarshaller((Marshaller)new CreateInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createInstances$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createInstances$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateInstancesFromSnapshotResponse> createInstancesFromSnapshot(CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createInstancesFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInstancesFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstancesFromSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstancesFromSnapshot").withMarshaller((Marshaller)new CreateInstancesFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createInstancesFromSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createInstancesFromSnapshot$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createInstancesFromSnapshot$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateKeyPairResponse> createKeyPair(CreateKeyPairRequest createKeyPairRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateKeyPairResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateKeyPair").withMarshaller((Marshaller)new CreateKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createKeyPairRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createKeyPair$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createKeyPair$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLoadBalancerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancer").withMarshaller((Marshaller)new CreateLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLoadBalancerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createLoadBalancer$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createLoadBalancer$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLoadBalancerTlsCertificateResponse> createLoadBalancerTlsCertificate(CreateLoadBalancerTlsCertificateRequest createLoadBalancerTlsCertificateRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancerTlsCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLoadBalancerTlsCertificateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancerTlsCertificate").withMarshaller((Marshaller)new CreateLoadBalancerTlsCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLoadBalancerTlsCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createLoadBalancerTlsCertificate$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createLoadBalancerTlsCertificate$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRelationalDatabaseResponse> createRelationalDatabase(CreateRelationalDatabaseRequest createRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRelationalDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRelationalDatabase").withMarshaller((Marshaller)new CreateRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createRelationalDatabase$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createRelationalDatabase$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRelationalDatabaseFromSnapshotResponse> createRelationalDatabaseFromSnapshot(CreateRelationalDatabaseFromSnapshotRequest createRelationalDatabaseFromSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createRelationalDatabaseFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRelationalDatabaseFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRelationalDatabaseFromSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRelationalDatabaseFromSnapshot").withMarshaller((Marshaller)new CreateRelationalDatabaseFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRelationalDatabaseFromSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createRelationalDatabaseFromSnapshot$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createRelationalDatabaseFromSnapshot$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRelationalDatabaseSnapshotResponse> createRelationalDatabaseSnapshot(CreateRelationalDatabaseSnapshotRequest createRelationalDatabaseSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, createRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRelationalDatabaseSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRelationalDatabaseSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRelationalDatabaseSnapshot").withMarshaller((Marshaller)new CreateRelationalDatabaseSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRelationalDatabaseSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$createRelationalDatabaseSnapshot$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$createRelationalDatabaseSnapshot$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAlarmResponse> deleteAlarm(DeleteAlarmRequest deleteAlarmRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAlarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAlarmResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlarm").withMarshaller((Marshaller)new DeleteAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAlarmRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteAlarm$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteAlarm$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAutoSnapshotResponse> deleteAutoSnapshot(DeleteAutoSnapshotRequest deleteAutoSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteAutoSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAutoSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAutoSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAutoSnapshot").withMarshaller((Marshaller)new DeleteAutoSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAutoSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteAutoSnapshot$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteAutoSnapshot$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketResponse> deleteBucket(DeleteBucketRequest deleteBucketRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucket");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBucketResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucket").withMarshaller((Marshaller)new DeleteBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBucketRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteBucket$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteBucket$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketAccessKeyResponse> deleteBucketAccessKey(DeleteBucketAccessKeyRequest deleteBucketAccessKeyRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketAccessKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketAccessKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBucketAccessKeyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketAccessKey").withMarshaller((Marshaller)new DeleteBucketAccessKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBucketAccessKeyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteBucketAccessKey$103(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteBucketAccessKey$104((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCertificateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCertificate").withMarshaller((Marshaller)new DeleteCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteCertificate$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteCertificate$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteContactMethodResponse> deleteContactMethod(DeleteContactMethodRequest deleteContactMethodRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteContactMethodRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContactMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContactMethodResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContactMethod").withMarshaller((Marshaller)new DeleteContactMethodRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteContactMethodRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteContactMethod$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteContactMethod$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteContainerImageResponse> deleteContainerImage(DeleteContainerImageRequest deleteContainerImageRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteContainerImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContainerImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContainerImageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContainerImage").withMarshaller((Marshaller)new DeleteContainerImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteContainerImageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteContainerImage$112(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteContainerImage$113((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteContainerServiceResponse> deleteContainerService(DeleteContainerServiceRequest deleteContainerServiceRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteContainerServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteContainerService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteContainerServiceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteContainerService").withMarshaller((Marshaller)new DeleteContainerServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteContainerServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteContainerService$115(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteContainerService$116((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDiskResponse> deleteDisk(DeleteDiskRequest deleteDiskRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDiskResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDisk").withMarshaller((Marshaller)new DeleteDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDiskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteDisk$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteDisk$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDiskSnapshotResponse> deleteDiskSnapshot(DeleteDiskSnapshotRequest deleteDiskSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDiskSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDiskSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDiskSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDiskSnapshot").withMarshaller((Marshaller)new DeleteDiskSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDiskSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteDiskSnapshot$121(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteDiskSnapshot$122((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDistributionResponse> deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDistributionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDistribution").withMarshaller((Marshaller)new DeleteDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDistributionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteDistribution$124(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteDistribution$125((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomain").withMarshaller((Marshaller)new DeleteDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteDomain$127(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteDomain$128((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDomainEntryResponse> deleteDomainEntry(DeleteDomainEntryRequest deleteDomainEntryRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDomainEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomainEntry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainEntryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomainEntry").withMarshaller((Marshaller)new DeleteDomainEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDomainEntryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteDomainEntry$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteDomainEntry$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteInstanceResponse> deleteInstance(DeleteInstanceRequest deleteInstanceRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInstanceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInstance").withMarshaller((Marshaller)new DeleteInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteInstance$133(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteInstance$134((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteInstanceSnapshotResponse> deleteInstanceSnapshot(DeleteInstanceSnapshotRequest deleteInstanceSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteInstanceSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInstanceSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInstanceSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInstanceSnapshot").withMarshaller((Marshaller)new DeleteInstanceSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteInstanceSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteInstanceSnapshot$136(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteInstanceSnapshot$137((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKeyPairResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKeyPair").withMarshaller((Marshaller)new DeleteKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteKeyPairRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteKeyPair$139(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteKeyPair$140((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteKnownHostKeysResponse> deleteKnownHostKeys(DeleteKnownHostKeysRequest deleteKnownHostKeysRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteKnownHostKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteKnownHostKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteKnownHostKeysResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteKnownHostKeys").withMarshaller((Marshaller)new DeleteKnownHostKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteKnownHostKeysRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteKnownHostKeys$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteKnownHostKeys$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLoadBalancerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancer").withMarshaller((Marshaller)new DeleteLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLoadBalancerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteLoadBalancer$145(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteLoadBalancer$146((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLoadBalancerTlsCertificateResponse> deleteLoadBalancerTlsCertificate(DeleteLoadBalancerTlsCertificateRequest deleteLoadBalancerTlsCertificateRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancerTlsCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLoadBalancerTlsCertificateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancerTlsCertificate").withMarshaller((Marshaller)new DeleteLoadBalancerTlsCertificateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLoadBalancerTlsCertificateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteLoadBalancerTlsCertificate$148(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteLoadBalancerTlsCertificate$149((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRelationalDatabaseResponse> deleteRelationalDatabase(DeleteRelationalDatabaseRequest deleteRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRelationalDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRelationalDatabase").withMarshaller((Marshaller)new DeleteRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteRelationalDatabase$151(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteRelationalDatabase$152((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRelationalDatabaseSnapshotResponse> deleteRelationalDatabaseSnapshot(DeleteRelationalDatabaseSnapshotRequest deleteRelationalDatabaseSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRelationalDatabaseSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRelationalDatabaseSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRelationalDatabaseSnapshot").withMarshaller((Marshaller)new DeleteRelationalDatabaseSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRelationalDatabaseSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$deleteRelationalDatabaseSnapshot$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$deleteRelationalDatabaseSnapshot$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachCertificateFromDistributionResponse> detachCertificateFromDistribution(DetachCertificateFromDistributionRequest detachCertificateFromDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, detachCertificateFromDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachCertificateFromDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachCertificateFromDistributionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachCertificateFromDistribution").withMarshaller((Marshaller)new DetachCertificateFromDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachCertificateFromDistributionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$detachCertificateFromDistribution$157(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$detachCertificateFromDistribution$158((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachDiskResponse> detachDisk(DetachDiskRequest detachDiskRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, detachDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachDiskResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachDisk").withMarshaller((Marshaller)new DetachDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachDiskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$detachDisk$160(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$detachDisk$161((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachInstancesFromLoadBalancerResponse> detachInstancesFromLoadBalancer(DetachInstancesFromLoadBalancerRequest detachInstancesFromLoadBalancerRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, detachInstancesFromLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachInstancesFromLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachInstancesFromLoadBalancerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachInstancesFromLoadBalancer").withMarshaller((Marshaller)new DetachInstancesFromLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachInstancesFromLoadBalancerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$detachInstancesFromLoadBalancer$163(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$detachInstancesFromLoadBalancer$164((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachStaticIpResponse> detachStaticIp(DetachStaticIpRequest detachStaticIpRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, detachStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachStaticIpResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachStaticIp").withMarshaller((Marshaller)new DetachStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachStaticIpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$detachStaticIp$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$detachStaticIp$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableAddOnResponse> disableAddOn(DisableAddOnRequest disableAddOnRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableAddOnRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableAddOn");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableAddOnResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAddOn").withMarshaller((Marshaller)new DisableAddOnRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableAddOnRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$disableAddOn$169(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$disableAddOn$170((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DownloadDefaultKeyPairResponse> downloadDefaultKeyPair(DownloadDefaultKeyPairRequest downloadDefaultKeyPairRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, downloadDefaultKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DownloadDefaultKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DownloadDefaultKeyPairResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DownloadDefaultKeyPair").withMarshaller((Marshaller)new DownloadDefaultKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)downloadDefaultKeyPairRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$downloadDefaultKeyPair$172(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$downloadDefaultKeyPair$173((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableAddOnResponse> enableAddOn(EnableAddOnRequest enableAddOnRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableAddOnRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableAddOn");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableAddOnResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAddOn").withMarshaller((Marshaller)new EnableAddOnRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableAddOnRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$enableAddOn$175(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$enableAddOn$176((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExportSnapshotResponse> exportSnapshot(ExportSnapshotRequest exportSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, exportSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportSnapshot").withMarshaller((Marshaller)new ExportSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)exportSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$exportSnapshot$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$exportSnapshot$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetActiveNamesResponse> getActiveNames(GetActiveNamesRequest getActiveNamesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getActiveNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetActiveNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetActiveNamesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetActiveNames").withMarshaller((Marshaller)new GetActiveNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getActiveNamesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getActiveNames$181(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getActiveNames$182((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAlarmsResponse> getAlarms(GetAlarmsRequest getAlarmsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAlarmsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAlarms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAlarmsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAlarms").withMarshaller((Marshaller)new GetAlarmsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAlarmsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getAlarms$184(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getAlarms$185((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAutoSnapshotsResponse> getAutoSnapshots(GetAutoSnapshotsRequest getAutoSnapshotsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAutoSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAutoSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAutoSnapshotsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAutoSnapshots").withMarshaller((Marshaller)new GetAutoSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAutoSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getAutoSnapshots$187(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getAutoSnapshots$188((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBlueprintsResponse> getBlueprints(GetBlueprintsRequest getBlueprintsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBlueprintsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBlueprints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBlueprintsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBlueprints").withMarshaller((Marshaller)new GetBlueprintsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBlueprintsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBlueprints$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBlueprints$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketAccessKeysResponse> getBucketAccessKeys(GetBucketAccessKeysRequest getBucketAccessKeysRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBucketAccessKeysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketAccessKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketAccessKeysResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAccessKeys").withMarshaller((Marshaller)new GetBucketAccessKeysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBucketAccessKeysRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBucketAccessKeys$193(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBucketAccessKeys$194((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketBundlesResponse> getBucketBundles(GetBucketBundlesRequest getBucketBundlesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBucketBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketBundles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketBundlesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketBundles").withMarshaller((Marshaller)new GetBucketBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBucketBundlesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBucketBundles$196(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBucketBundles$197((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketMetricDataResponse> getBucketMetricData(GetBucketMetricDataRequest getBucketMetricDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBucketMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketMetricDataResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketMetricData").withMarshaller((Marshaller)new GetBucketMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBucketMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBucketMetricData$199(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBucketMetricData$200((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketsResponse> getBuckets(GetBucketsRequest getBucketsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBucketsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBuckets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBucketsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBuckets").withMarshaller((Marshaller)new GetBucketsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBucketsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBuckets$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBuckets$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBundlesResponse> getBundles(GetBundlesRequest getBundlesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBundles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBundlesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBundles").withMarshaller((Marshaller)new GetBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBundlesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getBundles$205(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getBundles$206((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCertificatesResponse> getCertificates(GetCertificatesRequest getCertificatesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCertificatesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCertificates").withMarshaller((Marshaller)new GetCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCertificatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getCertificates$208(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getCertificates$209((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCloudFormationStackRecordsResponse> getCloudFormationStackRecords(GetCloudFormationStackRecordsRequest getCloudFormationStackRecordsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getCloudFormationStackRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCloudFormationStackRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCloudFormationStackRecordsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudFormationStackRecords").withMarshaller((Marshaller)new GetCloudFormationStackRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCloudFormationStackRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getCloudFormationStackRecords$211(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getCloudFormationStackRecords$212((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContactMethodsResponse> getContactMethods(GetContactMethodsRequest getContactMethodsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getContactMethodsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContactMethods");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContactMethodsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContactMethods").withMarshaller((Marshaller)new GetContactMethodsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContactMethodsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContactMethods$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContactMethods$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerApiMetadataResponse> getContainerAPIMetadata(GetContainerApiMetadataRequest getContainerApiMetadataRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getContainerApiMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerAPIMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerApiMetadataResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerAPIMetadata").withMarshaller((Marshaller)new GetContainerApiMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerApiMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerAPIMetadata$217(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerAPIMetadata$218((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerImagesResponse> getContainerImages(GetContainerImagesRequest getContainerImagesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getContainerImagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerImagesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerImages").withMarshaller((Marshaller)new GetContainerImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerImagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerImages$220(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerImages$221((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerLogResponse> getContainerLog(GetContainerLogRequest getContainerLogRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getContainerLogRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerLog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerLogResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerLog").withMarshaller((Marshaller)new GetContainerLogRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerLogRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerLog$223(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerLog$224((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerServiceDeploymentsResponse> getContainerServiceDeployments(GetContainerServiceDeploymentsRequest getContainerServiceDeploymentsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getContainerServiceDeploymentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServiceDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServiceDeploymentsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServiceDeployments").withMarshaller((Marshaller)new GetContainerServiceDeploymentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerServiceDeploymentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerServiceDeployments$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerServiceDeployments$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerServiceMetricDataResponse> getContainerServiceMetricData(GetContainerServiceMetricDataRequest getContainerServiceMetricDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getContainerServiceMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServiceMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServiceMetricDataResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServiceMetricData").withMarshaller((Marshaller)new GetContainerServiceMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerServiceMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerServiceMetricData$229(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerServiceMetricData$230((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerServicePowersResponse> getContainerServicePowers(GetContainerServicePowersRequest getContainerServicePowersRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getContainerServicePowersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServicePowers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServicePowersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServicePowers").withMarshaller((Marshaller)new GetContainerServicePowersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerServicePowersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerServicePowers$232(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerServicePowers$233((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetContainerServicesResponse> getContainerServices(GetContainerServicesRequest getContainerServicesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getContainerServicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContainerServices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContainerServicesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContainerServices").withMarshaller((Marshaller)new GetContainerServicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getContainerServicesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getContainerServices$235(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getContainerServices$236((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDiskResponse> getDisk(GetDiskRequest getDiskRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDiskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiskResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDisk").withMarshaller((Marshaller)new GetDiskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDiskRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDisk$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDisk$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDiskSnapshotResponse> getDiskSnapshot(GetDiskSnapshotRequest getDiskSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDiskSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDiskSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiskSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDiskSnapshot").withMarshaller((Marshaller)new GetDiskSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDiskSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDiskSnapshot$241(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDiskSnapshot$242((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDiskSnapshotsResponse> getDiskSnapshots(GetDiskSnapshotsRequest getDiskSnapshotsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDiskSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDiskSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiskSnapshotsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDiskSnapshots").withMarshaller((Marshaller)new GetDiskSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDiskSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDiskSnapshots$244(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDiskSnapshots$245((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDisksResponse> getDisks(GetDisksRequest getDisksRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDisksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDisks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDisksResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDisks").withMarshaller((Marshaller)new GetDisksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDisksRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDisks$247(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDisks$248((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionBundlesResponse> getDistributionBundles(GetDistributionBundlesRequest getDistributionBundlesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDistributionBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionBundles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionBundlesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionBundles").withMarshaller((Marshaller)new GetDistributionBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionBundlesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDistributionBundles$250(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDistributionBundles$251((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionLatestCacheResetResponse> getDistributionLatestCacheReset(GetDistributionLatestCacheResetRequest getDistributionLatestCacheResetRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDistributionLatestCacheResetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionLatestCacheReset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionLatestCacheResetResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionLatestCacheReset").withMarshaller((Marshaller)new GetDistributionLatestCacheResetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionLatestCacheResetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDistributionLatestCacheReset$253(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDistributionLatestCacheReset$254((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionMetricDataResponse> getDistributionMetricData(GetDistributionMetricDataRequest getDistributionMetricDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDistributionMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributionMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionMetricDataResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributionMetricData").withMarshaller((Marshaller)new GetDistributionMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDistributionMetricData$256(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDistributionMetricData$257((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionsResponse> getDistributions(GetDistributionsRequest getDistributionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDistributionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDistributions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDistributionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDistributions").withMarshaller((Marshaller)new GetDistributionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDistributionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDistributions$259(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDistributions$260((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDomainResponse> getDomain(GetDomainRequest getDomainRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomain").withMarshaller((Marshaller)new GetDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDomainRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDomain$262(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDomain$263((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDomainsResponse> getDomains(GetDomainsRequest getDomainsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDomainsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomains").withMarshaller((Marshaller)new GetDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDomainsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getDomains$265(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getDomains$266((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetExportSnapshotRecordsResponse> getExportSnapshotRecords(GetExportSnapshotRecordsRequest getExportSnapshotRecordsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getExportSnapshotRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetExportSnapshotRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetExportSnapshotRecordsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetExportSnapshotRecords").withMarshaller((Marshaller)new GetExportSnapshotRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getExportSnapshotRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getExportSnapshotRecords$268(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getExportSnapshotRecords$269((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceResponse> getInstance(GetInstanceRequest getInstanceRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstance").withMarshaller((Marshaller)new GetInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstance$271(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstance$272((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceAccessDetailsResponse> getInstanceAccessDetails(GetInstanceAccessDetailsRequest getInstanceAccessDetailsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getInstanceAccessDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceAccessDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceAccessDetailsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceAccessDetails").withMarshaller((Marshaller)new GetInstanceAccessDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceAccessDetailsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstanceAccessDetails$274(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstanceAccessDetails$275((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceMetricDataResponse> getInstanceMetricData(GetInstanceMetricDataRequest getInstanceMetricDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getInstanceMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceMetricDataResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceMetricData").withMarshaller((Marshaller)new GetInstanceMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstanceMetricData$277(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstanceMetricData$278((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstancePortStatesResponse> getInstancePortStates(GetInstancePortStatesRequest getInstancePortStatesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getInstancePortStatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstancePortStates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstancePortStatesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstancePortStates").withMarshaller((Marshaller)new GetInstancePortStatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstancePortStatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstancePortStates$280(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstancePortStates$281((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceSnapshotResponse> getInstanceSnapshot(GetInstanceSnapshotRequest getInstanceSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getInstanceSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceSnapshot").withMarshaller((Marshaller)new GetInstanceSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstanceSnapshot$283(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstanceSnapshot$284((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceSnapshotsResponse> getInstanceSnapshots(GetInstanceSnapshotsRequest getInstanceSnapshotsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getInstanceSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceSnapshotsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceSnapshots").withMarshaller((Marshaller)new GetInstanceSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstanceSnapshots$286(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstanceSnapshots$287((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstanceStateResponse> getInstanceState(GetInstanceStateRequest getInstanceStateRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getInstanceStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceStateResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceState").withMarshaller((Marshaller)new GetInstanceStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstanceStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstanceState$289(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstanceState$290((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInstancesResponse> getInstances(GetInstancesRequest getInstancesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstancesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstances").withMarshaller((Marshaller)new GetInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getInstances$292(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getInstances$293((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetKeyPairResponse> getKeyPair(GetKeyPairRequest getKeyPairRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyPairResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyPair").withMarshaller((Marshaller)new GetKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getKeyPairRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getKeyPair$295(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getKeyPair$296((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetKeyPairsResponse> getKeyPairs(GetKeyPairsRequest getKeyPairsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getKeyPairsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetKeyPairs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetKeyPairsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetKeyPairs").withMarshaller((Marshaller)new GetKeyPairsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getKeyPairsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getKeyPairs$298(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getKeyPairs$299((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLoadBalancerResponse> getLoadBalancer(GetLoadBalancerRequest getLoadBalancerRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancer").withMarshaller((Marshaller)new GetLoadBalancerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLoadBalancerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getLoadBalancer$301(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getLoadBalancer$302((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLoadBalancerMetricDataResponse> getLoadBalancerMetricData(GetLoadBalancerMetricDataRequest getLoadBalancerMetricDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getLoadBalancerMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancerMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerMetricDataResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancerMetricData").withMarshaller((Marshaller)new GetLoadBalancerMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLoadBalancerMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getLoadBalancerMetricData$304(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getLoadBalancerMetricData$305((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLoadBalancerTlsCertificatesResponse> getLoadBalancerTlsCertificates(GetLoadBalancerTlsCertificatesRequest getLoadBalancerTlsCertificatesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getLoadBalancerTlsCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancerTlsCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerTlsCertificatesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancerTlsCertificates").withMarshaller((Marshaller)new GetLoadBalancerTlsCertificatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLoadBalancerTlsCertificatesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getLoadBalancerTlsCertificates$307(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getLoadBalancerTlsCertificates$308((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLoadBalancerTlsPoliciesResponse> getLoadBalancerTlsPolicies(GetLoadBalancerTlsPoliciesRequest getLoadBalancerTlsPoliciesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getLoadBalancerTlsPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancerTlsPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancerTlsPoliciesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancerTlsPolicies").withMarshaller((Marshaller)new GetLoadBalancerTlsPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLoadBalancerTlsPoliciesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getLoadBalancerTlsPolicies$310(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getLoadBalancerTlsPolicies$311((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLoadBalancersResponse> getLoadBalancers(GetLoadBalancersRequest getLoadBalancersRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getLoadBalancersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLoadBalancers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLoadBalancersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLoadBalancers").withMarshaller((Marshaller)new GetLoadBalancersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLoadBalancersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getLoadBalancers$313(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getLoadBalancers$314((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOperationResponse> getOperation(GetOperationRequest getOperationRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperation").withMarshaller((Marshaller)new GetOperationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOperationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getOperation$316(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getOperation$317((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOperationsResponse> getOperations(GetOperationsRequest getOperationsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperations").withMarshaller((Marshaller)new GetOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOperationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getOperations$319(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getOperations$320((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetOperationsForResourceResponse> getOperationsForResource(GetOperationsForResourceRequest getOperationsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getOperationsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperationsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperationsForResource").withMarshaller((Marshaller)new GetOperationsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getOperationsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getOperationsForResource$322(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getOperationsForResource$323((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRegionsResponse> getRegions(GetRegionsRequest getRegionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRegionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRegions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRegionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRegions").withMarshaller((Marshaller)new GetRegionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRegionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRegions$325(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRegions$326((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseResponse> getRelationalDatabase(GetRelationalDatabaseRequest getRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabase").withMarshaller((Marshaller)new GetRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabase$328(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabase$329((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseBlueprintsResponse> getRelationalDatabaseBlueprints(GetRelationalDatabaseBlueprintsRequest getRelationalDatabaseBlueprintsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabaseBlueprintsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseBlueprints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseBlueprintsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseBlueprints").withMarshaller((Marshaller)new GetRelationalDatabaseBlueprintsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseBlueprintsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseBlueprints$331(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseBlueprints$332((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseBundlesResponse> getRelationalDatabaseBundles(GetRelationalDatabaseBundlesRequest getRelationalDatabaseBundlesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabaseBundlesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseBundles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseBundlesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseBundles").withMarshaller((Marshaller)new GetRelationalDatabaseBundlesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseBundlesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseBundles$334(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseBundles$335((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseEventsResponse> getRelationalDatabaseEvents(GetRelationalDatabaseEventsRequest getRelationalDatabaseEventsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabaseEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseEventsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseEvents").withMarshaller((Marshaller)new GetRelationalDatabaseEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseEvents$337(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseEvents$338((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseLogEventsResponse> getRelationalDatabaseLogEvents(GetRelationalDatabaseLogEventsRequest getRelationalDatabaseLogEventsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabaseLogEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseLogEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseLogEventsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseLogEvents").withMarshaller((Marshaller)new GetRelationalDatabaseLogEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseLogEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseLogEvents$340(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseLogEvents$341((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseLogStreamsResponse> getRelationalDatabaseLogStreams(GetRelationalDatabaseLogStreamsRequest getRelationalDatabaseLogStreamsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabaseLogStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseLogStreams");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseLogStreamsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseLogStreams").withMarshaller((Marshaller)new GetRelationalDatabaseLogStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseLogStreamsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseLogStreams$343(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseLogStreams$344((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseMasterUserPasswordResponse> getRelationalDatabaseMasterUserPassword(GetRelationalDatabaseMasterUserPasswordRequest getRelationalDatabaseMasterUserPasswordRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabaseMasterUserPasswordRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseMasterUserPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseMasterUserPasswordResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseMasterUserPassword").withMarshaller((Marshaller)new GetRelationalDatabaseMasterUserPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseMasterUserPasswordRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseMasterUserPassword$346(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseMasterUserPassword$347((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseMetricDataResponse> getRelationalDatabaseMetricData(GetRelationalDatabaseMetricDataRequest getRelationalDatabaseMetricDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabaseMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseMetricDataResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseMetricData").withMarshaller((Marshaller)new GetRelationalDatabaseMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseMetricDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseMetricData$349(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseMetricData$350((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseParametersResponse> getRelationalDatabaseParameters(GetRelationalDatabaseParametersRequest getRelationalDatabaseParametersRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabaseParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseParametersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseParameters").withMarshaller((Marshaller)new GetRelationalDatabaseParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseParametersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseParameters$352(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseParameters$353((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseSnapshotResponse> getRelationalDatabaseSnapshot(GetRelationalDatabaseSnapshotRequest getRelationalDatabaseSnapshotRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseSnapshotResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseSnapshot").withMarshaller((Marshaller)new GetRelationalDatabaseSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseSnapshotRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseSnapshot$355(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseSnapshot$356((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabaseSnapshotsResponse> getRelationalDatabaseSnapshots(GetRelationalDatabaseSnapshotsRequest getRelationalDatabaseSnapshotsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabaseSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabaseSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabaseSnapshotsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabaseSnapshots").withMarshaller((Marshaller)new GetRelationalDatabaseSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabaseSnapshotsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseSnapshots$358(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabaseSnapshots$359((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRelationalDatabasesResponse> getRelationalDatabases(GetRelationalDatabasesRequest getRelationalDatabasesRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRelationalDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRelationalDatabases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRelationalDatabasesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRelationalDatabases").withMarshaller((Marshaller)new GetRelationalDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRelationalDatabasesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getRelationalDatabases$361(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getRelationalDatabases$362((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStaticIpResponse> getStaticIp(GetStaticIpRequest getStaticIpRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStaticIpResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStaticIp").withMarshaller((Marshaller)new GetStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStaticIpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getStaticIp$364(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getStaticIp$365((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStaticIpsResponse> getStaticIps(GetStaticIpsRequest getStaticIpsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, getStaticIpsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStaticIps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStaticIpsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStaticIps").withMarshaller((Marshaller)new GetStaticIpsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStaticIpsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$getStaticIps$367(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$getStaticIps$368((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportKeyPairResponse> importKeyPair(ImportKeyPairRequest importKeyPairRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, importKeyPairRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportKeyPairResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportKeyPair").withMarshaller((Marshaller)new ImportKeyPairRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importKeyPairRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$importKeyPair$370(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$importKeyPair$371((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<IsVpcPeeredResponse> isVpcPeered(IsVpcPeeredRequest isVpcPeeredRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, isVpcPeeredRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IsVpcPeered");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, IsVpcPeeredResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("IsVpcPeered").withMarshaller((Marshaller)new IsVpcPeeredRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)isVpcPeeredRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$isVpcPeered$373(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$isVpcPeered$374((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<OpenInstancePublicPortsResponse> openInstancePublicPorts(OpenInstancePublicPortsRequest openInstancePublicPortsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, openInstancePublicPortsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"OpenInstancePublicPorts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, OpenInstancePublicPortsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("OpenInstancePublicPorts").withMarshaller((Marshaller)new OpenInstancePublicPortsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)openInstancePublicPortsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$openInstancePublicPorts$376(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$openInstancePublicPorts$377((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PeerVpcResponse> peerVpc(PeerVpcRequest peerVpcRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, peerVpcRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PeerVpc");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PeerVpcResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PeerVpc").withMarshaller((Marshaller)new PeerVpcRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)peerVpcRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$peerVpc$379(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$peerVpc$380((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAlarmResponse> putAlarm(PutAlarmRequest putAlarmRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, putAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAlarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAlarmResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAlarm").withMarshaller((Marshaller)new PutAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAlarmRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$putAlarm$382(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$putAlarm$383((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutInstancePublicPortsResponse> putInstancePublicPorts(PutInstancePublicPortsRequest putInstancePublicPortsRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, putInstancePublicPortsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutInstancePublicPorts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutInstancePublicPortsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutInstancePublicPorts").withMarshaller((Marshaller)new PutInstancePublicPortsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putInstancePublicPortsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$putInstancePublicPorts$385(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$putInstancePublicPorts$386((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebootInstanceResponse> rebootInstance(RebootInstanceRequest rebootInstanceRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, rebootInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootInstanceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootInstance").withMarshaller((Marshaller)new RebootInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rebootInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$rebootInstance$388(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$rebootInstance$389((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RebootRelationalDatabaseResponse> rebootRelationalDatabase(RebootRelationalDatabaseRequest rebootRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, rebootRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootRelationalDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootRelationalDatabase").withMarshaller((Marshaller)new RebootRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)rebootRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$rebootRelationalDatabase$391(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$rebootRelationalDatabase$392((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterContainerImageResponse> registerContainerImage(RegisterContainerImageRequest registerContainerImageRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, registerContainerImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterContainerImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterContainerImageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterContainerImage").withMarshaller((Marshaller)new RegisterContainerImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerContainerImageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$registerContainerImage$394(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$registerContainerImage$395((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ReleaseStaticIpResponse> releaseStaticIp(ReleaseStaticIpRequest releaseStaticIpRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, releaseStaticIpRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReleaseStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReleaseStaticIpResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReleaseStaticIp").withMarshaller((Marshaller)new ReleaseStaticIpRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)releaseStaticIpRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$releaseStaticIp$397(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$releaseStaticIp$398((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ResetDistributionCacheResponse> resetDistributionCache(ResetDistributionCacheRequest resetDistributionCacheRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, resetDistributionCacheRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResetDistributionCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetDistributionCacheResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDistributionCache").withMarshaller((Marshaller)new ResetDistributionCacheRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)resetDistributionCacheRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$resetDistributionCache$400(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$resetDistributionCache$401((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SendContactMethodVerificationResponse> sendContactMethodVerification(SendContactMethodVerificationRequest sendContactMethodVerificationRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, sendContactMethodVerificationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendContactMethodVerification");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendContactMethodVerificationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendContactMethodVerification").withMarshaller((Marshaller)new SendContactMethodVerificationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)sendContactMethodVerificationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$sendContactMethodVerification$403(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$sendContactMethodVerification$404((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetIpAddressTypeResponse> setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, setIpAddressTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIpAddressType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetIpAddressTypeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIpAddressType").withMarshaller((Marshaller)new SetIpAddressTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setIpAddressTypeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$setIpAddressType$406(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$setIpAddressType$407((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetResourceAccessForBucketResponse> setResourceAccessForBucket(SetResourceAccessForBucketRequest setResourceAccessForBucketRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, setResourceAccessForBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetResourceAccessForBucket");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetResourceAccessForBucketResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetResourceAccessForBucket").withMarshaller((Marshaller)new SetResourceAccessForBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setResourceAccessForBucketRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$setResourceAccessForBucket$409(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$setResourceAccessForBucket$410((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartInstanceResponse> startInstance(StartInstanceRequest startInstanceRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, startInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartInstanceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartInstance").withMarshaller((Marshaller)new StartInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$startInstance$412(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$startInstance$413((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartRelationalDatabaseResponse> startRelationalDatabase(StartRelationalDatabaseRequest startRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, startRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRelationalDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRelationalDatabase").withMarshaller((Marshaller)new StartRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$startRelationalDatabase$415(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$startRelationalDatabase$416((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopInstanceResponse> stopInstance(StopInstanceRequest stopInstanceRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopInstanceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopInstance").withMarshaller((Marshaller)new StopInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$stopInstance$418(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$stopInstance$419((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopRelationalDatabaseResponse> stopRelationalDatabase(StopRelationalDatabaseRequest stopRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopRelationalDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopRelationalDatabase").withMarshaller((Marshaller)new StopRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$stopRelationalDatabase$421(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$stopRelationalDatabase$422((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$tagResource$424(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$tagResource$425((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TestAlarmResponse> testAlarm(TestAlarmRequest testAlarmRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, testAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestAlarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestAlarmResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestAlarm").withMarshaller((Marshaller)new TestAlarmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)testAlarmRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$testAlarm$427(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$testAlarm$428((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UnpeerVpcResponse> unpeerVpc(UnpeerVpcRequest unpeerVpcRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, unpeerVpcRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnpeerVpc");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnpeerVpcResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnpeerVpc").withMarshaller((Marshaller)new UnpeerVpcRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)unpeerVpcRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$unpeerVpc$430(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$unpeerVpc$431((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$untagResource$433(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$untagResource$434((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBucketResponse> updateBucket(UpdateBucketRequest updateBucketRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBucket");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBucketResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBucket").withMarshaller((Marshaller)new UpdateBucketRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBucketRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateBucket$436(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateBucket$437((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBucketBundleResponse> updateBucketBundle(UpdateBucketBundleRequest updateBucketBundleRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateBucketBundleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBucketBundle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBucketBundleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBucketBundle").withMarshaller((Marshaller)new UpdateBucketBundleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBucketBundleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateBucketBundle$439(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateBucketBundle$440((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateContainerServiceResponse> updateContainerService(UpdateContainerServiceRequest updateContainerServiceRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateContainerServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContainerService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContainerServiceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContainerService").withMarshaller((Marshaller)new UpdateContainerServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateContainerServiceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateContainerService$442(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateContainerService$443((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDistributionResponse> updateDistribution(UpdateDistributionRequest updateDistributionRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateDistributionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDistributionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDistribution").withMarshaller((Marshaller)new UpdateDistributionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDistributionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateDistribution$445(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateDistribution$446((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDistributionBundleResponse> updateDistributionBundle(UpdateDistributionBundleRequest updateDistributionBundleRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateDistributionBundleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDistributionBundle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDistributionBundleResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDistributionBundle").withMarshaller((Marshaller)new UpdateDistributionBundleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDistributionBundleRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateDistributionBundle$448(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateDistributionBundle$449((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDomainEntryResponse> updateDomainEntry(UpdateDomainEntryRequest updateDomainEntryRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateDomainEntryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomainEntry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainEntryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainEntry").withMarshaller((Marshaller)new UpdateDomainEntryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDomainEntryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateDomainEntry$451(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateDomainEntry$452((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLoadBalancerAttributeResponse> updateLoadBalancerAttribute(UpdateLoadBalancerAttributeRequest updateLoadBalancerAttributeRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateLoadBalancerAttributeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLoadBalancerAttribute");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLoadBalancerAttributeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLoadBalancerAttribute").withMarshaller((Marshaller)new UpdateLoadBalancerAttributeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLoadBalancerAttributeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateLoadBalancerAttribute$454(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateLoadBalancerAttribute$455((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRelationalDatabaseResponse> updateRelationalDatabase(UpdateRelationalDatabaseRequest updateRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateRelationalDatabaseRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRelationalDatabaseResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRelationalDatabase").withMarshaller((Marshaller)new UpdateRelationalDatabaseRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRelationalDatabaseRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateRelationalDatabase$457(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateRelationalDatabase$458((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRelationalDatabaseParametersResponse> updateRelationalDatabaseParameters(UpdateRelationalDatabaseParametersRequest updateRelationalDatabaseParametersRequest) {
        List<MetricPublisher> metricPublishers = DefaultLightsailAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateRelationalDatabaseParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRelationalDatabaseParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRelationalDatabaseParametersResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRelationalDatabaseParameters").withMarshaller((Marshaller)new UpdateRelationalDatabaseParametersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRelationalDatabaseParametersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLightsailAsyncClient.lambda$updateRelationalDatabaseParameters$460(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLightsailAsyncClient.lambda$updateRelationalDatabaseParameters$461((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LightsailException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("UnauthenticatedException").exceptionBuilderSupplier(UnauthenticatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceException").exceptionBuilderSupplier(ServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountSetupInProgressException").exceptionBuilderSupplier(AccountSetupInProgressException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationFailureException").exceptionBuilderSupplier(OperationFailureException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private static /* synthetic */ void lambda$updateRelationalDatabaseParameters$461(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRelationalDatabaseParameters$460(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRelationalDatabaseParametersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRelationalDatabase$458(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRelationalDatabase$457(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLoadBalancerAttribute$455(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLoadBalancerAttribute$454(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLoadBalancerAttributeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDomainEntry$452(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDomainEntry$451(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDomainEntryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDistributionBundle$449(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDistributionBundle$448(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDistributionBundleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDistribution$446(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDistribution$445(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateContainerService$443(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContainerService$442(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateContainerServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBucketBundle$440(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBucketBundle$439(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBucketBundleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBucket$437(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBucket$436(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBucketResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$434(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$433(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$unpeerVpc$431(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unpeerVpc$430(List metricPublishers, MetricCollector apiCallMetricCollector, UnpeerVpcResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$testAlarm$428(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testAlarm$427(List metricPublishers, MetricCollector apiCallMetricCollector, TestAlarmResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$425(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$424(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopRelationalDatabase$422(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopRelationalDatabase$421(List metricPublishers, MetricCollector apiCallMetricCollector, StopRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopInstance$419(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopInstance$418(List metricPublishers, MetricCollector apiCallMetricCollector, StopInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startRelationalDatabase$416(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startRelationalDatabase$415(List metricPublishers, MetricCollector apiCallMetricCollector, StartRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startInstance$413(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startInstance$412(List metricPublishers, MetricCollector apiCallMetricCollector, StartInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setResourceAccessForBucket$410(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setResourceAccessForBucket$409(List metricPublishers, MetricCollector apiCallMetricCollector, SetResourceAccessForBucketResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setIpAddressType$407(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIpAddressType$406(List metricPublishers, MetricCollector apiCallMetricCollector, SetIpAddressTypeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$sendContactMethodVerification$404(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendContactMethodVerification$403(List metricPublishers, MetricCollector apiCallMetricCollector, SendContactMethodVerificationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$resetDistributionCache$401(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resetDistributionCache$400(List metricPublishers, MetricCollector apiCallMetricCollector, ResetDistributionCacheResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$releaseStaticIp$398(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$releaseStaticIp$397(List metricPublishers, MetricCollector apiCallMetricCollector, ReleaseStaticIpResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerContainerImage$395(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerContainerImage$394(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterContainerImageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rebootRelationalDatabase$392(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootRelationalDatabase$391(List metricPublishers, MetricCollector apiCallMetricCollector, RebootRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$rebootInstance$389(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootInstance$388(List metricPublishers, MetricCollector apiCallMetricCollector, RebootInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putInstancePublicPorts$386(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putInstancePublicPorts$385(List metricPublishers, MetricCollector apiCallMetricCollector, PutInstancePublicPortsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAlarm$383(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAlarm$382(List metricPublishers, MetricCollector apiCallMetricCollector, PutAlarmResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$peerVpc$380(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$peerVpc$379(List metricPublishers, MetricCollector apiCallMetricCollector, PeerVpcResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$openInstancePublicPorts$377(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$openInstancePublicPorts$376(List metricPublishers, MetricCollector apiCallMetricCollector, OpenInstancePublicPortsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$isVpcPeered$374(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$isVpcPeered$373(List metricPublishers, MetricCollector apiCallMetricCollector, IsVpcPeeredResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importKeyPair$371(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importKeyPair$370(List metricPublishers, MetricCollector apiCallMetricCollector, ImportKeyPairResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getStaticIps$368(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStaticIps$367(List metricPublishers, MetricCollector apiCallMetricCollector, GetStaticIpsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getStaticIp$365(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStaticIp$364(List metricPublishers, MetricCollector apiCallMetricCollector, GetStaticIpResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabases$362(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabases$361(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabasesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseSnapshots$359(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseSnapshots$358(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseSnapshot$356(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseSnapshot$355(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseParameters$353(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseParameters$352(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseParametersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseMetricData$350(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseMetricData$349(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseMasterUserPassword$347(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseMasterUserPassword$346(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseMasterUserPasswordResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseLogStreams$344(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseLogStreams$343(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseLogStreamsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseLogEvents$341(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseLogEvents$340(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseLogEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseEvents$338(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseEvents$337(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseBundles$335(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseBundles$334(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseBundlesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseBlueprints$332(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabaseBlueprints$331(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseBlueprintsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRelationalDatabase$329(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRelationalDatabase$328(List metricPublishers, MetricCollector apiCallMetricCollector, GetRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRegions$326(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRegions$325(List metricPublishers, MetricCollector apiCallMetricCollector, GetRegionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOperationsForResource$323(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperationsForResource$322(List metricPublishers, MetricCollector apiCallMetricCollector, GetOperationsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOperations$320(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperations$319(List metricPublishers, MetricCollector apiCallMetricCollector, GetOperationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getOperation$317(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperation$316(List metricPublishers, MetricCollector apiCallMetricCollector, GetOperationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLoadBalancers$314(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancers$313(List metricPublishers, MetricCollector apiCallMetricCollector, GetLoadBalancersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLoadBalancerTlsPolicies$311(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancerTlsPolicies$310(List metricPublishers, MetricCollector apiCallMetricCollector, GetLoadBalancerTlsPoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLoadBalancerTlsCertificates$308(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancerTlsCertificates$307(List metricPublishers, MetricCollector apiCallMetricCollector, GetLoadBalancerTlsCertificatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLoadBalancerMetricData$305(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancerMetricData$304(List metricPublishers, MetricCollector apiCallMetricCollector, GetLoadBalancerMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLoadBalancer$302(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLoadBalancer$301(List metricPublishers, MetricCollector apiCallMetricCollector, GetLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getKeyPairs$299(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyPairs$298(List metricPublishers, MetricCollector apiCallMetricCollector, GetKeyPairsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getKeyPair$296(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getKeyPair$295(List metricPublishers, MetricCollector apiCallMetricCollector, GetKeyPairResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstances$293(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstances$292(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstanceState$290(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceState$289(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstanceSnapshots$287(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceSnapshots$286(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstanceSnapshot$284(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceSnapshot$283(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstancePortStates$281(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstancePortStates$280(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstancePortStatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstanceMetricData$278(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceMetricData$277(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstanceAccessDetails$275(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceAccessDetails$274(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceAccessDetailsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInstance$272(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstance$271(List metricPublishers, MetricCollector apiCallMetricCollector, GetInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getExportSnapshotRecords$269(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getExportSnapshotRecords$268(List metricPublishers, MetricCollector apiCallMetricCollector, GetExportSnapshotRecordsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDomains$266(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomains$265(List metricPublishers, MetricCollector apiCallMetricCollector, GetDomainsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDomain$263(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomain$262(List metricPublishers, MetricCollector apiCallMetricCollector, GetDomainResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDistributions$260(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributions$259(List metricPublishers, MetricCollector apiCallMetricCollector, GetDistributionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDistributionMetricData$257(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributionMetricData$256(List metricPublishers, MetricCollector apiCallMetricCollector, GetDistributionMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDistributionLatestCacheReset$254(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributionLatestCacheReset$253(List metricPublishers, MetricCollector apiCallMetricCollector, GetDistributionLatestCacheResetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDistributionBundles$251(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDistributionBundles$250(List metricPublishers, MetricCollector apiCallMetricCollector, GetDistributionBundlesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDisks$248(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDisks$247(List metricPublishers, MetricCollector apiCallMetricCollector, GetDisksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDiskSnapshots$245(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDiskSnapshots$244(List metricPublishers, MetricCollector apiCallMetricCollector, GetDiskSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDiskSnapshot$242(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDiskSnapshot$241(List metricPublishers, MetricCollector apiCallMetricCollector, GetDiskSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDisk$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDisk$238(List metricPublishers, MetricCollector apiCallMetricCollector, GetDiskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerServices$236(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServices$235(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerServicesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerServicePowers$233(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServicePowers$232(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerServicePowersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerServiceMetricData$230(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServiceMetricData$229(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerServiceMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerServiceDeployments$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerServiceDeployments$226(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerServiceDeploymentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerLog$224(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerLog$223(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerLogResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerImages$221(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerImages$220(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerImagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContainerAPIMetadata$218(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContainerAPIMetadata$217(List metricPublishers, MetricCollector apiCallMetricCollector, GetContainerApiMetadataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getContactMethods$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContactMethods$214(List metricPublishers, MetricCollector apiCallMetricCollector, GetContactMethodsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCloudFormationStackRecords$212(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCloudFormationStackRecords$211(List metricPublishers, MetricCollector apiCallMetricCollector, GetCloudFormationStackRecordsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCertificates$209(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCertificates$208(List metricPublishers, MetricCollector apiCallMetricCollector, GetCertificatesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBundles$206(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBundles$205(List metricPublishers, MetricCollector apiCallMetricCollector, GetBundlesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBuckets$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBuckets$202(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBucketMetricData$200(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketMetricData$199(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBucketBundles$197(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketBundles$196(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketBundlesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBucketAccessKeys$194(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketAccessKeys$193(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketAccessKeysResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBlueprints$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBlueprints$190(List metricPublishers, MetricCollector apiCallMetricCollector, GetBlueprintsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAutoSnapshots$188(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAutoSnapshots$187(List metricPublishers, MetricCollector apiCallMetricCollector, GetAutoSnapshotsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAlarms$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAlarms$184(List metricPublishers, MetricCollector apiCallMetricCollector, GetAlarmsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getActiveNames$182(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getActiveNames$181(List metricPublishers, MetricCollector apiCallMetricCollector, GetActiveNamesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$exportSnapshot$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportSnapshot$178(List metricPublishers, MetricCollector apiCallMetricCollector, ExportSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableAddOn$176(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableAddOn$175(List metricPublishers, MetricCollector apiCallMetricCollector, EnableAddOnResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$downloadDefaultKeyPair$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$downloadDefaultKeyPair$172(List metricPublishers, MetricCollector apiCallMetricCollector, DownloadDefaultKeyPairResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableAddOn$170(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableAddOn$169(List metricPublishers, MetricCollector apiCallMetricCollector, DisableAddOnResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachStaticIp$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachStaticIp$166(List metricPublishers, MetricCollector apiCallMetricCollector, DetachStaticIpResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachInstancesFromLoadBalancer$164(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachInstancesFromLoadBalancer$163(List metricPublishers, MetricCollector apiCallMetricCollector, DetachInstancesFromLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachDisk$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachDisk$160(List metricPublishers, MetricCollector apiCallMetricCollector, DetachDiskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachCertificateFromDistribution$158(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachCertificateFromDistribution$157(List metricPublishers, MetricCollector apiCallMetricCollector, DetachCertificateFromDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRelationalDatabaseSnapshot$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRelationalDatabaseSnapshot$154(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRelationalDatabaseSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRelationalDatabase$152(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRelationalDatabase$151(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLoadBalancerTlsCertificate$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoadBalancerTlsCertificate$148(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLoadBalancerTlsCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLoadBalancer$146(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoadBalancer$145(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteKnownHostKeys$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKnownHostKeys$142(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteKnownHostKeysResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteKeyPair$140(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteKeyPair$139(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteKeyPairResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteInstanceSnapshot$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInstanceSnapshot$136(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteInstanceSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteInstance$134(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInstance$133(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDomainEntry$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomainEntry$130(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDomainEntryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDomain$128(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomain$127(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDomainResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDistribution$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDistribution$124(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDiskSnapshot$122(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDiskSnapshot$121(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDiskSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDisk$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDisk$118(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDiskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteContainerService$116(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContainerService$115(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteContainerServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteContainerImage$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContainerImage$112(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteContainerImageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteContactMethod$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteContactMethod$109(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteContactMethodResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCertificate$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCertificate$106(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBucketAccessKey$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketAccessKey$103(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBucketAccessKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBucket$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucket$100(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBucketResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAutoSnapshot$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAutoSnapshot$97(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAutoSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAlarm$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAlarm$94(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAlarmResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRelationalDatabaseSnapshot$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRelationalDatabaseSnapshot$91(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRelationalDatabaseSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRelationalDatabaseFromSnapshot$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRelationalDatabaseFromSnapshot$88(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRelationalDatabaseFromSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRelationalDatabase$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRelationalDatabase$85(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRelationalDatabaseResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLoadBalancerTlsCertificate$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLoadBalancerTlsCertificate$82(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLoadBalancerTlsCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLoadBalancer$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLoadBalancer$79(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createKeyPair$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createKeyPair$76(List metricPublishers, MetricCollector apiCallMetricCollector, CreateKeyPairResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createInstancesFromSnapshot$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInstancesFromSnapshot$73(List metricPublishers, MetricCollector apiCallMetricCollector, CreateInstancesFromSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createInstances$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInstances$70(List metricPublishers, MetricCollector apiCallMetricCollector, CreateInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createInstanceSnapshot$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInstanceSnapshot$67(List metricPublishers, MetricCollector apiCallMetricCollector, CreateInstanceSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDomainEntry$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDomainEntry$64(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDomainEntryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDomain$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDomain$61(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDomainResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDistribution$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDistribution$58(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDiskSnapshot$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDiskSnapshot$55(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDiskSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDiskFromSnapshot$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDiskFromSnapshot$52(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDiskFromSnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDisk$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDisk$49(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDiskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createContainerServiceRegistryLogin$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContainerServiceRegistryLogin$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateContainerServiceRegistryLoginResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createContainerServiceDeployment$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContainerServiceDeployment$43(List metricPublishers, MetricCollector apiCallMetricCollector, CreateContainerServiceDeploymentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createContainerService$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContainerService$40(List metricPublishers, MetricCollector apiCallMetricCollector, CreateContainerServiceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createContactMethod$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createContactMethod$37(List metricPublishers, MetricCollector apiCallMetricCollector, CreateContactMethodResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCloudFormationStack$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCloudFormationStack$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCloudFormationStackResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCertificate$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCertificate$31(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBucketAccessKey$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBucketAccessKey$28(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBucketAccessKeyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBucket$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBucket$25(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBucketResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$copySnapshot$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$copySnapshot$22(List metricPublishers, MetricCollector apiCallMetricCollector, CopySnapshotResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$closeInstancePublicPorts$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$closeInstancePublicPorts$19(List metricPublishers, MetricCollector apiCallMetricCollector, CloseInstancePublicPortsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachStaticIp$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachStaticIp$16(List metricPublishers, MetricCollector apiCallMetricCollector, AttachStaticIpResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachLoadBalancerTlsCertificate$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachLoadBalancerTlsCertificate$13(List metricPublishers, MetricCollector apiCallMetricCollector, AttachLoadBalancerTlsCertificateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachInstancesToLoadBalancer$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachInstancesToLoadBalancer$10(List metricPublishers, MetricCollector apiCallMetricCollector, AttachInstancesToLoadBalancerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachDisk$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachDisk$7(List metricPublishers, MetricCollector apiCallMetricCollector, AttachDiskResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachCertificateToDistribution$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachCertificateToDistribution$4(List metricPublishers, MetricCollector apiCallMetricCollector, AttachCertificateToDistributionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$allocateStaticIp$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$allocateStaticIp$1(List metricPublishers, MetricCollector apiCallMetricCollector, AllocateStaticIpResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

