/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.StaticIp;
import software.amazon.awssdk.services.lightsail.model.StaticIpListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStaticIpsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetStaticIpsResponse> {
    private static final SdkField<List<StaticIp>> STATIC_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("staticIps").getter(GetStaticIpsResponse.getter(GetStaticIpsResponse::staticIps)).setter(GetStaticIpsResponse.setter(Builder::staticIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StaticIp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetStaticIpsResponse.getter(GetStaticIpsResponse::nextPageToken)).setter(GetStaticIpsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_IPS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<StaticIp> staticIps;
    private final String nextPageToken;

    private GetStaticIpsResponse(BuilderImpl builder) {
        super(builder);
        this.staticIps = builder.staticIps;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasStaticIps() {
        return this.staticIps != null && !(this.staticIps instanceof SdkAutoConstructList);
    }

    public final List<StaticIp> staticIps() {
        return this.staticIps;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStaticIps() ? this.staticIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStaticIpsResponse)) {
            return false;
        }
        GetStaticIpsResponse other = (GetStaticIpsResponse)((Object)obj);
        return this.hasStaticIps() == other.hasStaticIps() && Objects.equals(this.staticIps(), other.staticIps()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetStaticIpsResponse").add("StaticIps", this.hasStaticIps() ? this.staticIps() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "staticIps": {
                return Optional.ofNullable(clazz.cast(this.staticIps()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStaticIpsResponse, T> g) {
        return obj -> g.apply((GetStaticIpsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<StaticIp> staticIps = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStaticIpsResponse model) {
            super(model);
            this.staticIps(model.staticIps);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<StaticIp.Builder> getStaticIps() {
            List<StaticIp.Builder> result = StaticIpListCopier.copyToBuilder(this.staticIps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStaticIps(Collection<StaticIp.BuilderImpl> staticIps) {
            this.staticIps = StaticIpListCopier.copyFromBuilder(staticIps);
        }

        @Override
        @Transient
        public final Builder staticIps(Collection<StaticIp> staticIps) {
            this.staticIps = StaticIpListCopier.copy(staticIps);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder staticIps(StaticIp ... staticIps) {
            this.staticIps(Arrays.asList(staticIps));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder staticIps(Consumer<StaticIp.Builder> ... staticIps) {
            this.staticIps(Stream.of(staticIps).map(c -> (StaticIp)((StaticIp.Builder)StaticIp.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetStaticIpsResponse build() {
            return new GetStaticIpsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStaticIpsResponse> {
        public Builder staticIps(Collection<StaticIp> var1);

        public Builder staticIps(StaticIp ... var1);

        public Builder staticIps(Consumer<StaticIp.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

