/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceHealthReason {
    LB_REGISTRATION_IN_PROGRESS("Lb.RegistrationInProgress"),
    LB_INITIAL_HEALTH_CHECKING("Lb.InitialHealthChecking"),
    LB_INTERNAL_ERROR("Lb.InternalError"),
    INSTANCE_RESPONSE_CODE_MISMATCH("Instance.ResponseCodeMismatch"),
    INSTANCE_TIMEOUT("Instance.Timeout"),
    INSTANCE_FAILED_HEALTH_CHECKS("Instance.FailedHealthChecks"),
    INSTANCE_NOT_REGISTERED("Instance.NotRegistered"),
    INSTANCE_NOT_IN_USE("Instance.NotInUse"),
    INSTANCE_DEREGISTRATION_IN_PROGRESS("Instance.DeregistrationInProgress"),
    INSTANCE_INVALID_STATE("Instance.InvalidState"),
    INSTANCE_IP_UNUSABLE("Instance.IpUnusable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceHealthReason> VALUE_MAP;
    private final String value;

    private InstanceHealthReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceHealthReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceHealthReason> knownValues() {
        EnumSet<InstanceHealthReason> knownValues = EnumSet.allOf(InstanceHealthReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceHealthReason.class, InstanceHealthReason::toString);
    }
}

