/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AddOn;
import software.amazon.awssdk.services.lightsail.model.AddOnListCopier;
import software.amazon.awssdk.services.lightsail.model.DiskState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Disk
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Disk> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Disk.getter(Disk::name)).setter(Disk.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Disk.getter(Disk::arn)).setter(Disk.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("supportCode").getter(Disk.getter(Disk::supportCode)).setter(Disk.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Disk.getter(Disk::createdAt)).setter(Disk.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(Disk.getter(Disk::location)).setter(Disk.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(Disk.getter(Disk::resourceTypeAsString)).setter(Disk.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(Disk.getter(Disk::tags)).setter(Disk.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AddOn>> ADD_ONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addOns").getter(Disk.getter(Disk::addOns)).setter(Disk.setter(Builder::addOns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddOn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sizeInGb").getter(Disk.getter(Disk::sizeInGb)).setter(Disk.setter(Builder::sizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()}).build();
    private static final SdkField<Boolean> IS_SYSTEM_DISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSystemDisk").getter(Disk.getter(Disk::isSystemDisk)).setter(Disk.setter(Builder::isSystemDisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSystemDisk").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("iops").getter(Disk.getter(Disk::iops)).setter(Disk.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(Disk.getter(Disk::path)).setter(Disk.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Disk.getter(Disk::stateAsString)).setter(Disk.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> ATTACHED_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachedTo").getter(Disk.getter(Disk::attachedTo)).setter(Disk.setter(Builder::attachedTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedTo").build()}).build();
    private static final SdkField<Boolean> IS_ATTACHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAttached").getter(Disk.getter(Disk::isAttached)).setter(Disk.setter(Builder::isAttached)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAttached").build()}).build();
    private static final SdkField<String> ATTACHMENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentState").getter(Disk.getter(Disk::attachmentState)).setter(Disk.setter(Builder::attachmentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentState").build()}).build();
    private static final SdkField<Integer> GB_IN_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("gbInUse").getter(Disk.getter(Disk::gbInUse)).setter(Disk.setter(Builder::gbInUse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gbInUse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, ADD_ONS_FIELD, SIZE_IN_GB_FIELD, IS_SYSTEM_DISK_FIELD, IOPS_FIELD, PATH_FIELD, STATE_FIELD, ATTACHED_TO_FIELD, IS_ATTACHED_FIELD, ATTACHMENT_STATE_FIELD, GB_IN_USE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final List<Tag> tags;
    private final List<AddOn> addOns;
    private final Integer sizeInGb;
    private final Boolean isSystemDisk;
    private final Integer iops;
    private final String path;
    private final String state;
    private final String attachedTo;
    private final Boolean isAttached;
    private final String attachmentState;
    private final Integer gbInUse;

    private Disk(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.addOns = builder.addOns;
        this.sizeInGb = builder.sizeInGb;
        this.isSystemDisk = builder.isSystemDisk;
        this.iops = builder.iops;
        this.path = builder.path;
        this.state = builder.state;
        this.attachedTo = builder.attachedTo;
        this.isAttached = builder.isAttached;
        this.attachmentState = builder.attachmentState;
        this.gbInUse = builder.gbInUse;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String supportCode() {
        return this.supportCode;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ResourceLocation location() {
        return this.location;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasAddOns() {
        return this.addOns != null && !(this.addOns instanceof SdkAutoConstructList);
    }

    public final List<AddOn> addOns() {
        return this.addOns;
    }

    public final Integer sizeInGb() {
        return this.sizeInGb;
    }

    public final Boolean isSystemDisk() {
        return this.isSystemDisk;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final String path() {
        return this.path;
    }

    public final DiskState state() {
        return DiskState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String attachedTo() {
        return this.attachedTo;
    }

    public final Boolean isAttached() {
        return this.isAttached;
    }

    @Deprecated
    public final String attachmentState() {
        return this.attachmentState;
    }

    @Deprecated
    public final Integer gbInUse() {
        return this.gbInUse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddOns() ? this.addOns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSystemDisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAttached());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentState());
        hashCode = 31 * hashCode + Objects.hashCode(this.gbInUse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Disk)) {
            return false;
        }
        Disk other = (Disk)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasAddOns() == other.hasAddOns() && Objects.equals(this.addOns(), other.addOns()) && Objects.equals(this.sizeInGb(), other.sizeInGb()) && Objects.equals(this.isSystemDisk(), other.isSystemDisk()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.attachedTo(), other.attachedTo()) && Objects.equals(this.isAttached(), other.isAttached()) && Objects.equals(this.attachmentState(), other.attachmentState()) && Objects.equals(this.gbInUse(), other.gbInUse());
    }

    public final String toString() {
        return ToString.builder((String)"Disk").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("AddOns", this.hasAddOns() ? this.addOns() : null).add("SizeInGb", (Object)this.sizeInGb()).add("IsSystemDisk", (Object)this.isSystemDisk()).add("Iops", (Object)this.iops()).add("Path", (Object)this.path()).add("State", (Object)this.stateAsString()).add("AttachedTo", (Object)this.attachedTo()).add("IsAttached", (Object)this.isAttached()).add("AttachmentState", (Object)this.attachmentState()).add("GbInUse", (Object)this.gbInUse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "addOns": {
                return Optional.ofNullable(clazz.cast(this.addOns()));
            }
            case "sizeInGb": {
                return Optional.ofNullable(clazz.cast(this.sizeInGb()));
            }
            case "isSystemDisk": {
                return Optional.ofNullable(clazz.cast(this.isSystemDisk()));
            }
            case "iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "attachedTo": {
                return Optional.ofNullable(clazz.cast(this.attachedTo()));
            }
            case "isAttached": {
                return Optional.ofNullable(clazz.cast(this.isAttached()));
            }
            case "attachmentState": {
                return Optional.ofNullable(clazz.cast(this.attachmentState()));
            }
            case "gbInUse": {
                return Optional.ofNullable(clazz.cast(this.gbInUse()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Disk, T> g) {
        return obj -> g.apply((Disk)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<AddOn> addOns = DefaultSdkAutoConstructList.getInstance();
        private Integer sizeInGb;
        private Boolean isSystemDisk;
        private Integer iops;
        private String path;
        private String state;
        private String attachedTo;
        private Boolean isAttached;
        private String attachmentState;
        private Integer gbInUse;

        private BuilderImpl() {
        }

        private BuilderImpl(Disk model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.tags(model.tags);
            this.addOns(model.addOns);
            this.sizeInGb(model.sizeInGb);
            this.isSystemDisk(model.isSystemDisk);
            this.iops(model.iops);
            this.path(model.path);
            this.state(model.state);
            this.attachedTo(model.attachedTo);
            this.isAttached(model.isAttached);
            this.attachmentState(model.attachmentState);
            this.gbInUse(model.gbInUse);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        @Override
        @Transient
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        @Transient
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AddOn.Builder> getAddOns() {
            List<AddOn.Builder> result = AddOnListCopier.copyToBuilder(this.addOns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOns(Collection<AddOn.BuilderImpl> addOns) {
            this.addOns = AddOnListCopier.copyFromBuilder(addOns);
        }

        @Override
        @Transient
        public final Builder addOns(Collection<AddOn> addOns) {
            this.addOns = AddOnListCopier.copy(addOns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addOns(AddOn ... addOns) {
            this.addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addOns(Consumer<AddOn.Builder> ... addOns) {
            this.addOns(Stream.of(addOns).map(c -> (AddOn)((AddOn.Builder)AddOn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        @Transient
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final Boolean getIsSystemDisk() {
            return this.isSystemDisk;
        }

        public final void setIsSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
        }

        @Override
        @Transient
        public final Builder isSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        @Transient
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(DiskState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getAttachedTo() {
            return this.attachedTo;
        }

        public final void setAttachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
        }

        @Override
        @Transient
        public final Builder attachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
            return this;
        }

        public final Boolean getIsAttached() {
            return this.isAttached;
        }

        public final void setIsAttached(Boolean isAttached) {
            this.isAttached = isAttached;
        }

        @Override
        @Transient
        public final Builder isAttached(Boolean isAttached) {
            this.isAttached = isAttached;
            return this;
        }

        @Deprecated
        public final String getAttachmentState() {
            return this.attachmentState;
        }

        @Deprecated
        public final void setAttachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder attachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
            return this;
        }

        @Deprecated
        public final Integer getGbInUse() {
            return this.gbInUse;
        }

        @Deprecated
        public final void setGbInUse(Integer gbInUse) {
            this.gbInUse = gbInUse;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder gbInUse(Integer gbInUse) {
            this.gbInUse = gbInUse;
            return this;
        }

        public Disk build() {
            return new Disk(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Disk> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder addOns(Collection<AddOn> var1);

        public Builder addOns(AddOn ... var1);

        public Builder addOns(Consumer<AddOn.Builder> ... var1);

        public Builder sizeInGb(Integer var1);

        public Builder isSystemDisk(Boolean var1);

        public Builder iops(Integer var1);

        public Builder path(String var1);

        public Builder state(String var1);

        public Builder state(DiskState var1);

        public Builder attachedTo(String var1);

        public Builder isAttached(Boolean var1);

        @Deprecated
        public Builder attachmentState(String var1);

        @Deprecated
        public Builder gbInUse(Integer var1);
    }
}

