/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshot;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshotListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInstanceSnapshotsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetInstanceSnapshotsResponse> {
    private static final SdkField<List<InstanceSnapshot>> INSTANCE_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceSnapshots").getter(GetInstanceSnapshotsResponse.getter(GetInstanceSnapshotsResponse::instanceSnapshots)).setter(GetInstanceSnapshotsResponse.setter(Builder::instanceSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceSnapshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceSnapshot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetInstanceSnapshotsResponse.getter(GetInstanceSnapshotsResponse::nextPageToken)).setter(GetInstanceSnapshotsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_SNAPSHOTS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<InstanceSnapshot> instanceSnapshots;
    private final String nextPageToken;

    private GetInstanceSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceSnapshots = builder.instanceSnapshots;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasInstanceSnapshots() {
        return this.instanceSnapshots != null && !(this.instanceSnapshots instanceof SdkAutoConstructList);
    }

    public final List<InstanceSnapshot> instanceSnapshots() {
        return this.instanceSnapshots;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceSnapshots() ? this.instanceSnapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceSnapshotsResponse)) {
            return false;
        }
        GetInstanceSnapshotsResponse other = (GetInstanceSnapshotsResponse)((Object)obj);
        return this.hasInstanceSnapshots() == other.hasInstanceSnapshots() && Objects.equals(this.instanceSnapshots(), other.instanceSnapshots()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetInstanceSnapshotsResponse").add("InstanceSnapshots", this.hasInstanceSnapshots() ? this.instanceSnapshots() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceSnapshots": {
                return Optional.ofNullable(clazz.cast(this.instanceSnapshots()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceSnapshotsResponse, T> g) {
        return obj -> g.apply((GetInstanceSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<InstanceSnapshot> instanceSnapshots = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceSnapshotsResponse model) {
            super(model);
            this.instanceSnapshots(model.instanceSnapshots);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<InstanceSnapshot.Builder> getInstanceSnapshots() {
            List<InstanceSnapshot.Builder> result = InstanceSnapshotListCopier.copyToBuilder(this.instanceSnapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder instanceSnapshots(Collection<InstanceSnapshot> instanceSnapshots) {
            this.instanceSnapshots = InstanceSnapshotListCopier.copy(instanceSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceSnapshots(InstanceSnapshot ... instanceSnapshots) {
            this.instanceSnapshots(Arrays.asList(instanceSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceSnapshots(Consumer<InstanceSnapshot.Builder> ... instanceSnapshots) {
            this.instanceSnapshots(Stream.of(instanceSnapshots).map(c -> (InstanceSnapshot)((InstanceSnapshot.Builder)InstanceSnapshot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceSnapshots(Collection<InstanceSnapshot.BuilderImpl> instanceSnapshots) {
            this.instanceSnapshots = InstanceSnapshotListCopier.copyFromBuilder(instanceSnapshots);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetInstanceSnapshotsResponse build() {
            return new GetInstanceSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInstanceSnapshotsResponse> {
        public Builder instanceSnapshots(Collection<InstanceSnapshot> var1);

        public Builder instanceSnapshots(InstanceSnapshot ... var1);

        public Builder instanceSnapshots(Consumer<InstanceSnapshot.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

