/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationalDatabaseParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationalDatabaseParameter> {
    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("allowedValues").getter(RelationalDatabaseParameter.getter(RelationalDatabaseParameter::allowedValues)).setter(RelationalDatabaseParameter.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build()}).build();
    private static final SdkField<String> APPLY_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applyMethod").getter(RelationalDatabaseParameter.getter(RelationalDatabaseParameter::applyMethod)).setter(RelationalDatabaseParameter.setter(Builder::applyMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyMethod").build()}).build();
    private static final SdkField<String> APPLY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applyType").getter(RelationalDatabaseParameter.getter(RelationalDatabaseParameter::applyType)).setter(RelationalDatabaseParameter.setter(Builder::applyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyType").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(RelationalDatabaseParameter.getter(RelationalDatabaseParameter::dataType)).setter(RelationalDatabaseParameter.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(RelationalDatabaseParameter.getter(RelationalDatabaseParameter::description)).setter(RelationalDatabaseParameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> IS_MODIFIABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isModifiable").getter(RelationalDatabaseParameter.getter(RelationalDatabaseParameter::isModifiable)).setter(RelationalDatabaseParameter.setter(Builder::isModifiable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isModifiable").build()}).build();
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parameterName").getter(RelationalDatabaseParameter.getter(RelationalDatabaseParameter::parameterName)).setter(RelationalDatabaseParameter.setter(Builder::parameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterName").build()}).build();
    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parameterValue").getter(RelationalDatabaseParameter.getter(RelationalDatabaseParameter::parameterValue)).setter(RelationalDatabaseParameter.setter(Builder::parameterValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_VALUES_FIELD, APPLY_METHOD_FIELD, APPLY_TYPE_FIELD, DATA_TYPE_FIELD, DESCRIPTION_FIELD, IS_MODIFIABLE_FIELD, PARAMETER_NAME_FIELD, PARAMETER_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String allowedValues;
    private final String applyMethod;
    private final String applyType;
    private final String dataType;
    private final String description;
    private final Boolean isModifiable;
    private final String parameterName;
    private final String parameterValue;

    private RelationalDatabaseParameter(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
        this.applyMethod = builder.applyMethod;
        this.applyType = builder.applyType;
        this.dataType = builder.dataType;
        this.description = builder.description;
        this.isModifiable = builder.isModifiable;
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
    }

    public final String allowedValues() {
        return this.allowedValues;
    }

    public final String applyMethod() {
        return this.applyMethod;
    }

    public final String applyType() {
        return this.applyType;
    }

    public final String dataType() {
        return this.dataType;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean isModifiable() {
        return this.isModifiable;
    }

    public final String parameterName() {
        return this.parameterName;
    }

    public final String parameterValue() {
        return this.parameterValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyType());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isModifiable());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseParameter)) {
            return false;
        }
        RelationalDatabaseParameter other = (RelationalDatabaseParameter)obj;
        return Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.applyMethod(), other.applyMethod()) && Objects.equals(this.applyType(), other.applyType()) && Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isModifiable(), other.isModifiable()) && Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.parameterValue(), other.parameterValue());
    }

    public final String toString() {
        return ToString.builder((String)"RelationalDatabaseParameter").add("AllowedValues", (Object)this.allowedValues()).add("ApplyMethod", (Object)this.applyMethod()).add("ApplyType", (Object)this.applyType()).add("DataType", (Object)this.dataType()).add("Description", (Object)this.description()).add("IsModifiable", (Object)this.isModifiable()).add("ParameterName", (Object)this.parameterName()).add("ParameterValue", (Object)this.parameterValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "applyMethod": {
                return Optional.ofNullable(clazz.cast(this.applyMethod()));
            }
            case "applyType": {
                return Optional.ofNullable(clazz.cast(this.applyType()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "isModifiable": {
                return Optional.ofNullable(clazz.cast(this.isModifiable()));
            }
            case "parameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterName()));
            }
            case "parameterValue": {
                return Optional.ofNullable(clazz.cast(this.parameterValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseParameter, T> g) {
        return obj -> g.apply((RelationalDatabaseParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allowedValues;
        private String applyMethod;
        private String applyType;
        private String dataType;
        private String description;
        private Boolean isModifiable;
        private String parameterName;
        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseParameter model) {
            this.allowedValues(model.allowedValues);
            this.applyMethod(model.applyMethod);
            this.applyType(model.applyType);
            this.dataType(model.dataType);
            this.description(model.description);
            this.isModifiable(model.isModifiable);
            this.parameterName(model.parameterName);
            this.parameterValue(model.parameterValue);
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final String getApplyMethod() {
            return this.applyMethod;
        }

        @Override
        public final Builder applyMethod(String applyMethod) {
            this.applyMethod = applyMethod;
            return this;
        }

        public final void setApplyMethod(String applyMethod) {
            this.applyMethod = applyMethod;
        }

        public final String getApplyType() {
            return this.applyType;
        }

        @Override
        public final Builder applyType(String applyType) {
            this.applyType = applyType;
            return this;
        }

        public final void setApplyType(String applyType) {
            this.applyType = applyType;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getIsModifiable() {
            return this.isModifiable;
        }

        @Override
        public final Builder isModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        public final void setIsModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public RelationalDatabaseParameter build() {
            return new RelationalDatabaseParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationalDatabaseParameter> {
        public Builder allowedValues(String var1);

        public Builder applyMethod(String var1);

        public Builder applyType(String var1);

        public Builder dataType(String var1);

        public Builder description(String var1);

        public Builder isModifiable(Boolean var1);

        public Builder parameterName(String var1);

        public Builder parameterValue(String var1);
    }
}

