/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.KeyPair;
import software.amazon.awssdk.services.lightsail.model.KeyPairListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetKeyPairsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetKeyPairsResponse> {
    private static final SdkField<List<KeyPair>> KEY_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("keyPairs").getter(GetKeyPairsResponse.getter(GetKeyPairsResponse::keyPairs)).setter(GetKeyPairsResponse.setter(Builder::keyPairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPairs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetKeyPairsResponse.getter(GetKeyPairsResponse::nextPageToken)).setter(GetKeyPairsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PAIRS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<KeyPair> keyPairs;
    private final String nextPageToken;

    private GetKeyPairsResponse(BuilderImpl builder) {
        super(builder);
        this.keyPairs = builder.keyPairs;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasKeyPairs() {
        return this.keyPairs != null && !(this.keyPairs instanceof SdkAutoConstructList);
    }

    public List<KeyPair> keyPairs() {
        return this.keyPairs;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyPairsResponse)) {
            return false;
        }
        GetKeyPairsResponse other = (GetKeyPairsResponse)((Object)obj);
        return Objects.equals(this.keyPairs(), other.keyPairs()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetKeyPairsResponse").add("KeyPairs", this.keyPairs()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyPairs": {
                return Optional.ofNullable(clazz.cast(this.keyPairs()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetKeyPairsResponse, T> g) {
        return obj -> g.apply((GetKeyPairsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<KeyPair> keyPairs = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyPairsResponse model) {
            super(model);
            this.keyPairs(model.keyPairs);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<KeyPair.Builder> getKeyPairs() {
            return this.keyPairs != null ? (Collection)this.keyPairs.stream().map(KeyPair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPairs(Collection<KeyPair> keyPairs) {
            this.keyPairs = KeyPairListCopier.copy(keyPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(KeyPair ... keyPairs) {
            this.keyPairs(Arrays.asList(keyPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(Consumer<KeyPair.Builder> ... keyPairs) {
            this.keyPairs(Stream.of(keyPairs).map(c -> (KeyPair)((KeyPair.Builder)KeyPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyPairs(Collection<KeyPair.BuilderImpl> keyPairs) {
            this.keyPairs = KeyPairListCopier.copyFromBuilder(keyPairs);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetKeyPairsResponse build() {
            return new GetKeyPairsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetKeyPairsResponse> {
        public Builder keyPairs(Collection<KeyPair> var1);

        public Builder keyPairs(KeyPair ... var1);

        public Builder keyPairs(Consumer<KeyPair.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

