/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.BlueprintType;
import software.amazon.awssdk.services.lightsail.model.InstancePlatform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Blueprint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Blueprint> {
    private static final SdkField<String> BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blueprintId").getter(Blueprint.getter(Blueprint::blueprintId)).setter(Blueprint.setter(Builder::blueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Blueprint.getter(Blueprint::name)).setter(Blueprint.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("group").getter(Blueprint.getter(Blueprint::group)).setter(Blueprint.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Blueprint.getter(Blueprint::typeAsString)).setter(Blueprint.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Blueprint.getter(Blueprint::description)).setter(Blueprint.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isActive").getter(Blueprint.getter(Blueprint::isActive)).setter(Blueprint.setter(Builder::isActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()}).build();
    private static final SdkField<Integer> MIN_POWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minPower").getter(Blueprint.getter(Blueprint::minPower)).setter(Blueprint.setter(Builder::minPower)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minPower").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(Blueprint.getter(Blueprint::version)).setter(Blueprint.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> VERSION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionCode").getter(Blueprint.getter(Blueprint::versionCode)).setter(Blueprint.setter(Builder::versionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionCode").build()}).build();
    private static final SdkField<String> PRODUCT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productUrl").getter(Blueprint.getter(Blueprint::productUrl)).setter(Blueprint.setter(Builder::productUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productUrl").build()}).build();
    private static final SdkField<String> LICENSE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseUrl").getter(Blueprint.getter(Blueprint::licenseUrl)).setter(Blueprint.setter(Builder::licenseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseUrl").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(Blueprint.getter(Blueprint::platformAsString)).setter(Blueprint.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ID_FIELD, NAME_FIELD, GROUP_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, IS_ACTIVE_FIELD, MIN_POWER_FIELD, VERSION_FIELD, VERSION_CODE_FIELD, PRODUCT_URL_FIELD, LICENSE_URL_FIELD, PLATFORM_FIELD));
    private static final long serialVersionUID = 1L;
    private final String blueprintId;
    private final String name;
    private final String group;
    private final String type;
    private final String description;
    private final Boolean isActive;
    private final Integer minPower;
    private final String version;
    private final String versionCode;
    private final String productUrl;
    private final String licenseUrl;
    private final String platform;

    private Blueprint(BuilderImpl builder) {
        this.blueprintId = builder.blueprintId;
        this.name = builder.name;
        this.group = builder.group;
        this.type = builder.type;
        this.description = builder.description;
        this.isActive = builder.isActive;
        this.minPower = builder.minPower;
        this.version = builder.version;
        this.versionCode = builder.versionCode;
        this.productUrl = builder.productUrl;
        this.licenseUrl = builder.licenseUrl;
        this.platform = builder.platform;
    }

    public String blueprintId() {
        return this.blueprintId;
    }

    public String name() {
        return this.name;
    }

    public String group() {
        return this.group;
    }

    public BlueprintType type() {
        return BlueprintType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public Boolean isActive() {
        return this.isActive;
    }

    public Integer minPower() {
        return this.minPower;
    }

    public String version() {
        return this.version;
    }

    public String versionCode() {
        return this.versionCode;
    }

    public String productUrl() {
        return this.productUrl;
    }

    public String licenseUrl() {
        return this.licenseUrl;
    }

    public InstancePlatform platform() {
        return InstancePlatform.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActive());
        hashCode = 31 * hashCode + Objects.hashCode(this.minPower());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.productUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Blueprint)) {
            return false;
        }
        Blueprint other = (Blueprint)obj;
        return Objects.equals(this.blueprintId(), other.blueprintId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isActive(), other.isActive()) && Objects.equals(this.minPower(), other.minPower()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.versionCode(), other.versionCode()) && Objects.equals(this.productUrl(), other.productUrl()) && Objects.equals(this.licenseUrl(), other.licenseUrl()) && Objects.equals(this.platformAsString(), other.platformAsString());
    }

    public String toString() {
        return ToString.builder((String)"Blueprint").add("BlueprintId", (Object)this.blueprintId()).add("Name", (Object)this.name()).add("Group", (Object)this.group()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("IsActive", (Object)this.isActive()).add("MinPower", (Object)this.minPower()).add("Version", (Object)this.version()).add("VersionCode", (Object)this.versionCode()).add("ProductUrl", (Object)this.productUrl()).add("LicenseUrl", (Object)this.licenseUrl()).add("Platform", (Object)this.platformAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "blueprintId": {
                return Optional.ofNullable(clazz.cast(this.blueprintId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "isActive": {
                return Optional.ofNullable(clazz.cast(this.isActive()));
            }
            case "minPower": {
                return Optional.ofNullable(clazz.cast(this.minPower()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "versionCode": {
                return Optional.ofNullable(clazz.cast(this.versionCode()));
            }
            case "productUrl": {
                return Optional.ofNullable(clazz.cast(this.productUrl()));
            }
            case "licenseUrl": {
                return Optional.ofNullable(clazz.cast(this.licenseUrl()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Blueprint, T> g) {
        return obj -> g.apply((Blueprint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blueprintId;
        private String name;
        private String group;
        private String type;
        private String description;
        private Boolean isActive;
        private Integer minPower;
        private String version;
        private String versionCode;
        private String productUrl;
        private String licenseUrl;
        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(Blueprint model) {
            this.blueprintId(model.blueprintId);
            this.name(model.name);
            this.group(model.group);
            this.type(model.type);
            this.description(model.description);
            this.isActive(model.isActive);
            this.minPower(model.minPower);
            this.version(model.version);
            this.versionCode(model.versionCode);
            this.productUrl(model.productUrl);
            this.licenseUrl(model.licenseUrl);
            this.platform(model.platform);
        }

        public final String getBlueprintId() {
            return this.blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(BlueprintType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getIsActive() {
            return this.isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        public final Integer getMinPower() {
            return this.minPower;
        }

        @Override
        public final Builder minPower(Integer minPower) {
            this.minPower = minPower;
            return this;
        }

        public final void setMinPower(Integer minPower) {
            this.minPower = minPower;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getVersionCode() {
            return this.versionCode;
        }

        @Override
        public final Builder versionCode(String versionCode) {
            this.versionCode = versionCode;
            return this;
        }

        public final void setVersionCode(String versionCode) {
            this.versionCode = versionCode;
        }

        public final String getProductUrl() {
            return this.productUrl;
        }

        @Override
        public final Builder productUrl(String productUrl) {
            this.productUrl = productUrl;
            return this;
        }

        public final void setProductUrl(String productUrl) {
            this.productUrl = productUrl;
        }

        public final String getLicenseUrl() {
            return this.licenseUrl;
        }

        @Override
        public final Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            return this;
        }

        public final void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(InstancePlatform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public Blueprint build() {
            return new Blueprint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Blueprint> {
        public Builder blueprintId(String var1);

        public Builder name(String var1);

        public Builder group(String var1);

        public Builder type(String var1);

        public Builder type(BlueprintType var1);

        public Builder description(String var1);

        public Builder isActive(Boolean var1);

        public Builder minPower(Integer var1);

        public Builder version(String var1);

        public Builder versionCode(String var1);

        public Builder productUrl(String var1);

        public Builder licenseUrl(String var1);

        public Builder platform(String var1);

        public Builder platform(InstancePlatform var1);
    }
}

