/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.Certificate;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateSummary> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateArn").getter(CertificateSummary.getter(CertificateSummary::certificateArn)).setter(CertificateSummary.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateName").getter(CertificateSummary.getter(CertificateSummary::certificateName)).setter(CertificateSummary.setter(Builder::certificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(CertificateSummary.getter(CertificateSummary::domainName)).setter(CertificateSummary.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<Certificate> CERTIFICATE_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("certificateDetail").getter(CertificateSummary.getter(CertificateSummary::certificateDetail)).setter(CertificateSummary.setter(Builder::certificateDetail)).constructor(Certificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateDetail").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CertificateSummary.getter(CertificateSummary::tags)).setter(CertificateSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, CERTIFICATE_NAME_FIELD, DOMAIN_NAME_FIELD, CERTIFICATE_DETAIL_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateArn;
    private final String certificateName;
    private final String domainName;
    private final Certificate certificateDetail;
    private final List<Tag> tags;

    private CertificateSummary(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateName = builder.certificateName;
        this.domainName = builder.domainName;
        this.certificateDetail = builder.certificateDetail;
        this.tags = builder.tags;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public String domainName() {
        return this.domainName;
    }

    public Certificate certificateDetail() {
        return this.certificateDetail;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateSummary)) {
            return false;
        }
        CertificateSummary other = (CertificateSummary)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.certificateDetail(), other.certificateDetail()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CertificateSummary").add("CertificateArn", (Object)this.certificateArn()).add("CertificateName", (Object)this.certificateName()).add("DomainName", (Object)this.domainName()).add("CertificateDetail", (Object)this.certificateDetail()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "certificateDetail": {
                return Optional.ofNullable(clazz.cast(this.certificateDetail()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateSummary, T> g) {
        return obj -> g.apply((CertificateSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateName;
        private String domainName;
        private Certificate certificateDetail;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateSummary model) {
            this.certificateArn(model.certificateArn);
            this.certificateName(model.certificateName);
            this.domainName(model.domainName);
            this.certificateDetail(model.certificateDetail);
            this.tags(model.tags);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Certificate.Builder getCertificateDetail() {
            return this.certificateDetail != null ? this.certificateDetail.toBuilder() : null;
        }

        @Override
        public final Builder certificateDetail(Certificate certificateDetail) {
            this.certificateDetail = certificateDetail;
            return this;
        }

        public final void setCertificateDetail(Certificate.BuilderImpl certificateDetail) {
            this.certificateDetail = certificateDetail != null ? certificateDetail.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public CertificateSummary build() {
            return new CertificateSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateSummary> {
        public Builder certificateArn(String var1);

        public Builder certificateName(String var1);

        public Builder domainName(String var1);

        public Builder certificateDetail(Certificate var1);

        default public Builder certificateDetail(Consumer<Certificate.Builder> certificateDetail) {
            return this.certificateDetail((Certificate)((Certificate.Builder)Certificate.builder().applyMutation(certificateDetail)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

