/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.DistributionBundle;
import software.amazon.awssdk.services.lightsail.model.DistributionBundleListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDistributionBundlesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetDistributionBundlesResponse> {
    private static final SdkField<List<DistributionBundle>> BUNDLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bundles").getter(GetDistributionBundlesResponse.getter(GetDistributionBundlesResponse::bundles)).setter(GetDistributionBundlesResponse.setter(Builder::bundles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DistributionBundle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLES_FIELD));
    private final List<DistributionBundle> bundles;

    private GetDistributionBundlesResponse(BuilderImpl builder) {
        super(builder);
        this.bundles = builder.bundles;
    }

    public boolean hasBundles() {
        return this.bundles != null && !(this.bundles instanceof SdkAutoConstructList);
    }

    public List<DistributionBundle> bundles() {
        return this.bundles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBundles() ? this.bundles() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionBundlesResponse)) {
            return false;
        }
        GetDistributionBundlesResponse other = (GetDistributionBundlesResponse)((Object)obj);
        return this.hasBundles() == other.hasBundles() && Objects.equals(this.bundles(), other.bundles());
    }

    public String toString() {
        return ToString.builder((String)"GetDistributionBundlesResponse").add("Bundles", this.hasBundles() ? this.bundles() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bundles": {
                return Optional.ofNullable(clazz.cast(this.bundles()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionBundlesResponse, T> g) {
        return obj -> g.apply((GetDistributionBundlesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<DistributionBundle> bundles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionBundlesResponse model) {
            super(model);
            this.bundles(model.bundles);
        }

        public final Collection<DistributionBundle.Builder> getBundles() {
            if (this.bundles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bundles != null ? (Collection)this.bundles.stream().map(DistributionBundle::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bundles(Collection<DistributionBundle> bundles) {
            this.bundles = DistributionBundleListCopier.copy(bundles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(DistributionBundle ... bundles) {
            this.bundles(Arrays.asList(bundles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(Consumer<DistributionBundle.Builder> ... bundles) {
            this.bundles(Stream.of(bundles).map(c -> (DistributionBundle)((DistributionBundle.Builder)DistributionBundle.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBundles(Collection<DistributionBundle.BuilderImpl> bundles) {
            this.bundles = DistributionBundleListCopier.copyFromBuilder(bundles);
        }

        @Override
        public GetDistributionBundlesResponse build() {
            return new GetDistributionBundlesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDistributionBundlesResponse> {
        public Builder bundles(Collection<DistributionBundle> var1);

        public Builder bundles(DistributionBundle ... var1);

        public Builder bundles(Consumer<DistributionBundle.Builder> ... var1);
    }
}

