/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetActiveNamesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetActiveNamesResponse> {
    private static final SdkField<List<String>> ACTIVE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activeNames").getter(GetActiveNamesResponse.getter(GetActiveNamesResponse::activeNames)).setter(GetActiveNamesResponse.setter(Builder::activeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetActiveNamesResponse.getter(GetActiveNamesResponse::nextPageToken)).setter(GetActiveNamesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_NAMES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<String> activeNames;
    private final String nextPageToken;

    private GetActiveNamesResponse(BuilderImpl builder) {
        super(builder);
        this.activeNames = builder.activeNames;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasActiveNames() {
        return this.activeNames != null && !(this.activeNames instanceof SdkAutoConstructList);
    }

    public List<String> activeNames() {
        return this.activeNames;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveNames() ? this.activeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetActiveNamesResponse)) {
            return false;
        }
        GetActiveNamesResponse other = (GetActiveNamesResponse)((Object)obj);
        return this.hasActiveNames() == other.hasActiveNames() && Objects.equals(this.activeNames(), other.activeNames()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetActiveNamesResponse").add("ActiveNames", this.hasActiveNames() ? this.activeNames() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeNames": {
                return Optional.ofNullable(clazz.cast(this.activeNames()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetActiveNamesResponse, T> g) {
        return obj -> g.apply((GetActiveNamesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<String> activeNames = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetActiveNamesResponse model) {
            super(model);
            this.activeNames(model.activeNames);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<String> getActiveNames() {
            if (this.activeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.activeNames;
        }

        @Override
        public final Builder activeNames(Collection<String> activeNames) {
            this.activeNames = StringListCopier.copy(activeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeNames(String ... activeNames) {
            this.activeNames(Arrays.asList(activeNames));
            return this;
        }

        public final void setActiveNames(Collection<String> activeNames) {
            this.activeNames = StringListCopier.copy(activeNames);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetActiveNamesResponse build() {
            return new GetActiveNamesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetActiveNamesResponse> {
        public Builder activeNames(Collection<String> var1);

        public Builder activeNames(String ... var1);

        public Builder nextPageToken(String var1);
    }
}

