/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AccessDirection;
import software.amazon.awssdk.services.lightsail.model.NetworkProtocol;
import software.amazon.awssdk.services.lightsail.model.PortAccessType;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstancePortInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstancePortInfo> {
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("fromPort").getter(InstancePortInfo.getter(InstancePortInfo::fromPort)).setter(InstancePortInfo.setter(Builder::fromPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromPort").build()}).build();
    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("toPort").getter(InstancePortInfo.getter(InstancePortInfo::toPort)).setter(InstancePortInfo.setter(Builder::toPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(InstancePortInfo.getter(InstancePortInfo::protocolAsString)).setter(InstancePortInfo.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> ACCESS_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessFrom").getter(InstancePortInfo.getter(InstancePortInfo::accessFrom)).setter(InstancePortInfo.setter(Builder::accessFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessFrom").build()}).build();
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessType").getter(InstancePortInfo.getter(InstancePortInfo::accessTypeAsString)).setter(InstancePortInfo.setter(Builder::accessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessType").build()}).build();
    private static final SdkField<String> COMMON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commonName").getter(InstancePortInfo.getter(InstancePortInfo::commonName)).setter(InstancePortInfo.setter(Builder::commonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commonName").build()}).build();
    private static final SdkField<String> ACCESS_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessDirection").getter(InstancePortInfo.getter(InstancePortInfo::accessDirectionAsString)).setter(InstancePortInfo.setter(Builder::accessDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessDirection").build()}).build();
    private static final SdkField<List<String>> CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cidrs").getter(InstancePortInfo.getter(InstancePortInfo::cidrs)).setter(InstancePortInfo.setter(Builder::cidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CIDR_LIST_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cidrListAliases").getter(InstancePortInfo.getter(InstancePortInfo::cidrListAliases)).setter(InstancePortInfo.setter(Builder::cidrListAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrListAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PORT_FIELD, TO_PORT_FIELD, PROTOCOL_FIELD, ACCESS_FROM_FIELD, ACCESS_TYPE_FIELD, COMMON_NAME_FIELD, ACCESS_DIRECTION_FIELD, CIDRS_FIELD, CIDR_LIST_ALIASES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer fromPort;
    private final Integer toPort;
    private final String protocol;
    private final String accessFrom;
    private final String accessType;
    private final String commonName;
    private final String accessDirection;
    private final List<String> cidrs;
    private final List<String> cidrListAliases;

    private InstancePortInfo(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.protocol = builder.protocol;
        this.accessFrom = builder.accessFrom;
        this.accessType = builder.accessType;
        this.commonName = builder.commonName;
        this.accessDirection = builder.accessDirection;
        this.cidrs = builder.cidrs;
        this.cidrListAliases = builder.cidrListAliases;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public NetworkProtocol protocol() {
        return NetworkProtocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public String accessFrom() {
        return this.accessFrom;
    }

    public PortAccessType accessType() {
        return PortAccessType.fromValue(this.accessType);
    }

    public String accessTypeAsString() {
        return this.accessType;
    }

    public String commonName() {
        return this.commonName;
    }

    public AccessDirection accessDirection() {
        return AccessDirection.fromValue(this.accessDirection);
    }

    public String accessDirectionAsString() {
        return this.accessDirection;
    }

    public boolean hasCidrs() {
        return this.cidrs != null && !(this.cidrs instanceof SdkAutoConstructList);
    }

    public List<String> cidrs() {
        return this.cidrs;
    }

    public boolean hasCidrListAliases() {
        return this.cidrListAliases != null && !(this.cidrListAliases instanceof SdkAutoConstructList);
    }

    public List<String> cidrListAliases() {
        return this.cidrListAliases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.commonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrs() ? this.cidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrListAliases() ? this.cidrListAliases() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePortInfo)) {
            return false;
        }
        InstancePortInfo other = (InstancePortInfo)obj;
        return Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.toPort(), other.toPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.accessFrom(), other.accessFrom()) && Objects.equals(this.accessTypeAsString(), other.accessTypeAsString()) && Objects.equals(this.commonName(), other.commonName()) && Objects.equals(this.accessDirectionAsString(), other.accessDirectionAsString()) && this.hasCidrs() == other.hasCidrs() && Objects.equals(this.cidrs(), other.cidrs()) && this.hasCidrListAliases() == other.hasCidrListAliases() && Objects.equals(this.cidrListAliases(), other.cidrListAliases());
    }

    public String toString() {
        return ToString.builder((String)"InstancePortInfo").add("FromPort", (Object)this.fromPort()).add("ToPort", (Object)this.toPort()).add("Protocol", (Object)this.protocolAsString()).add("AccessFrom", (Object)this.accessFrom()).add("AccessType", (Object)this.accessTypeAsString()).add("CommonName", (Object)this.commonName()).add("AccessDirection", (Object)this.accessDirectionAsString()).add("Cidrs", this.hasCidrs() ? this.cidrs() : null).add("CidrListAliases", this.hasCidrListAliases() ? this.cidrListAliases() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fromPort": {
                return Optional.ofNullable(clazz.cast(this.fromPort()));
            }
            case "toPort": {
                return Optional.ofNullable(clazz.cast(this.toPort()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "accessFrom": {
                return Optional.ofNullable(clazz.cast(this.accessFrom()));
            }
            case "accessType": {
                return Optional.ofNullable(clazz.cast(this.accessTypeAsString()));
            }
            case "commonName": {
                return Optional.ofNullable(clazz.cast(this.commonName()));
            }
            case "accessDirection": {
                return Optional.ofNullable(clazz.cast(this.accessDirectionAsString()));
            }
            case "cidrs": {
                return Optional.ofNullable(clazz.cast(this.cidrs()));
            }
            case "cidrListAliases": {
                return Optional.ofNullable(clazz.cast(this.cidrListAliases()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstancePortInfo, T> g) {
        return obj -> g.apply((InstancePortInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private Integer toPort;
        private String protocol;
        private String accessFrom;
        private String accessType;
        private String commonName;
        private String accessDirection;
        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();
        private List<String> cidrListAliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePortInfo model) {
            this.fromPort(model.fromPort);
            this.toPort(model.toPort);
            this.protocol(model.protocol);
            this.accessFrom(model.accessFrom);
            this.accessType(model.accessType);
            this.commonName(model.commonName);
            this.accessDirection(model.accessDirection);
            this.cidrs(model.cidrs);
            this.cidrListAliases(model.cidrListAliases);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getAccessFrom() {
            return this.accessFrom;
        }

        @Override
        public final Builder accessFrom(String accessFrom) {
            this.accessFrom = accessFrom;
            return this;
        }

        public final void setAccessFrom(String accessFrom) {
            this.accessFrom = accessFrom;
        }

        public final String getAccessType() {
            return this.accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(PortAccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        public final String getCommonName() {
            return this.commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        public final String getAccessDirection() {
            return this.accessDirection;
        }

        @Override
        public final Builder accessDirection(String accessDirection) {
            this.accessDirection = accessDirection;
            return this;
        }

        @Override
        public final Builder accessDirection(AccessDirection accessDirection) {
            this.accessDirection(accessDirection == null ? null : accessDirection.toString());
            return this;
        }

        public final void setAccessDirection(String accessDirection) {
            this.accessDirection = accessDirection;
        }

        public final Collection<String> getCidrs() {
            if (this.cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrs;
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = StringListCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String ... cidrs) {
            this.cidrs(Arrays.asList(cidrs));
            return this;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = StringListCopier.copy(cidrs);
        }

        public final Collection<String> getCidrListAliases() {
            if (this.cidrListAliases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrListAliases;
        }

        @Override
        public final Builder cidrListAliases(Collection<String> cidrListAliases) {
            this.cidrListAliases = StringListCopier.copy(cidrListAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrListAliases(String ... cidrListAliases) {
            this.cidrListAliases(Arrays.asList(cidrListAliases));
            return this;
        }

        public final void setCidrListAliases(Collection<String> cidrListAliases) {
            this.cidrListAliases = StringListCopier.copy(cidrListAliases);
        }

        public InstancePortInfo build() {
            return new InstancePortInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstancePortInfo> {
        public Builder fromPort(Integer var1);

        public Builder toPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(NetworkProtocol var1);

        public Builder accessFrom(String var1);

        public Builder accessType(String var1);

        public Builder accessType(PortAccessType var1);

        public Builder commonName(String var1);

        public Builder accessDirection(String var1);

        public Builder accessDirection(AccessDirection var1);

        public Builder cidrs(Collection<String> var1);

        public Builder cidrs(String ... var1);

        public Builder cidrListAliases(Collection<String> var1);

        public Builder cidrListAliases(String ... var1);
    }
}

