/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.ContainerService;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContainerServiceResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, CreateContainerServiceResponse> {
    private static final SdkField<ContainerService> CONTAINER_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerService").getter(CreateContainerServiceResponse.getter(CreateContainerServiceResponse::containerService)).setter(CreateContainerServiceResponse.setter(Builder::containerService)).constructor(ContainerService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerService").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_SERVICE_FIELD));
    private final ContainerService containerService;

    private CreateContainerServiceResponse(BuilderImpl builder) {
        super(builder);
        this.containerService = builder.containerService;
    }

    public ContainerService containerService() {
        return this.containerService;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.containerService());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerServiceResponse)) {
            return false;
        }
        CreateContainerServiceResponse other = (CreateContainerServiceResponse)((Object)obj);
        return Objects.equals(this.containerService(), other.containerService());
    }

    public String toString() {
        return ToString.builder((String)"CreateContainerServiceResponse").add("ContainerService", (Object)this.containerService()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerService": {
                return Optional.ofNullable(clazz.cast(this.containerService()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerServiceResponse, T> g) {
        return obj -> g.apply((CreateContainerServiceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private ContainerService containerService;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerServiceResponse model) {
            super(model);
            this.containerService(model.containerService);
        }

        public final ContainerService.Builder getContainerService() {
            return this.containerService != null ? this.containerService.toBuilder() : null;
        }

        @Override
        public final Builder containerService(ContainerService containerService) {
            this.containerService = containerService;
            return this;
        }

        public final void setContainerService(ContainerService.BuilderImpl containerService) {
            this.containerService = containerService != null ? containerService.build() : null;
        }

        @Override
        public CreateContainerServiceResponse build() {
            return new CreateContainerServiceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContainerServiceResponse> {
        public Builder containerService(ContainerService var1);

        default public Builder containerService(Consumer<ContainerService.Builder> containerService) {
            return this.containerService((ContainerService)((ContainerService.Builder)ContainerService.builder().applyMutation(containerService)).build());
        }
    }
}

