/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAlarmRequest extends LightsailRequest implements
        ToCopyableBuilder<PutAlarmRequest.Builder, PutAlarmRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAlarmRequest::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmName").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAlarmRequest::metricNameAsString)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> MONITORED_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAlarmRequest::monitoredResourceName)).setter(setter(Builder::monitoredResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoredResourceName").build())
            .build();

    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAlarmRequest::comparisonOperatorAsString)).setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonOperator").build())
            .build();

    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(PutAlarmRequest::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutAlarmRequest::evaluationPeriods)).setter(setter(Builder::evaluationPeriods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationPeriods").build()).build();

    private static final SdkField<Integer> DATAPOINTS_TO_ALARM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutAlarmRequest::datapointsToAlarm)).setter(setter(Builder::datapointsToAlarm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datapointsToAlarm").build()).build();

    private static final SdkField<String> TREAT_MISSING_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutAlarmRequest::treatMissingDataAsString)).setter(setter(Builder::treatMissingData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatMissingData").build()).build();

    private static final SdkField<List<String>> CONTACT_PROTOCOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PutAlarmRequest::contactProtocolsAsStrings))
            .setter(setter(Builder::contactProtocolsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactProtocols").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOTIFICATION_TRIGGERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PutAlarmRequest::notificationTriggersAsStrings))
            .setter(setter(Builder::notificationTriggersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationTriggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> NOTIFICATION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutAlarmRequest::notificationEnabled)).setter(setter(Builder::notificationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD,
            METRIC_NAME_FIELD, MONITORED_RESOURCE_NAME_FIELD, COMPARISON_OPERATOR_FIELD, THRESHOLD_FIELD,
            EVALUATION_PERIODS_FIELD, DATAPOINTS_TO_ALARM_FIELD, TREAT_MISSING_DATA_FIELD, CONTACT_PROTOCOLS_FIELD,
            NOTIFICATION_TRIGGERS_FIELD, NOTIFICATION_ENABLED_FIELD));

    private final String alarmName;

    private final String metricName;

    private final String monitoredResourceName;

    private final String comparisonOperator;

    private final Double threshold;

    private final Integer evaluationPeriods;

    private final Integer datapointsToAlarm;

    private final String treatMissingData;

    private final List<String> contactProtocols;

    private final List<String> notificationTriggers;

    private final Boolean notificationEnabled;

    private PutAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.metricName = builder.metricName;
        this.monitoredResourceName = builder.monitoredResourceName;
        this.comparisonOperator = builder.comparisonOperator;
        this.threshold = builder.threshold;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.treatMissingData = builder.treatMissingData;
        this.contactProtocols = builder.contactProtocols;
        this.notificationTriggers = builder.notificationTriggers;
        this.notificationEnabled = builder.notificationEnabled;
    }

    /**
     * <p>
     * The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous configuration
     * of the alarm.
     * </p>
     * 
     * @return The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous
     *         configuration of the alarm.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The name of the metric to associate with the alarm.
     * </p>
     * <p>
     * You can configure up to two alarms per metric.
     * </p>
     * <p>
     * The following metrics are available for each resource type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Instances</b>: <code>BurstCapacityPercentage</code>, <code>BurstCapacityTime</code>,
     * <code>CPUUtilization</code>, <code>NetworkIn</code>, <code>NetworkOut</code>, <code>StatusCheckFailed</code>,
     * <code>StatusCheckFailed_Instance</code>, and <code>StatusCheckFailed_System</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Load balancers</b>: <code>ClientTLSNegotiationErrorCount</code>, <code>HealthyHostCount</code>,
     * <code>UnhealthyHostCount</code>, <code>HTTPCode_LB_4XX_Count</code>, <code>HTTPCode_LB_5XX_Count</code>,
     * <code>HTTPCode_Instance_2XX_Count</code>, <code>HTTPCode_Instance_3XX_Count</code>,
     * <code>HTTPCode_Instance_4XX_Count</code>, <code>HTTPCode_Instance_5XX_Count</code>,
     * <code>InstanceResponseTime</code>, <code>RejectedConnectionCount</code>, and <code>RequestCount</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Relational databases</b>: <code>CPUUtilization</code>, <code>DatabaseConnections</code>,
     * <code>DiskQueueDepth</code>, <code>FreeStorageSpace</code>, <code>NetworkReceiveThroughput</code>, and
     * <code>NetworkTransmitThroughput</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about these metrics, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics"
     * >Metrics available in Lightsail</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link MetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the metric to associate with the alarm.</p>
     *         <p>
     *         You can configure up to two alarms per metric.
     *         </p>
     *         <p>
     *         The following metrics are available for each resource type:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Instances</b>: <code>BurstCapacityPercentage</code>, <code>BurstCapacityTime</code>,
     *         <code>CPUUtilization</code>, <code>NetworkIn</code>, <code>NetworkOut</code>,
     *         <code>StatusCheckFailed</code>, <code>StatusCheckFailed_Instance</code>, and
     *         <code>StatusCheckFailed_System</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Load balancers</b>: <code>ClientTLSNegotiationErrorCount</code>, <code>HealthyHostCount</code>,
     *         <code>UnhealthyHostCount</code>, <code>HTTPCode_LB_4XX_Count</code>, <code>HTTPCode_LB_5XX_Count</code>,
     *         <code>HTTPCode_Instance_2XX_Count</code>, <code>HTTPCode_Instance_3XX_Count</code>,
     *         <code>HTTPCode_Instance_4XX_Count</code>, <code>HTTPCode_Instance_5XX_Count</code>,
     *         <code>InstanceResponseTime</code>, <code>RejectedConnectionCount</code>, and <code>RequestCount</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Relational databases</b>: <code>CPUUtilization</code>, <code>DatabaseConnections</code>,
     *         <code>DiskQueueDepth</code>, <code>FreeStorageSpace</code>, <code>NetworkReceiveThroughput</code>, and
     *         <code>NetworkTransmitThroughput</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about these metrics, see <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics"
     *         >Metrics available in Lightsail</a>.
     * @see MetricName
     */
    public MetricName metricName() {
        return MetricName.fromValue(metricName);
    }

    /**
     * <p>
     * The name of the metric to associate with the alarm.
     * </p>
     * <p>
     * You can configure up to two alarms per metric.
     * </p>
     * <p>
     * The following metrics are available for each resource type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Instances</b>: <code>BurstCapacityPercentage</code>, <code>BurstCapacityTime</code>,
     * <code>CPUUtilization</code>, <code>NetworkIn</code>, <code>NetworkOut</code>, <code>StatusCheckFailed</code>,
     * <code>StatusCheckFailed_Instance</code>, and <code>StatusCheckFailed_System</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Load balancers</b>: <code>ClientTLSNegotiationErrorCount</code>, <code>HealthyHostCount</code>,
     * <code>UnhealthyHostCount</code>, <code>HTTPCode_LB_4XX_Count</code>, <code>HTTPCode_LB_5XX_Count</code>,
     * <code>HTTPCode_Instance_2XX_Count</code>, <code>HTTPCode_Instance_3XX_Count</code>,
     * <code>HTTPCode_Instance_4XX_Count</code>, <code>HTTPCode_Instance_5XX_Count</code>,
     * <code>InstanceResponseTime</code>, <code>RejectedConnectionCount</code>, and <code>RequestCount</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Relational databases</b>: <code>CPUUtilization</code>, <code>DatabaseConnections</code>,
     * <code>DiskQueueDepth</code>, <code>FreeStorageSpace</code>, <code>NetworkReceiveThroughput</code>, and
     * <code>NetworkTransmitThroughput</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about these metrics, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics"
     * >Metrics available in Lightsail</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link MetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the metric to associate with the alarm.</p>
     *         <p>
     *         You can configure up to two alarms per metric.
     *         </p>
     *         <p>
     *         The following metrics are available for each resource type:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Instances</b>: <code>BurstCapacityPercentage</code>, <code>BurstCapacityTime</code>,
     *         <code>CPUUtilization</code>, <code>NetworkIn</code>, <code>NetworkOut</code>,
     *         <code>StatusCheckFailed</code>, <code>StatusCheckFailed_Instance</code>, and
     *         <code>StatusCheckFailed_System</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Load balancers</b>: <code>ClientTLSNegotiationErrorCount</code>, <code>HealthyHostCount</code>,
     *         <code>UnhealthyHostCount</code>, <code>HTTPCode_LB_4XX_Count</code>, <code>HTTPCode_LB_5XX_Count</code>,
     *         <code>HTTPCode_Instance_2XX_Count</code>, <code>HTTPCode_Instance_3XX_Count</code>,
     *         <code>HTTPCode_Instance_4XX_Count</code>, <code>HTTPCode_Instance_5XX_Count</code>,
     *         <code>InstanceResponseTime</code>, <code>RejectedConnectionCount</code>, and <code>RequestCount</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Relational databases</b>: <code>CPUUtilization</code>, <code>DatabaseConnections</code>,
     *         <code>DiskQueueDepth</code>, <code>FreeStorageSpace</code>, <code>NetworkReceiveThroughput</code>, and
     *         <code>NetworkTransmitThroughput</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about these metrics, see <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics"
     *         >Metrics available in Lightsail</a>.
     * @see MetricName
     */
    public String metricNameAsString() {
        return metricName;
    }

    /**
     * <p>
     * The name of the Lightsail resource that will be monitored.
     * </p>
     * <p>
     * Instances, load balancers, and relational databases are the only Lightsail resources that can currently be
     * monitored by alarms.
     * </p>
     * 
     * @return The name of the Lightsail resource that will be monitored.</p>
     *         <p>
     *         Instances, load balancers, and relational databases are the only Lightsail resources that can currently
     *         be monitored by alarms.
     */
    public String monitoredResourceName() {
        return monitoredResourceName;
    }

    /**
     * <p>
     * The arithmetic operation to use when comparing the specified statistic to the threshold. The specified statistic
     * value is used as the first operand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The arithmetic operation to use when comparing the specified statistic to the threshold. The specified
     *         statistic value is used as the first operand.
     * @see ComparisonOperator
     */
    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * The arithmetic operation to use when comparing the specified statistic to the threshold. The specified statistic
     * value is used as the first operand.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The arithmetic operation to use when comparing the specified statistic to the threshold. The specified
     *         statistic value is used as the first operand.
     * @see ComparisonOperator
     */
    public String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    /**
     * <p>
     * The value against which the specified statistic is compared.
     * </p>
     * 
     * @return The value against which the specified statistic is compared.
     */
    public Double threshold() {
        return threshold;
    }

    /**
     * <p>
     * The number of most recent periods over which data is compared to the specified threshold. If you are setting an
     * "M out of N" alarm, this value (<code>evaluationPeriods</code>) is the N.
     * </p>
     * <p>
     * If you are setting an alarm that requires that a number of consecutive data points be breaching to trigger the
     * alarm, this value specifies the rolling period of time in which data points are evaluated.
     * </p>
     * <p>
     * Each evaluation period is five minutes long. For example, specify an evaluation period of 24 to evaluate a metric
     * over a rolling period of two hours.
     * </p>
     * <p>
     * You can specify a minimum valuation period of 1 (5 minutes), and a maximum evaluation period of 288 (24 hours).
     * </p>
     * 
     * @return The number of most recent periods over which data is compared to the specified threshold. If you are
     *         setting an "M out of N" alarm, this value (<code>evaluationPeriods</code>) is the N.</p>
     *         <p>
     *         If you are setting an alarm that requires that a number of consecutive data points be breaching to
     *         trigger the alarm, this value specifies the rolling period of time in which data points are evaluated.
     *         </p>
     *         <p>
     *         Each evaluation period is five minutes long. For example, specify an evaluation period of 24 to evaluate
     *         a metric over a rolling period of two hours.
     *         </p>
     *         <p>
     *         You can specify a minimum valuation period of 1 (5 minutes), and a maximum evaluation period of 288 (24
     *         hours).
     */
    public Integer evaluationPeriods() {
        return evaluationPeriods;
    }

    /**
     * <p>
     * The number of data points that must be not within the specified threshold to trigger the alarm. If you are
     * setting an "M out of N" alarm, this value (<code>datapointsToAlarm</code>) is the M.
     * </p>
     * 
     * @return The number of data points that must be not within the specified threshold to trigger the alarm. If you
     *         are setting an "M out of N" alarm, this value (<code>datapointsToAlarm</code>) is the M.
     */
    public Integer datapointsToAlarm() {
        return datapointsToAlarm;
    }

    /**
     * <p>
     * Sets how this alarm will handle missing data points.
     * </p>
     * <p>
     * An alarm can treat missing data in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>breaching</code> - Assume the missing data is not within the threshold. Missing data counts towards the
     * number of times the metric is not within the threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>notBreaching</code> - Assume the missing data is within the threshold. Missing data does not count towards
     * the number of times the metric is not within the threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ignore</code> - Ignore the missing data. Maintains the current alarm state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>missing</code> - Missing data is treated as missing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>treatMissingData</code> is not specified, the default behavior of <code>missing</code> is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #treatMissingData}
     * will return {@link TreatMissingData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #treatMissingDataAsString}.
     * </p>
     * 
     * @return Sets how this alarm will handle missing data points.</p>
     *         <p>
     *         An alarm can treat missing data in the following ways:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>breaching</code> - Assume the missing data is not within the threshold. Missing data counts towards
     *         the number of times the metric is not within the threshold.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>notBreaching</code> - Assume the missing data is within the threshold. Missing data does not count
     *         towards the number of times the metric is not within the threshold.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ignore</code> - Ignore the missing data. Maintains the current alarm state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>missing</code> - Missing data is treated as missing.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>treatMissingData</code> is not specified, the default behavior of <code>missing</code> is used.
     * @see TreatMissingData
     */
    public TreatMissingData treatMissingData() {
        return TreatMissingData.fromValue(treatMissingData);
    }

    /**
     * <p>
     * Sets how this alarm will handle missing data points.
     * </p>
     * <p>
     * An alarm can treat missing data in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>breaching</code> - Assume the missing data is not within the threshold. Missing data counts towards the
     * number of times the metric is not within the threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>notBreaching</code> - Assume the missing data is within the threshold. Missing data does not count towards
     * the number of times the metric is not within the threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ignore</code> - Ignore the missing data. Maintains the current alarm state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>missing</code> - Missing data is treated as missing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>treatMissingData</code> is not specified, the default behavior of <code>missing</code> is used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #treatMissingData}
     * will return {@link TreatMissingData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #treatMissingDataAsString}.
     * </p>
     * 
     * @return Sets how this alarm will handle missing data points.</p>
     *         <p>
     *         An alarm can treat missing data in the following ways:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>breaching</code> - Assume the missing data is not within the threshold. Missing data counts towards
     *         the number of times the metric is not within the threshold.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>notBreaching</code> - Assume the missing data is within the threshold. Missing data does not count
     *         towards the number of times the metric is not within the threshold.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ignore</code> - Ignore the missing data. Maintains the current alarm state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>missing</code> - Missing data is treated as missing.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>treatMissingData</code> is not specified, the default behavior of <code>missing</code> is used.
     * @see TreatMissingData
     */
    public String treatMissingDataAsString() {
        return treatMissingData;
    }

    /**
     * <p>
     * The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text messaging), or
     * both.
     * </p>
     * <p>
     * A notification is sent via the specified contact protocol if notifications are enabled for the alarm, and when
     * the alarm is triggered.
     * </p>
     * <p>
     * A notification is not sent if a contact protocol is not specified, if the specified contact protocol is not
     * configured in the AWS Region, or if notifications are not enabled for the alarm using the
     * <code>notificationEnabled</code> paramater.
     * </p>
     * <p>
     * Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContactProtocols()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text
     *         messaging), or both.</p>
     *         <p>
     *         A notification is sent via the specified contact protocol if notifications are enabled for the alarm, and
     *         when the alarm is triggered.
     *         </p>
     *         <p>
     *         A notification is not sent if a contact protocol is not specified, if the specified contact protocol is
     *         not configured in the AWS Region, or if notifications are not enabled for the alarm using the
     *         <code>notificationEnabled</code> paramater.
     *         </p>
     *         <p>
     *         Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
     */
    public List<ContactProtocol> contactProtocols() {
        return ContactProtocolsListCopier.copyStringToEnum(contactProtocols);
    }

    /**
     * Returns true if the ContactProtocols property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasContactProtocols() {
        return contactProtocols != null && !(contactProtocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text messaging), or
     * both.
     * </p>
     * <p>
     * A notification is sent via the specified contact protocol if notifications are enabled for the alarm, and when
     * the alarm is triggered.
     * </p>
     * <p>
     * A notification is not sent if a contact protocol is not specified, if the specified contact protocol is not
     * configured in the AWS Region, or if notifications are not enabled for the alarm using the
     * <code>notificationEnabled</code> paramater.
     * </p>
     * <p>
     * Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContactProtocols()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text
     *         messaging), or both.</p>
     *         <p>
     *         A notification is sent via the specified contact protocol if notifications are enabled for the alarm, and
     *         when the alarm is triggered.
     *         </p>
     *         <p>
     *         A notification is not sent if a contact protocol is not specified, if the specified contact protocol is
     *         not configured in the AWS Region, or if notifications are not enabled for the alarm using the
     *         <code>notificationEnabled</code> paramater.
     *         </p>
     *         <p>
     *         Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
     */
    public List<String> contactProtocolsAsStrings() {
        return contactProtocols;
    }

    /**
     * <p>
     * The alarm states that trigger a notification.
     * </p>
     * <p>
     * An alarm has the following possible states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALARM</code> - The metric is outside of the defined threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough data is
     * available for the metric to determine the alarm state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OK</code> - The metric is within the defined threshold.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
     * <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the <code>ALARM</code>
     * state.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches from an
     * <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state. This can be thought
     * of as an <i>all clear</i> alarm notification.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the alarm
     * switches from an <code>OK</code> or <code>ALARM</code> alarm state to an <code>INSUFFICIENT_DATA</code> state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotificationTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The alarm states that trigger a notification.</p>
     *         <p>
     *         An alarm has the following possible states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALARM</code> - The metric is outside of the defined threshold.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough
     *         data is available for the metric to determine the alarm state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OK</code> - The metric is within the defined threshold.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
     *         <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the
     *         <code>ALARM</code> state.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches from
     *         an <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state. This can
     *         be thought of as an <i>all clear</i> alarm notification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the alarm
     *         switches from an <code>OK</code> or <code>ALARM</code> alarm state to an <code>INSUFFICIENT_DATA</code>
     *         state.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
     */
    public List<AlarmState> notificationTriggers() {
        return NotificationTriggerListCopier.copyStringToEnum(notificationTriggers);
    }

    /**
     * Returns true if the NotificationTriggers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasNotificationTriggers() {
        return notificationTriggers != null && !(notificationTriggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The alarm states that trigger a notification.
     * </p>
     * <p>
     * An alarm has the following possible states:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALARM</code> - The metric is outside of the defined threshold.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough data is
     * available for the metric to determine the alarm state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OK</code> - The metric is within the defined threshold.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
     * <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the <code>ALARM</code>
     * state.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches from an
     * <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state. This can be thought
     * of as an <i>all clear</i> alarm notification.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the alarm
     * switches from an <code>OK</code> or <code>ALARM</code> alarm state to an <code>INSUFFICIENT_DATA</code> state.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotificationTriggers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The alarm states that trigger a notification.</p>
     *         <p>
     *         An alarm has the following possible states:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALARM</code> - The metric is outside of the defined threshold.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough
     *         data is available for the metric to determine the alarm state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OK</code> - The metric is within the defined threshold.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
     *         <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the
     *         <code>ALARM</code> state.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches from
     *         an <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state. This can
     *         be thought of as an <i>all clear</i> alarm notification.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the alarm
     *         switches from an <code>OK</code> or <code>ALARM</code> alarm state to an <code>INSUFFICIENT_DATA</code>
     *         state.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
     */
    public List<String> notificationTriggersAsStrings() {
        return notificationTriggers;
    }

    /**
     * <p>
     * Indicates whether the alarm is enabled.
     * </p>
     * <p>
     * Notifications are enabled by default if you don't specify this parameter.
     * </p>
     * 
     * @return Indicates whether the alarm is enabled.</p>
     *         <p>
     *         Notifications are enabled by default if you don't specify this parameter.
     */
    public Boolean notificationEnabled() {
        return notificationEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(monitoredResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(treatMissingDataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contactProtocolsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(notificationTriggersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(notificationEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAlarmRequest)) {
            return false;
        }
        PutAlarmRequest other = (PutAlarmRequest) obj;
        return Objects.equals(alarmName(), other.alarmName()) && Objects.equals(metricNameAsString(), other.metricNameAsString())
                && Objects.equals(monitoredResourceName(), other.monitoredResourceName())
                && Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString())
                && Objects.equals(threshold(), other.threshold())
                && Objects.equals(evaluationPeriods(), other.evaluationPeriods())
                && Objects.equals(datapointsToAlarm(), other.datapointsToAlarm())
                && Objects.equals(treatMissingDataAsString(), other.treatMissingDataAsString())
                && Objects.equals(contactProtocolsAsStrings(), other.contactProtocolsAsStrings())
                && Objects.equals(notificationTriggersAsStrings(), other.notificationTriggersAsStrings())
                && Objects.equals(notificationEnabled(), other.notificationEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutAlarmRequest").add("AlarmName", alarmName()).add("MetricName", metricNameAsString())
                .add("MonitoredResourceName", monitoredResourceName()).add("ComparisonOperator", comparisonOperatorAsString())
                .add("Threshold", threshold()).add("EvaluationPeriods", evaluationPeriods())
                .add("DatapointsToAlarm", datapointsToAlarm()).add("TreatMissingData", treatMissingDataAsString())
                .add("ContactProtocols", contactProtocolsAsStrings())
                .add("NotificationTriggers", notificationTriggersAsStrings()).add("NotificationEnabled", notificationEnabled())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "monitoredResourceName":
            return Optional.ofNullable(clazz.cast(monitoredResourceName()));
        case "comparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        case "threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "evaluationPeriods":
            return Optional.ofNullable(clazz.cast(evaluationPeriods()));
        case "datapointsToAlarm":
            return Optional.ofNullable(clazz.cast(datapointsToAlarm()));
        case "treatMissingData":
            return Optional.ofNullable(clazz.cast(treatMissingDataAsString()));
        case "contactProtocols":
            return Optional.ofNullable(clazz.cast(contactProtocolsAsStrings()));
        case "notificationTriggers":
            return Optional.ofNullable(clazz.cast(notificationTriggersAsStrings()));
        case "notificationEnabled":
            return Optional.ofNullable(clazz.cast(notificationEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAlarmRequest, T> g) {
        return obj -> g.apply((PutAlarmRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAlarmRequest> {
        /**
         * <p>
         * The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous
         * configuration of the alarm.
         * </p>
         * 
         * @param alarmName
         *        The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous
         *        configuration of the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The name of the metric to associate with the alarm.
         * </p>
         * <p>
         * You can configure up to two alarms per metric.
         * </p>
         * <p>
         * The following metrics are available for each resource type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Instances</b>: <code>BurstCapacityPercentage</code>, <code>BurstCapacityTime</code>,
         * <code>CPUUtilization</code>, <code>NetworkIn</code>, <code>NetworkOut</code>, <code>StatusCheckFailed</code>,
         * <code>StatusCheckFailed_Instance</code>, and <code>StatusCheckFailed_System</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Load balancers</b>: <code>ClientTLSNegotiationErrorCount</code>, <code>HealthyHostCount</code>,
         * <code>UnhealthyHostCount</code>, <code>HTTPCode_LB_4XX_Count</code>, <code>HTTPCode_LB_5XX_Count</code>,
         * <code>HTTPCode_Instance_2XX_Count</code>, <code>HTTPCode_Instance_3XX_Count</code>,
         * <code>HTTPCode_Instance_4XX_Count</code>, <code>HTTPCode_Instance_5XX_Count</code>,
         * <code>InstanceResponseTime</code>, <code>RejectedConnectionCount</code>, and <code>RequestCount</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Relational databases</b>: <code>CPUUtilization</code>, <code>DatabaseConnections</code>,
         * <code>DiskQueueDepth</code>, <code>FreeStorageSpace</code>, <code>NetworkReceiveThroughput</code>, and
         * <code>NetworkTransmitThroughput</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about these metrics, see <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics"
         * >Metrics available in Lightsail</a>.
         * </p>
         * 
         * @param metricName
         *        The name of the metric to associate with the alarm.</p>
         *        <p>
         *        You can configure up to two alarms per metric.
         *        </p>
         *        <p>
         *        The following metrics are available for each resource type:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Instances</b>: <code>BurstCapacityPercentage</code>, <code>BurstCapacityTime</code>,
         *        <code>CPUUtilization</code>, <code>NetworkIn</code>, <code>NetworkOut</code>,
         *        <code>StatusCheckFailed</code>, <code>StatusCheckFailed_Instance</code>, and
         *        <code>StatusCheckFailed_System</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Load balancers</b>: <code>ClientTLSNegotiationErrorCount</code>, <code>HealthyHostCount</code>,
         *        <code>UnhealthyHostCount</code>, <code>HTTPCode_LB_4XX_Count</code>,
         *        <code>HTTPCode_LB_5XX_Count</code>, <code>HTTPCode_Instance_2XX_Count</code>,
         *        <code>HTTPCode_Instance_3XX_Count</code>, <code>HTTPCode_Instance_4XX_Count</code>,
         *        <code>HTTPCode_Instance_5XX_Count</code>, <code>InstanceResponseTime</code>,
         *        <code>RejectedConnectionCount</code>, and <code>RequestCount</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Relational databases</b>: <code>CPUUtilization</code>, <code>DatabaseConnections</code>,
         *        <code>DiskQueueDepth</code>, <code>FreeStorageSpace</code>, <code>NetworkReceiveThroughput</code>, and
         *        <code>NetworkTransmitThroughput</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about these metrics, see <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics"
         *        >Metrics available in Lightsail</a>.
         * @see MetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The name of the metric to associate with the alarm.
         * </p>
         * <p>
         * You can configure up to two alarms per metric.
         * </p>
         * <p>
         * The following metrics are available for each resource type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Instances</b>: <code>BurstCapacityPercentage</code>, <code>BurstCapacityTime</code>,
         * <code>CPUUtilization</code>, <code>NetworkIn</code>, <code>NetworkOut</code>, <code>StatusCheckFailed</code>,
         * <code>StatusCheckFailed_Instance</code>, and <code>StatusCheckFailed_System</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Load balancers</b>: <code>ClientTLSNegotiationErrorCount</code>, <code>HealthyHostCount</code>,
         * <code>UnhealthyHostCount</code>, <code>HTTPCode_LB_4XX_Count</code>, <code>HTTPCode_LB_5XX_Count</code>,
         * <code>HTTPCode_Instance_2XX_Count</code>, <code>HTTPCode_Instance_3XX_Count</code>,
         * <code>HTTPCode_Instance_4XX_Count</code>, <code>HTTPCode_Instance_5XX_Count</code>,
         * <code>InstanceResponseTime</code>, <code>RejectedConnectionCount</code>, and <code>RequestCount</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Relational databases</b>: <code>CPUUtilization</code>, <code>DatabaseConnections</code>,
         * <code>DiskQueueDepth</code>, <code>FreeStorageSpace</code>, <code>NetworkReceiveThroughput</code>, and
         * <code>NetworkTransmitThroughput</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about these metrics, see <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics"
         * >Metrics available in Lightsail</a>.
         * </p>
         * 
         * @param metricName
         *        The name of the metric to associate with the alarm.</p>
         *        <p>
         *        You can configure up to two alarms per metric.
         *        </p>
         *        <p>
         *        The following metrics are available for each resource type:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Instances</b>: <code>BurstCapacityPercentage</code>, <code>BurstCapacityTime</code>,
         *        <code>CPUUtilization</code>, <code>NetworkIn</code>, <code>NetworkOut</code>,
         *        <code>StatusCheckFailed</code>, <code>StatusCheckFailed_Instance</code>, and
         *        <code>StatusCheckFailed_System</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Load balancers</b>: <code>ClientTLSNegotiationErrorCount</code>, <code>HealthyHostCount</code>,
         *        <code>UnhealthyHostCount</code>, <code>HTTPCode_LB_4XX_Count</code>,
         *        <code>HTTPCode_LB_5XX_Count</code>, <code>HTTPCode_Instance_2XX_Count</code>,
         *        <code>HTTPCode_Instance_3XX_Count</code>, <code>HTTPCode_Instance_4XX_Count</code>,
         *        <code>HTTPCode_Instance_5XX_Count</code>, <code>InstanceResponseTime</code>,
         *        <code>RejectedConnectionCount</code>, and <code>RequestCount</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Relational databases</b>: <code>CPUUtilization</code>, <code>DatabaseConnections</code>,
         *        <code>DiskQueueDepth</code>, <code>FreeStorageSpace</code>, <code>NetworkReceiveThroughput</code>, and
         *        <code>NetworkTransmitThroughput</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about these metrics, see <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics"
         *        >Metrics available in Lightsail</a>.
         * @see MetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricName
         */
        Builder metricName(MetricName metricName);

        /**
         * <p>
         * The name of the Lightsail resource that will be monitored.
         * </p>
         * <p>
         * Instances, load balancers, and relational databases are the only Lightsail resources that can currently be
         * monitored by alarms.
         * </p>
         * 
         * @param monitoredResourceName
         *        The name of the Lightsail resource that will be monitored.</p>
         *        <p>
         *        Instances, load balancers, and relational databases are the only Lightsail resources that can
         *        currently be monitored by alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoredResourceName(String monitoredResourceName);

        /**
         * <p>
         * The arithmetic operation to use when comparing the specified statistic to the threshold. The specified
         * statistic value is used as the first operand.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation to use when comparing the specified statistic to the threshold. The specified
         *        statistic value is used as the first operand.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * The arithmetic operation to use when comparing the specified statistic to the threshold. The specified
         * statistic value is used as the first operand.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation to use when comparing the specified statistic to the threshold. The specified
         *        statistic value is used as the first operand.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * <p>
         * The value against which the specified statistic is compared.
         * </p>
         * 
         * @param threshold
         *        The value against which the specified statistic is compared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);

        /**
         * <p>
         * The number of most recent periods over which data is compared to the specified threshold. If you are setting
         * an "M out of N" alarm, this value (<code>evaluationPeriods</code>) is the N.
         * </p>
         * <p>
         * If you are setting an alarm that requires that a number of consecutive data points be breaching to trigger
         * the alarm, this value specifies the rolling period of time in which data points are evaluated.
         * </p>
         * <p>
         * Each evaluation period is five minutes long. For example, specify an evaluation period of 24 to evaluate a
         * metric over a rolling period of two hours.
         * </p>
         * <p>
         * You can specify a minimum valuation period of 1 (5 minutes), and a maximum evaluation period of 288 (24
         * hours).
         * </p>
         * 
         * @param evaluationPeriods
         *        The number of most recent periods over which data is compared to the specified threshold. If you are
         *        setting an "M out of N" alarm, this value (<code>evaluationPeriods</code>) is the N.</p>
         *        <p>
         *        If you are setting an alarm that requires that a number of consecutive data points be breaching to
         *        trigger the alarm, this value specifies the rolling period of time in which data points are evaluated.
         *        </p>
         *        <p>
         *        Each evaluation period is five minutes long. For example, specify an evaluation period of 24 to
         *        evaluate a metric over a rolling period of two hours.
         *        </p>
         *        <p>
         *        You can specify a minimum valuation period of 1 (5 minutes), and a maximum evaluation period of 288
         *        (24 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationPeriods(Integer evaluationPeriods);

        /**
         * <p>
         * The number of data points that must be not within the specified threshold to trigger the alarm. If you are
         * setting an "M out of N" alarm, this value (<code>datapointsToAlarm</code>) is the M.
         * </p>
         * 
         * @param datapointsToAlarm
         *        The number of data points that must be not within the specified threshold to trigger the alarm. If you
         *        are setting an "M out of N" alarm, this value (<code>datapointsToAlarm</code>) is the M.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapointsToAlarm(Integer datapointsToAlarm);

        /**
         * <p>
         * Sets how this alarm will handle missing data points.
         * </p>
         * <p>
         * An alarm can treat missing data in the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>breaching</code> - Assume the missing data is not within the threshold. Missing data counts towards the
         * number of times the metric is not within the threshold.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>notBreaching</code> - Assume the missing data is within the threshold. Missing data does not count
         * towards the number of times the metric is not within the threshold.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ignore</code> - Ignore the missing data. Maintains the current alarm state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>missing</code> - Missing data is treated as missing.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>treatMissingData</code> is not specified, the default behavior of <code>missing</code> is used.
         * </p>
         * 
         * @param treatMissingData
         *        Sets how this alarm will handle missing data points.</p>
         *        <p>
         *        An alarm can treat missing data in the following ways:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>breaching</code> - Assume the missing data is not within the threshold. Missing data counts
         *        towards the number of times the metric is not within the threshold.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>notBreaching</code> - Assume the missing data is within the threshold. Missing data does not
         *        count towards the number of times the metric is not within the threshold.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ignore</code> - Ignore the missing data. Maintains the current alarm state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>missing</code> - Missing data is treated as missing.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>treatMissingData</code> is not specified, the default behavior of <code>missing</code> is
         *        used.
         * @see TreatMissingData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TreatMissingData
         */
        Builder treatMissingData(String treatMissingData);

        /**
         * <p>
         * Sets how this alarm will handle missing data points.
         * </p>
         * <p>
         * An alarm can treat missing data in the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>breaching</code> - Assume the missing data is not within the threshold. Missing data counts towards the
         * number of times the metric is not within the threshold.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>notBreaching</code> - Assume the missing data is within the threshold. Missing data does not count
         * towards the number of times the metric is not within the threshold.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ignore</code> - Ignore the missing data. Maintains the current alarm state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>missing</code> - Missing data is treated as missing.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>treatMissingData</code> is not specified, the default behavior of <code>missing</code> is used.
         * </p>
         * 
         * @param treatMissingData
         *        Sets how this alarm will handle missing data points.</p>
         *        <p>
         *        An alarm can treat missing data in the following ways:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>breaching</code> - Assume the missing data is not within the threshold. Missing data counts
         *        towards the number of times the metric is not within the threshold.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>notBreaching</code> - Assume the missing data is within the threshold. Missing data does not
         *        count towards the number of times the metric is not within the threshold.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ignore</code> - Ignore the missing data. Maintains the current alarm state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>missing</code> - Missing data is treated as missing.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>treatMissingData</code> is not specified, the default behavior of <code>missing</code> is
         *        used.
         * @see TreatMissingData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TreatMissingData
         */
        Builder treatMissingData(TreatMissingData treatMissingData);

        /**
         * <p>
         * The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text messaging), or
         * both.
         * </p>
         * <p>
         * A notification is sent via the specified contact protocol if notifications are enabled for the alarm, and
         * when the alarm is triggered.
         * </p>
         * <p>
         * A notification is not sent if a contact protocol is not specified, if the specified contact protocol is not
         * configured in the AWS Region, or if notifications are not enabled for the alarm using the
         * <code>notificationEnabled</code> paramater.
         * </p>
         * <p>
         * Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
         * </p>
         * 
         * @param contactProtocols
         *        The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text
         *        messaging), or both.</p>
         *        <p>
         *        A notification is sent via the specified contact protocol if notifications are enabled for the alarm,
         *        and when the alarm is triggered.
         *        </p>
         *        <p>
         *        A notification is not sent if a contact protocol is not specified, if the specified contact protocol
         *        is not configured in the AWS Region, or if notifications are not enabled for the alarm using the
         *        <code>notificationEnabled</code> paramater.
         *        </p>
         *        <p>
         *        Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactProtocolsWithStrings(Collection<String> contactProtocols);

        /**
         * <p>
         * The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text messaging), or
         * both.
         * </p>
         * <p>
         * A notification is sent via the specified contact protocol if notifications are enabled for the alarm, and
         * when the alarm is triggered.
         * </p>
         * <p>
         * A notification is not sent if a contact protocol is not specified, if the specified contact protocol is not
         * configured in the AWS Region, or if notifications are not enabled for the alarm using the
         * <code>notificationEnabled</code> paramater.
         * </p>
         * <p>
         * Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
         * </p>
         * 
         * @param contactProtocols
         *        The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text
         *        messaging), or both.</p>
         *        <p>
         *        A notification is sent via the specified contact protocol if notifications are enabled for the alarm,
         *        and when the alarm is triggered.
         *        </p>
         *        <p>
         *        A notification is not sent if a contact protocol is not specified, if the specified contact protocol
         *        is not configured in the AWS Region, or if notifications are not enabled for the alarm using the
         *        <code>notificationEnabled</code> paramater.
         *        </p>
         *        <p>
         *        Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactProtocolsWithStrings(String... contactProtocols);

        /**
         * <p>
         * The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text messaging), or
         * both.
         * </p>
         * <p>
         * A notification is sent via the specified contact protocol if notifications are enabled for the alarm, and
         * when the alarm is triggered.
         * </p>
         * <p>
         * A notification is not sent if a contact protocol is not specified, if the specified contact protocol is not
         * configured in the AWS Region, or if notifications are not enabled for the alarm using the
         * <code>notificationEnabled</code> paramater.
         * </p>
         * <p>
         * Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
         * </p>
         * 
         * @param contactProtocols
         *        The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text
         *        messaging), or both.</p>
         *        <p>
         *        A notification is sent via the specified contact protocol if notifications are enabled for the alarm,
         *        and when the alarm is triggered.
         *        </p>
         *        <p>
         *        A notification is not sent if a contact protocol is not specified, if the specified contact protocol
         *        is not configured in the AWS Region, or if notifications are not enabled for the alarm using the
         *        <code>notificationEnabled</code> paramater.
         *        </p>
         *        <p>
         *        Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactProtocols(Collection<ContactProtocol> contactProtocols);

        /**
         * <p>
         * The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text messaging), or
         * both.
         * </p>
         * <p>
         * A notification is sent via the specified contact protocol if notifications are enabled for the alarm, and
         * when the alarm is triggered.
         * </p>
         * <p>
         * A notification is not sent if a contact protocol is not specified, if the specified contact protocol is not
         * configured in the AWS Region, or if notifications are not enabled for the alarm using the
         * <code>notificationEnabled</code> paramater.
         * </p>
         * <p>
         * Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
         * </p>
         * 
         * @param contactProtocols
         *        The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code> (text
         *        messaging), or both.</p>
         *        <p>
         *        A notification is sent via the specified contact protocol if notifications are enabled for the alarm,
         *        and when the alarm is triggered.
         *        </p>
         *        <p>
         *        A notification is not sent if a contact protocol is not specified, if the specified contact protocol
         *        is not configured in the AWS Region, or if notifications are not enabled for the alarm using the
         *        <code>notificationEnabled</code> paramater.
         *        </p>
         *        <p>
         *        Use the <code>CreateContactMethod</code> action to configure a contact protocol in an AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactProtocols(ContactProtocol... contactProtocols);

        /**
         * <p>
         * The alarm states that trigger a notification.
         * </p>
         * <p>
         * An alarm has the following possible states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALARM</code> - The metric is outside of the defined threshold.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough data
         * is available for the metric to determine the alarm state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OK</code> - The metric is within the defined threshold.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
         * <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the
         * <code>ALARM</code> state.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches from an
         * <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state. This can be
         * thought of as an <i>all clear</i> alarm notification.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the alarm
         * switches from an <code>OK</code> or <code>ALARM</code> alarm state to an <code>INSUFFICIENT_DATA</code>
         * state.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
         * </p>
         * 
         * @param notificationTriggers
         *        The alarm states that trigger a notification.</p>
         *        <p>
         *        An alarm has the following possible states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALARM</code> - The metric is outside of the defined threshold.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not
         *        enough data is available for the metric to determine the alarm state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OK</code> - The metric is within the defined threshold.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
         *        <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the
         *        <code>ALARM</code> state.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches
         *        from an <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state.
         *        This can be thought of as an <i>all clear</i> alarm notification.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the
         *        alarm switches from an <code>OK</code> or <code>ALARM</code> alarm state to an
         *        <code>INSUFFICIENT_DATA</code> state.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTriggersWithStrings(Collection<String> notificationTriggers);

        /**
         * <p>
         * The alarm states that trigger a notification.
         * </p>
         * <p>
         * An alarm has the following possible states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALARM</code> - The metric is outside of the defined threshold.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough data
         * is available for the metric to determine the alarm state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OK</code> - The metric is within the defined threshold.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
         * <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the
         * <code>ALARM</code> state.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches from an
         * <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state. This can be
         * thought of as an <i>all clear</i> alarm notification.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the alarm
         * switches from an <code>OK</code> or <code>ALARM</code> alarm state to an <code>INSUFFICIENT_DATA</code>
         * state.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
         * </p>
         * 
         * @param notificationTriggers
         *        The alarm states that trigger a notification.</p>
         *        <p>
         *        An alarm has the following possible states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALARM</code> - The metric is outside of the defined threshold.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not
         *        enough data is available for the metric to determine the alarm state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OK</code> - The metric is within the defined threshold.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
         *        <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the
         *        <code>ALARM</code> state.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches
         *        from an <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state.
         *        This can be thought of as an <i>all clear</i> alarm notification.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the
         *        alarm switches from an <code>OK</code> or <code>ALARM</code> alarm state to an
         *        <code>INSUFFICIENT_DATA</code> state.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTriggersWithStrings(String... notificationTriggers);

        /**
         * <p>
         * The alarm states that trigger a notification.
         * </p>
         * <p>
         * An alarm has the following possible states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALARM</code> - The metric is outside of the defined threshold.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough data
         * is available for the metric to determine the alarm state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OK</code> - The metric is within the defined threshold.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
         * <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the
         * <code>ALARM</code> state.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches from an
         * <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state. This can be
         * thought of as an <i>all clear</i> alarm notification.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the alarm
         * switches from an <code>OK</code> or <code>ALARM</code> alarm state to an <code>INSUFFICIENT_DATA</code>
         * state.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
         * </p>
         * 
         * @param notificationTriggers
         *        The alarm states that trigger a notification.</p>
         *        <p>
         *        An alarm has the following possible states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALARM</code> - The metric is outside of the defined threshold.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not
         *        enough data is available for the metric to determine the alarm state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OK</code> - The metric is within the defined threshold.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
         *        <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the
         *        <code>ALARM</code> state.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches
         *        from an <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state.
         *        This can be thought of as an <i>all clear</i> alarm notification.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the
         *        alarm switches from an <code>OK</code> or <code>ALARM</code> alarm state to an
         *        <code>INSUFFICIENT_DATA</code> state.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTriggers(Collection<AlarmState> notificationTriggers);

        /**
         * <p>
         * The alarm states that trigger a notification.
         * </p>
         * <p>
         * An alarm has the following possible states:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALARM</code> - The metric is outside of the defined threshold.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not enough data
         * is available for the metric to determine the alarm state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OK</code> - The metric is within the defined threshold.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
         * <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the
         * <code>ALARM</code> state.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches from an
         * <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state. This can be
         * thought of as an <i>all clear</i> alarm notification.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the alarm
         * switches from an <code>OK</code> or <code>ALARM</code> alarm state to an <code>INSUFFICIENT_DATA</code>
         * state.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
         * </p>
         * 
         * @param notificationTriggers
         *        The alarm states that trigger a notification.</p>
         *        <p>
         *        An alarm has the following possible states:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALARM</code> - The metric is outside of the defined threshold.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not available, or not
         *        enough data is available for the metric to determine the alarm state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OK</code> - The metric is within the defined threshold.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When you specify a notification trigger, the <code>ALARM</code> state must be specified. The
         *        <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to the
         *        <code>ALARM</code> state.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify <code>OK</code> as an alarm trigger, a notification is sent when the alarm switches
         *        from an <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to an <code>OK</code> state.
         *        This can be thought of as an <i>all clear</i> alarm notification.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is sent when the
         *        alarm switches from an <code>OK</code> or <code>ALARM</code> alarm state to an
         *        <code>INSUFFICIENT_DATA</code> state.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The notification trigger defaults to <code>ALARM</code> if you don't specify this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationTriggers(AlarmState... notificationTriggers);

        /**
         * <p>
         * Indicates whether the alarm is enabled.
         * </p>
         * <p>
         * Notifications are enabled by default if you don't specify this parameter.
         * </p>
         * 
         * @param notificationEnabled
         *        Indicates whether the alarm is enabled.</p>
         *        <p>
         *        Notifications are enabled by default if you don't specify this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEnabled(Boolean notificationEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String alarmName;

        private String metricName;

        private String monitoredResourceName;

        private String comparisonOperator;

        private Double threshold;

        private Integer evaluationPeriods;

        private Integer datapointsToAlarm;

        private String treatMissingData;

        private List<String> contactProtocols = DefaultSdkAutoConstructList.getInstance();

        private List<String> notificationTriggers = DefaultSdkAutoConstructList.getInstance();

        private Boolean notificationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAlarmRequest model) {
            super(model);
            alarmName(model.alarmName);
            metricName(model.metricName);
            monitoredResourceName(model.monitoredResourceName);
            comparisonOperator(model.comparisonOperator);
            threshold(model.threshold);
            evaluationPeriods(model.evaluationPeriods);
            datapointsToAlarm(model.datapointsToAlarm);
            treatMissingData(model.treatMissingData);
            contactProtocolsWithStrings(model.contactProtocols);
            notificationTriggersWithStrings(model.notificationTriggers);
            notificationEnabled(model.notificationEnabled);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(MetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMonitoredResourceName() {
            return monitoredResourceName;
        }

        @Override
        public final Builder monitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
            return this;
        }

        public final void setMonitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Double getThreshold() {
            return threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final Integer getEvaluationPeriods() {
            return evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final Integer getDatapointsToAlarm() {
            return datapointsToAlarm;
        }

        @Override
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        public final String getTreatMissingData() {
            return treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        @Override
        public final Builder treatMissingData(TreatMissingData treatMissingData) {
            this.treatMissingData(treatMissingData == null ? null : treatMissingData.toString());
            return this;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        public final Collection<String> getContactProtocols() {
            return contactProtocols;
        }

        @Override
        public final Builder contactProtocolsWithStrings(Collection<String> contactProtocols) {
            this.contactProtocols = ContactProtocolsListCopier.copy(contactProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactProtocolsWithStrings(String... contactProtocols) {
            contactProtocolsWithStrings(Arrays.asList(contactProtocols));
            return this;
        }

        @Override
        public final Builder contactProtocols(Collection<ContactProtocol> contactProtocols) {
            this.contactProtocols = ContactProtocolsListCopier.copyEnumToString(contactProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactProtocols(ContactProtocol... contactProtocols) {
            contactProtocols(Arrays.asList(contactProtocols));
            return this;
        }

        public final void setContactProtocols(Collection<String> contactProtocols) {
            this.contactProtocols = ContactProtocolsListCopier.copy(contactProtocols);
        }

        public final Collection<String> getNotificationTriggers() {
            return notificationTriggers;
        }

        @Override
        public final Builder notificationTriggersWithStrings(Collection<String> notificationTriggers) {
            this.notificationTriggers = NotificationTriggerListCopier.copy(notificationTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTriggersWithStrings(String... notificationTriggers) {
            notificationTriggersWithStrings(Arrays.asList(notificationTriggers));
            return this;
        }

        @Override
        public final Builder notificationTriggers(Collection<AlarmState> notificationTriggers) {
            this.notificationTriggers = NotificationTriggerListCopier.copyEnumToString(notificationTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTriggers(AlarmState... notificationTriggers) {
            notificationTriggers(Arrays.asList(notificationTriggers));
            return this;
        }

        public final void setNotificationTriggers(Collection<String> notificationTriggers) {
            this.notificationTriggers = NotificationTriggerListCopier.copy(notificationTriggers);
        }

        public final Boolean getNotificationEnabled() {
            return notificationEnabled;
        }

        @Override
        public final Builder notificationEnabled(Boolean notificationEnabled) {
            this.notificationEnabled = notificationEnabled;
            return this;
        }

        public final void setNotificationEnabled(Boolean notificationEnabled) {
            this.notificationEnabled = notificationEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAlarmRequest build() {
            return new PutAlarmRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
