/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAlarmsRequest extends LightsailRequest implements
        ToCopyableBuilder<GetAlarmsRequest.Builder, GetAlarmsRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAlarmsRequest::alarmName)).setter(setter(Builder::alarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmName").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAlarmsRequest::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()).build();

    private static final SdkField<String> MONITORED_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAlarmsRequest::monitoredResourceName)).setter(setter(Builder::monitoredResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoredResourceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD,
            PAGE_TOKEN_FIELD, MONITORED_RESOURCE_NAME_FIELD));

    private final String alarmName;

    private final String pageToken;

    private final String monitoredResourceName;

    private GetAlarmsRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.pageToken = builder.pageToken;
        this.monitoredResourceName = builder.monitoredResourceName;
    }

    /**
     * <p>
     * The name of the alarm.
     * </p>
     * <p>
     * Specify an alarm name to return information about a specific alarm.
     * </p>
     * 
     * @return The name of the alarm.</p>
     *         <p>
     *         Specify an alarm name to return information about a specific alarm.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * To get a page token, perform an initial <code>GetAlarms</code> request. If your results are paginated, the
     * response will return a next page token that you can specify as the page token in a subsequent request.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         To get a page token, perform an initial <code>GetAlarms</code> request. If your results are paginated,
     *         the response will return a next page token that you can specify as the page token in a subsequent
     *         request.
     */
    public String pageToken() {
        return pageToken;
    }

    /**
     * <p>
     * The name of the Lightsail resource being monitored by the alarm.
     * </p>
     * <p>
     * Specify a monitored resource name to return information about all alarms for a specific resource.
     * </p>
     * 
     * @return The name of the Lightsail resource being monitored by the alarm.</p>
     *         <p>
     *         Specify a monitored resource name to return information about all alarms for a specific resource.
     */
    public String monitoredResourceName() {
        return monitoredResourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(monitoredResourceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAlarmsRequest)) {
            return false;
        }
        GetAlarmsRequest other = (GetAlarmsRequest) obj;
        return Objects.equals(alarmName(), other.alarmName()) && Objects.equals(pageToken(), other.pageToken())
                && Objects.equals(monitoredResourceName(), other.monitoredResourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAlarmsRequest").add("AlarmName", alarmName()).add("PageToken", pageToken())
                .add("MonitoredResourceName", monitoredResourceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmName":
            return Optional.ofNullable(clazz.cast(alarmName()));
        case "pageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        case "monitoredResourceName":
            return Optional.ofNullable(clazz.cast(monitoredResourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAlarmsRequest, T> g) {
        return obj -> g.apply((GetAlarmsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAlarmsRequest> {
        /**
         * <p>
         * The name of the alarm.
         * </p>
         * <p>
         * Specify an alarm name to return information about a specific alarm.
         * </p>
         * 
         * @param alarmName
         *        The name of the alarm.</p>
         *        <p>
         *        Specify an alarm name to return information about a specific alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * To get a page token, perform an initial <code>GetAlarms</code> request. If your results are paginated, the
         * response will return a next page token that you can specify as the page token in a subsequent request.
         * </p>
         * 
         * @param pageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        To get a page token, perform an initial <code>GetAlarms</code> request. If your results are paginated,
         *        the response will return a next page token that you can specify as the page token in a subsequent
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        /**
         * <p>
         * The name of the Lightsail resource being monitored by the alarm.
         * </p>
         * <p>
         * Specify a monitored resource name to return information about all alarms for a specific resource.
         * </p>
         * 
         * @param monitoredResourceName
         *        The name of the Lightsail resource being monitored by the alarm.</p>
         *        <p>
         *        Specify a monitored resource name to return information about all alarms for a specific resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoredResourceName(String monitoredResourceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String alarmName;

        private String pageToken;

        private String monitoredResourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAlarmsRequest model) {
            super(model);
            alarmName(model.alarmName);
            pageToken(model.pageToken);
            monitoredResourceName(model.monitoredResourceName);
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public final String getMonitoredResourceName() {
            return monitoredResourceName;
        }

        @Override
        public final Builder monitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
            return this;
        }

        public final void setMonitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAlarmsRequest build() {
            return new GetAlarmsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
