/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TreatMissingData {
    BREACHING("breaching"),
    NOT_BREACHING("notBreaching"),
    IGNORE("ignore"),
    MISSING("missing"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TreatMissingData(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TreatMissingData fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TreatMissingData.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TreatMissingData> knownValues() {
        return Stream.of(TreatMissingData.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

