/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.DiskSnapshot;
import software.amazon.awssdk.services.lightsail.model.DiskSnapshotListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDiskSnapshotsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetDiskSnapshotsResponse> {
    private static final SdkField<List<DiskSnapshot>> DISK_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetDiskSnapshotsResponse.getter(GetDiskSnapshotsResponse::diskSnapshots)).setter(GetDiskSnapshotsResponse.setter(Builder::diskSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSnapshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DiskSnapshot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDiskSnapshotsResponse.getter(GetDiskSnapshotsResponse::nextPageToken)).setter(GetDiskSnapshotsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_SNAPSHOTS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<DiskSnapshot> diskSnapshots;
    private final String nextPageToken;

    private GetDiskSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.diskSnapshots = builder.diskSnapshots;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasDiskSnapshots() {
        return this.diskSnapshots != null && !(this.diskSnapshots instanceof SdkAutoConstructList);
    }

    public List<DiskSnapshot> diskSnapshots() {
        return this.diskSnapshots;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSnapshots());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiskSnapshotsResponse)) {
            return false;
        }
        GetDiskSnapshotsResponse other = (GetDiskSnapshotsResponse)((Object)obj);
        return Objects.equals(this.diskSnapshots(), other.diskSnapshots()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetDiskSnapshotsResponse").add("DiskSnapshots", this.diskSnapshots()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "diskSnapshots": {
                return Optional.ofNullable(clazz.cast(this.diskSnapshots()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDiskSnapshotsResponse, T> g) {
        return obj -> g.apply((GetDiskSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<DiskSnapshot> diskSnapshots = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiskSnapshotsResponse model) {
            super(model);
            this.diskSnapshots(model.diskSnapshots);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<DiskSnapshot.Builder> getDiskSnapshots() {
            return this.diskSnapshots != null ? (Collection)this.diskSnapshots.stream().map(DiskSnapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder diskSnapshots(Collection<DiskSnapshot> diskSnapshots) {
            this.diskSnapshots = DiskSnapshotListCopier.copy(diskSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskSnapshots(DiskSnapshot ... diskSnapshots) {
            this.diskSnapshots(Arrays.asList(diskSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskSnapshots(Consumer<DiskSnapshot.Builder> ... diskSnapshots) {
            this.diskSnapshots(Stream.of(diskSnapshots).map(c -> (DiskSnapshot)((DiskSnapshot.Builder)DiskSnapshot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDiskSnapshots(Collection<DiskSnapshot.BuilderImpl> diskSnapshots) {
            this.diskSnapshots = DiskSnapshotListCopier.copyFromBuilder(diskSnapshots);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetDiskSnapshotsResponse build() {
            return new GetDiskSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDiskSnapshotsResponse> {
        public Builder diskSnapshots(Collection<DiskSnapshot> var1);

        public Builder diskSnapshots(DiskSnapshot ... var1);

        public Builder diskSnapshots(Consumer<DiskSnapshot.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

