/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OpenInstancePublicPortsRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> PORTINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("portInfo").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceName").isBinary(false).build();
    private static final OpenInstancePublicPortsRequestModelMarshaller INSTANCE = new OpenInstancePublicPortsRequestModelMarshaller();

    private OpenInstancePublicPortsRequestModelMarshaller() {
    }

    public static OpenInstancePublicPortsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OpenInstancePublicPortsRequest openInstancePublicPortsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)openInstancePublicPortsRequest), (String)"openInstancePublicPortsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)openInstancePublicPortsRequest.portInfo(), PORTINFO_BINDING);
            protocolMarshaller.marshall((Object)openInstancePublicPortsRequest.instanceName(), INSTANCENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

