/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.Instance;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();
    private static final MarshallingInfo<String> BLUEPRINTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blueprintId").isBinary(false).build();
    private static final MarshallingInfo<String> BLUEPRINTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blueprintName").isBinary(false).build();
    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bundleId").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISSTATICIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isStaticIp").isBinary(false).build();
    private static final MarshallingInfo<String> PRIVATEIPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privateIpAddress").isBinary(false).build();
    private static final MarshallingInfo<String> PUBLICIPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publicIpAddress").isBinary(false).build();
    private static final MarshallingInfo<String> IPV6ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipv6Address").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HARDWARE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hardware").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NETWORKING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networking").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("username").isBinary(false).build();
    private static final MarshallingInfo<String> SSHKEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sshKeyName").isBinary(false).build();
    private static final InstanceMarshaller INSTANCE = new InstanceMarshaller();

    private InstanceMarshaller() {
    }

    public static InstanceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Instance instance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instance, (String)"instance");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instance.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)instance.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)instance.supportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall((Object)instance.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)instance.location(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)instance.resourceTypeString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instance.blueprintId(), BLUEPRINTID_BINDING);
            protocolMarshaller.marshall((Object)instance.blueprintName(), BLUEPRINTNAME_BINDING);
            protocolMarshaller.marshall((Object)instance.bundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall((Object)instance.isStaticIp(), ISSTATICIP_BINDING);
            protocolMarshaller.marshall((Object)instance.privateIpAddress(), PRIVATEIPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)instance.publicIpAddress(), PUBLICIPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)instance.ipv6Address(), IPV6ADDRESS_BINDING);
            protocolMarshaller.marshall((Object)instance.hardware(), HARDWARE_BINDING);
            protocolMarshaller.marshall((Object)instance.networking(), NETWORKING_BINDING);
            protocolMarshaller.marshall((Object)instance.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)instance.username(), USERNAME_BINDING);
            protocolMarshaller.marshall((Object)instance.sshKeyName(), SSHKEYNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

