/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateKeyPairRequestModelMarshaller {
    private static final MarshallingInfo<String> KEYPAIRNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyPairName").isBinary(false).build();
    private static final CreateKeyPairRequestModelMarshaller INSTANCE = new CreateKeyPairRequestModelMarshaller();

    private CreateKeyPairRequestModelMarshaller() {
    }

    public static CreateKeyPairRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateKeyPairRequest createKeyPairRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createKeyPairRequest), (String)"createKeyPairRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createKeyPairRequest.keyPairName(), KEYPAIRNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

