/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.OperationStatus;
import software.amazon.awssdk.services.lightsail.model.OperationType;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.transform.OperationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Operation
implements StructuredPojo,
ToCopyableBuilder<Builder, Operation> {
    private final String id;
    private final String resourceName;
    private final String resourceType;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final Boolean isTerminal;
    private final String operationDetails;
    private final String operationType;
    private final String status;
    private final Instant statusChangedAt;
    private final String errorCode;
    private final String errorDetails;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.isTerminal = builder.isTerminal;
        this.operationDetails = builder.operationDetails;
        this.operationType = builder.operationType;
        this.status = builder.status;
        this.statusChangedAt = builder.statusChangedAt;
        this.errorCode = builder.errorCode;
        this.errorDetails = builder.errorDetails;
    }

    public String id() {
        return this.id;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeString() {
        return this.resourceType;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public Boolean isTerminal() {
        return this.isTerminal;
    }

    public String operationDetails() {
        return this.operationDetails;
    }

    public OperationType operationType() {
        return OperationType.fromValue(this.operationType);
    }

    public String operationTypeString() {
        return this.operationType;
    }

    public OperationStatus status() {
        return OperationStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Instant statusChangedAt() {
        return this.statusChangedAt;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusChangedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceTypeString(), other.resourceTypeString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.isTerminal(), other.isTerminal()) && Objects.equals(this.operationDetails(), other.operationDetails()) && Objects.equals(this.operationTypeString(), other.operationTypeString()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.statusChangedAt(), other.statusChangedAt()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorDetails(), other.errorDetails());
    }

    public String toString() {
        return ToString.builder((String)"Operation").add("Id", (Object)this.id()).add("ResourceName", (Object)this.resourceName()).add("ResourceType", (Object)this.resourceTypeString()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("IsTerminal", (Object)this.isTerminal()).add("OperationDetails", (Object)this.operationDetails()).add("OperationType", (Object)this.operationTypeString()).add("Status", (Object)this.statusString()).add("StatusChangedAt", (Object)this.statusChangedAt()).add("ErrorCode", (Object)this.errorCode()).add("ErrorDetails", (Object)this.errorDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "resourceName": {
                return Optional.of(clazz.cast(this.resourceName()));
            }
            case "resourceType": {
                return Optional.of(clazz.cast(this.resourceTypeString()));
            }
            case "createdAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "isTerminal": {
                return Optional.of(clazz.cast(this.isTerminal()));
            }
            case "operationDetails": {
                return Optional.of(clazz.cast(this.operationDetails()));
            }
            case "operationType": {
                return Optional.of(clazz.cast(this.operationTypeString()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "statusChangedAt": {
                return Optional.of(clazz.cast(this.statusChangedAt()));
            }
            case "errorCode": {
                return Optional.of(clazz.cast(this.errorCode()));
            }
            case "errorDetails": {
                return Optional.of(clazz.cast(this.errorDetails()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String resourceName;
        private String resourceType;
        private Instant createdAt;
        private ResourceLocation location;
        private Boolean isTerminal;
        private String operationDetails;
        private String operationType;
        private String status;
        private Instant statusChangedAt;
        private String errorCode;
        private String errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            this.id(model.id);
            this.resourceName(model.resourceName);
            this.resourceType(model.resourceType);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.isTerminal(model.isTerminal);
            this.operationDetails(model.operationDetails);
            this.operationType(model.operationType);
            this.status(model.status);
            this.statusChangedAt(model.statusChangedAt);
            this.errorCode(model.errorCode);
            this.errorDetails(model.errorDetails);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Boolean getIsTerminal() {
            return this.isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        public final String getOperationDetails() {
            return this.operationDetails;
        }

        @Override
        public final Builder operationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
            return this;
        }

        public final void setOperationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStatusChangedAt() {
            return this.statusChangedAt;
        }

        @Override
        public final Builder statusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
            return this;
        }

        public final void setStatusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorDetails() {
            return this.errorDetails;
        }

        @Override
        public final Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final void setErrorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
        }

        public Operation build() {
            return new Operation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Operation> {
        public Builder id(String var1);

        public Builder resourceName(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().apply(location)).build());
        }

        public Builder isTerminal(Boolean var1);

        public Builder operationDetails(String var1);

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder status(String var1);

        public Builder status(OperationStatus var1);

        public Builder statusChangedAt(Instant var1);

        public Builder errorCode(String var1);

        public Builder errorDetails(String var1);
    }
}

