/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.InstanceAccessProtocol;
import software.amazon.awssdk.services.lightsail.model.PasswordData;
import software.amazon.awssdk.services.lightsail.transform.InstanceAccessDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceAccessDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceAccessDetails> {
    private final String certKey;
    private final Instant expiresAt;
    private final String ipAddress;
    private final String password;
    private final PasswordData passwordData;
    private final String privateKey;
    private final String protocol;
    private final String instanceName;
    private final String username;

    private InstanceAccessDetails(BuilderImpl builder) {
        this.certKey = builder.certKey;
        this.expiresAt = builder.expiresAt;
        this.ipAddress = builder.ipAddress;
        this.password = builder.password;
        this.passwordData = builder.passwordData;
        this.privateKey = builder.privateKey;
        this.protocol = builder.protocol;
        this.instanceName = builder.instanceName;
        this.username = builder.username;
    }

    public String certKey() {
        return this.certKey;
    }

    public Instant expiresAt() {
        return this.expiresAt;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String password() {
        return this.password;
    }

    public PasswordData passwordData() {
        return this.passwordData;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public InstanceAccessProtocol protocol() {
        return InstanceAccessProtocol.fromValue(this.protocol);
    }

    public String protocolString() {
        return this.protocol;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordData());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAccessDetails)) {
            return false;
        }
        InstanceAccessDetails other = (InstanceAccessDetails)obj;
        return Objects.equals(this.certKey(), other.certKey()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.passwordData(), other.passwordData()) && Objects.equals(this.privateKey(), other.privateKey()) && Objects.equals(this.protocolString(), other.protocolString()) && Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"InstanceAccessDetails").add("CertKey", (Object)this.certKey()).add("ExpiresAt", (Object)this.expiresAt()).add("IpAddress", (Object)this.ipAddress()).add("Password", (Object)this.password()).add("PasswordData", (Object)this.passwordData()).add("PrivateKey", (Object)this.privateKey()).add("Protocol", (Object)this.protocolString()).add("InstanceName", (Object)this.instanceName()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certKey": {
                return Optional.of(clazz.cast(this.certKey()));
            }
            case "expiresAt": {
                return Optional.of(clazz.cast(this.expiresAt()));
            }
            case "ipAddress": {
                return Optional.of(clazz.cast(this.ipAddress()));
            }
            case "password": {
                return Optional.of(clazz.cast(this.password()));
            }
            case "passwordData": {
                return Optional.of(clazz.cast(this.passwordData()));
            }
            case "privateKey": {
                return Optional.of(clazz.cast(this.privateKey()));
            }
            case "protocol": {
                return Optional.of(clazz.cast(this.protocolString()));
            }
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
            case "username": {
                return Optional.of(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceAccessDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String certKey;
        private Instant expiresAt;
        private String ipAddress;
        private String password;
        private PasswordData passwordData;
        private String privateKey;
        private String protocol;
        private String instanceName;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAccessDetails model) {
            this.certKey(model.certKey);
            this.expiresAt(model.expiresAt);
            this.ipAddress(model.ipAddress);
            this.password(model.password);
            this.passwordData(model.passwordData);
            this.privateKey(model.privateKey);
            this.protocol(model.protocol);
            this.instanceName(model.instanceName);
            this.username(model.username);
        }

        public final String getCertKey() {
            return this.certKey;
        }

        @Override
        public final Builder certKey(String certKey) {
            this.certKey = certKey;
            return this;
        }

        public final void setCertKey(String certKey) {
            this.certKey = certKey;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final PasswordData.Builder getPasswordData() {
            return this.passwordData != null ? this.passwordData.toBuilder() : null;
        }

        @Override
        public final Builder passwordData(PasswordData passwordData) {
            this.passwordData = passwordData;
            return this;
        }

        public final void setPasswordData(PasswordData.BuilderImpl passwordData) {
            this.passwordData = passwordData != null ? passwordData.build() : null;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(InstanceAccessProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public InstanceAccessDetails build() {
            return new InstanceAccessDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceAccessDetails> {
        public Builder certKey(String var1);

        public Builder expiresAt(Instant var1);

        public Builder ipAddress(String var1);

        public Builder password(String var1);

        public Builder passwordData(PasswordData var1);

        default public Builder passwordData(Consumer<PasswordData.Builder> passwordData) {
            return this.passwordData((PasswordData)((PasswordData.Builder)PasswordData.builder().apply(passwordData)).build());
        }

        public Builder privateKey(String var1);

        public Builder protocol(String var1);

        public Builder protocol(InstanceAccessProtocol var1);

        public Builder instanceName(String var1);

        public Builder username(String var1);
    }
}

