/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportKeyPairRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, ImportKeyPairRequest> {
    private final String keyPairName;
    private final String publicKeyBase64;

    private ImportKeyPairRequest(BuilderImpl builder) {
        super(builder);
        this.keyPairName = builder.keyPairName;
        this.publicKeyBase64 = builder.publicKeyBase64;
    }

    public String keyPairName() {
        return this.keyPairName;
    }

    public String publicKeyBase64() {
        return this.publicKeyBase64;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyBase64());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairRequest)) {
            return false;
        }
        ImportKeyPairRequest other = (ImportKeyPairRequest)((Object)obj);
        return Objects.equals(this.keyPairName(), other.keyPairName()) && Objects.equals(this.publicKeyBase64(), other.publicKeyBase64());
    }

    public String toString() {
        return ToString.builder((String)"ImportKeyPairRequest").add("KeyPairName", (Object)this.keyPairName()).add("PublicKeyBase64", (Object)this.publicKeyBase64()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyPairName": {
                return Optional.of(clazz.cast(this.keyPairName()));
            }
            case "publicKeyBase64": {
                return Optional.of(clazz.cast(this.publicKeyBase64()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String keyPairName;
        private String publicKeyBase64;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairRequest model) {
            this.keyPairName(model.keyPairName);
            this.publicKeyBase64(model.publicKeyBase64);
        }

        public final String getKeyPairName() {
            return this.keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        public final String getPublicKeyBase64() {
            return this.publicKeyBase64;
        }

        @Override
        public final Builder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public final void setPublicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ImportKeyPairRequest build() {
            return new ImportKeyPairRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, ImportKeyPairRequest> {
        public Builder keyPairName(String var1);

        public Builder publicKeyBase64(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

