/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshot;
import software.amazon.awssdk.services.lightsail.model.InstanceSnapshotListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstanceSnapshotsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetInstanceSnapshotsResponse> {
    private final List<InstanceSnapshot> instanceSnapshots;
    private final String nextPageToken;

    private GetInstanceSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceSnapshots = builder.instanceSnapshots;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<InstanceSnapshot> instanceSnapshots() {
        return this.instanceSnapshots;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSnapshots());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceSnapshotsResponse)) {
            return false;
        }
        GetInstanceSnapshotsResponse other = (GetInstanceSnapshotsResponse)((Object)obj);
        return Objects.equals(this.instanceSnapshots(), other.instanceSnapshots()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetInstanceSnapshotsResponse").add("InstanceSnapshots", this.instanceSnapshots()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceSnapshots": {
                return Optional.of(clazz.cast(this.instanceSnapshots()));
            }
            case "nextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<InstanceSnapshot> instanceSnapshots;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceSnapshotsResponse model) {
            this.instanceSnapshots(model.instanceSnapshots);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<InstanceSnapshot.Builder> getInstanceSnapshots() {
            return this.instanceSnapshots != null ? (Collection)this.instanceSnapshots.stream().map(InstanceSnapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceSnapshots(Collection<InstanceSnapshot> instanceSnapshots) {
            this.instanceSnapshots = InstanceSnapshotListCopier.copy(instanceSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceSnapshots(InstanceSnapshot ... instanceSnapshots) {
            this.instanceSnapshots(Arrays.asList(instanceSnapshots));
            return this;
        }

        public final void setInstanceSnapshots(Collection<InstanceSnapshot.BuilderImpl> instanceSnapshots) {
            this.instanceSnapshots = InstanceSnapshotListCopier.copyFromBuilder(instanceSnapshots);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetInstanceSnapshotsResponse build() {
            return new GetInstanceSnapshotsResponse(this);
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    CopyableBuilder<Builder, GetInstanceSnapshotsResponse> {
        public Builder instanceSnapshots(Collection<InstanceSnapshot> var1);

        public Builder instanceSnapshots(InstanceSnapshot ... var1);

        public Builder nextPageToken(String var1);
    }
}

