/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.lightsail.model.InstanceMetricName;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.MetricDatapoint;
import software.amazon.awssdk.services.lightsail.model.MetricDatapointListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstanceMetricDataResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetInstanceMetricDataResponse> {
    private final String metricName;
    private final List<MetricDatapoint> metricData;

    private GetInstanceMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.metricData = builder.metricData;
    }

    public InstanceMetricName metricName() {
        return InstanceMetricName.fromValue(this.metricName);
    }

    public String metricNameString() {
        return this.metricName;
    }

    public List<MetricDatapoint> metricData() {
        return this.metricData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceMetricDataResponse)) {
            return false;
        }
        GetInstanceMetricDataResponse other = (GetInstanceMetricDataResponse)((Object)obj);
        return Objects.equals(this.metricNameString(), other.metricNameString()) && Objects.equals(this.metricData(), other.metricData());
    }

    public String toString() {
        return ToString.builder((String)"GetInstanceMetricDataResponse").add("MetricName", (Object)this.metricNameString()).add("MetricData", this.metricData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.of(clazz.cast(this.metricNameString()));
            }
            case "metricData": {
                return Optional.of(clazz.cast(this.metricData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private String metricName;
        private List<MetricDatapoint> metricData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceMetricDataResponse model) {
            this.metricName(model.metricName);
            this.metricData(model.metricData);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(InstanceMetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<MetricDatapoint.Builder> getMetricData() {
            return this.metricData != null ? (Collection)this.metricData.stream().map(MetricDatapoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricData(Collection<MetricDatapoint> metricData) {
            this.metricData = MetricDatapointListCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatapoint ... metricData) {
            this.metricData(Arrays.asList(metricData));
            return this;
        }

        public final void setMetricData(Collection<MetricDatapoint.BuilderImpl> metricData) {
            this.metricData = MetricDatapointListCopier.copyFromBuilder(metricData);
        }

        @Override
        public GetInstanceMetricDataResponse build() {
            return new GetInstanceMetricDataResponse(this);
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    CopyableBuilder<Builder, GetInstanceMetricDataResponse> {
        public Builder metricName(String var1);

        public Builder metricName(InstanceMetricName var1);

        public Builder metricData(Collection<MetricDatapoint> var1);

        public Builder metricData(MetricDatapoint ... var1);
    }
}

