/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttachDiskRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, AttachDiskRequest> {
    private final String diskName;
    private final String instanceName;
    private final String diskPath;

    private AttachDiskRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.instanceName = builder.instanceName;
        this.diskPath = builder.diskPath;
    }

    public String diskName() {
        return this.diskName;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String diskPath() {
        return this.diskPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.diskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachDiskRequest)) {
            return false;
        }
        AttachDiskRequest other = (AttachDiskRequest)((Object)obj);
        return Objects.equals(this.diskName(), other.diskName()) && Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.diskPath(), other.diskPath());
    }

    public String toString() {
        return ToString.builder((String)"AttachDiskRequest").add("DiskName", (Object)this.diskName()).add("InstanceName", (Object)this.instanceName()).add("DiskPath", (Object)this.diskPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "diskName": {
                return Optional.of(clazz.cast(this.diskName()));
            }
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
            case "diskPath": {
                return Optional.of(clazz.cast(this.diskPath()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String diskName;
        private String instanceName;
        private String diskPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachDiskRequest model) {
            this.diskName(model.diskName);
            this.instanceName(model.instanceName);
            this.diskPath(model.diskPath);
        }

        public final String getDiskName() {
            return this.diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getDiskPath() {
            return this.diskPath;
        }

        @Override
        public final Builder diskPath(String diskPath) {
            this.diskPath = diskPath;
            return this;
        }

        public final void setDiskPath(String diskPath) {
            this.diskPath = diskPath;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AttachDiskRequest build() {
            return new AttachDiskRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, AttachDiskRequest> {
        public Builder diskName(String var1);

        public Builder instanceName(String var1);

        public Builder diskPath(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

