/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.PasswordData;

@SdkInternalApi
public class PasswordDataMarshaller {
    private static final MarshallingInfo<String> CIPHERTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ciphertext").build();
    private static final MarshallingInfo<String> KEYPAIRNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyPairName").build();
    private static final PasswordDataMarshaller INSTANCE = new PasswordDataMarshaller();

    public static PasswordDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PasswordData passwordData, ProtocolMarshaller protocolMarshaller) {
        if (passwordData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)passwordData.ciphertext(), CIPHERTEXT_BINDING);
            protocolMarshaller.marshall((Object)passwordData.keyPairName(), KEYPAIRNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

