/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lightsail.model.PortInfo;
import software.amazon.awssdk.services.lightsail.model.PortInfoListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutInstancePublicPortsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutInstancePublicPortsRequest> {
    private final List<PortInfo> portInfos;
    private final String instanceName;

    private PutInstancePublicPortsRequest(BuilderImpl builder) {
        this.portInfos = builder.portInfos;
        this.instanceName = builder.instanceName;
    }

    public List<PortInfo> portInfos() {
        return this.portInfos;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.portInfos());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInstancePublicPortsRequest)) {
            return false;
        }
        PutInstancePublicPortsRequest other = (PutInstancePublicPortsRequest)((Object)obj);
        return Objects.equals(this.portInfos(), other.portInfos()) && Objects.equals(this.instanceName(), other.instanceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.portInfos() != null) {
            sb.append("PortInfos: ").append(this.portInfos()).append(",");
        }
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portInfos": {
                return Optional.of(clazz.cast(this.portInfos()));
            }
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<PortInfo> portInfos;
        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInstancePublicPortsRequest model) {
            this.portInfos(model.portInfos);
            this.instanceName(model.instanceName);
        }

        public final Collection<PortInfo.Builder> getPortInfos() {
            return this.portInfos != null ? (Collection)this.portInfos.stream().map(PortInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portInfos(Collection<PortInfo> portInfos) {
            this.portInfos = PortInfoListCopier.copy(portInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portInfos(PortInfo ... portInfos) {
            this.portInfos(Arrays.asList(portInfos));
            return this;
        }

        public final void setPortInfos(Collection<PortInfo.BuilderImpl> portInfos) {
            this.portInfos = PortInfoListCopier.copyFromBuilder(portInfos);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public PutInstancePublicPortsRequest build() {
            return new PutInstancePublicPortsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutInstancePublicPortsRequest> {
        public Builder portInfos(Collection<PortInfo> var1);

        public Builder portInfos(PortInfo ... var1);

        public Builder instanceName(String var1);
    }
}

