/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBundlesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetBundlesRequest> {
    private final Boolean includeInactive;
    private final String pageToken;

    private GetBundlesRequest(BuilderImpl builder) {
        this.includeInactive = builder.includeInactive;
        this.pageToken = builder.pageToken;
    }

    public Boolean includeInactive() {
        return this.includeInactive;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.includeInactive());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBundlesRequest)) {
            return false;
        }
        GetBundlesRequest other = (GetBundlesRequest)((Object)obj);
        return Objects.equals(this.includeInactive(), other.includeInactive()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.includeInactive() != null) {
            sb.append("IncludeInactive: ").append(this.includeInactive()).append(",");
        }
        if (this.pageToken() != null) {
            sb.append("PageToken: ").append(this.pageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "includeInactive": {
                return Optional.of(clazz.cast(this.includeInactive()));
            }
            case "pageToken": {
                return Optional.of(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean includeInactive;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBundlesRequest model) {
            this.includeInactive(model.includeInactive);
            this.pageToken(model.pageToken);
        }

        public final Boolean getIncludeInactive() {
            return this.includeInactive;
        }

        @Override
        public final Builder includeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
            return this;
        }

        public final void setIncludeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public GetBundlesRequest build() {
            return new GetBundlesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBundlesRequest> {
        public Builder includeInactive(Boolean var1);

        public Builder pageToken(String var1);
    }
}

