/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lightsail.model.DomainEntry;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteDomainEntryRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteDomainEntryRequest> {
    private final String domainName;
    private final DomainEntry domainEntry;

    private DeleteDomainEntryRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.domainEntry = builder.domainEntry;
    }

    public String domainName() {
        return this.domainName;
    }

    public DomainEntry domainEntry() {
        return this.domainEntry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEntry());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDomainEntryRequest)) {
            return false;
        }
        DeleteDomainEntryRequest other = (DeleteDomainEntryRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.domainEntry(), other.domainEntry());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.domainEntry() != null) {
            sb.append("DomainEntry: ").append(this.domainEntry()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "domainEntry": {
                return Optional.of(clazz.cast(this.domainEntry()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private DomainEntry domainEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDomainEntryRequest model) {
            this.domainName(model.domainName);
            this.domainEntry(model.domainEntry);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final DomainEntry.Builder getDomainEntry() {
            return this.domainEntry != null ? this.domainEntry.toBuilder() : null;
        }

        @Override
        public final Builder domainEntry(DomainEntry domainEntry) {
            this.domainEntry = domainEntry;
            return this;
        }

        public final void setDomainEntry(DomainEntry.BuilderImpl domainEntry) {
            this.domainEntry = domainEntry != null ? domainEntry.build() : null;
        }

        public DeleteDomainEntryRequest build() {
            return new DeleteDomainEntryRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteDomainEntryRequest> {
        public Builder domainName(String var1);

        public Builder domainEntry(DomainEntry var1);

        default public Builder domainEntry(Consumer<DomainEntry.Builder> domainEntry) {
            return this.domainEntry((DomainEntry)((DomainEntry.Builder)DomainEntry.builder().apply(domainEntry)).build());
        }
    }
}

