/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lightsail.model.PortInfo;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OpenInstancePublicPortsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, OpenInstancePublicPortsRequest> {
    private final PortInfo portInfo;
    private final String instanceName;

    private OpenInstancePublicPortsRequest(BuilderImpl builder) {
        this.portInfo = builder.portInfo;
        this.instanceName = builder.instanceName;
    }

    public PortInfo portInfo() {
        return this.portInfo;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.portInfo() == null ? 0 : this.portInfo().hashCode());
        hashCode = 31 * hashCode + (this.instanceName() == null ? 0 : this.instanceName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenInstancePublicPortsRequest)) {
            return false;
        }
        OpenInstancePublicPortsRequest other = (OpenInstancePublicPortsRequest)((Object)obj);
        if (other.portInfo() == null ^ this.portInfo() == null) {
            return false;
        }
        if (other.portInfo() != null && !other.portInfo().equals(this.portInfo())) {
            return false;
        }
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        return other.instanceName() == null || other.instanceName().equals(this.instanceName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.portInfo() != null) {
            sb.append("PortInfo: ").append(this.portInfo()).append(",");
        }
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portInfo": {
                return Optional.of(clazz.cast(this.portInfo()));
            }
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private PortInfo portInfo;
        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenInstancePublicPortsRequest model) {
            this.portInfo(model.portInfo);
            this.instanceName(model.instanceName);
        }

        public final PortInfo.Builder getPortInfo() {
            return this.portInfo != null ? this.portInfo.toBuilder() : null;
        }

        @Override
        public final Builder portInfo(PortInfo portInfo) {
            this.portInfo = portInfo;
            return this;
        }

        public final void setPortInfo(PortInfo.BuilderImpl portInfo) {
            this.portInfo = portInfo != null ? portInfo.build() : null;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public OpenInstancePublicPortsRequest build() {
            return new OpenInstancePublicPortsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OpenInstancePublicPortsRequest> {
        public Builder portInfo(PortInfo var1);

        public Builder instanceName(String var1);
    }
}

