/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportKeyPairRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ImportKeyPairRequest> {
    private final String keyPairName;
    private final String publicKeyBase64;

    private ImportKeyPairRequest(BuilderImpl builder) {
        this.keyPairName = builder.keyPairName;
        this.publicKeyBase64 = builder.publicKeyBase64;
    }

    public String keyPairName() {
        return this.keyPairName;
    }

    public String publicKeyBase64() {
        return this.publicKeyBase64;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyPairName() == null ? 0 : this.keyPairName().hashCode());
        hashCode = 31 * hashCode + (this.publicKeyBase64() == null ? 0 : this.publicKeyBase64().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairRequest)) {
            return false;
        }
        ImportKeyPairRequest other = (ImportKeyPairRequest)((Object)obj);
        if (other.keyPairName() == null ^ this.keyPairName() == null) {
            return false;
        }
        if (other.keyPairName() != null && !other.keyPairName().equals(this.keyPairName())) {
            return false;
        }
        if (other.publicKeyBase64() == null ^ this.publicKeyBase64() == null) {
            return false;
        }
        return other.publicKeyBase64() == null || other.publicKeyBase64().equals(this.publicKeyBase64());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyPairName() != null) {
            sb.append("KeyPairName: ").append(this.keyPairName()).append(",");
        }
        if (this.publicKeyBase64() != null) {
            sb.append("PublicKeyBase64: ").append(this.publicKeyBase64()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyPairName": {
                return Optional.of(clazz.cast(this.keyPairName()));
            }
            case "publicKeyBase64": {
                return Optional.of(clazz.cast(this.publicKeyBase64()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String keyPairName;
        private String publicKeyBase64;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairRequest model) {
            this.keyPairName(model.keyPairName);
            this.publicKeyBase64(model.publicKeyBase64);
        }

        public final String getKeyPairName() {
            return this.keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        public final String getPublicKeyBase64() {
            return this.publicKeyBase64;
        }

        @Override
        public final Builder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public final void setPublicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
        }

        public ImportKeyPairRequest build() {
            return new ImportKeyPairRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportKeyPairRequest> {
        public Builder keyPairName(String var1);

        public Builder publicKeyBase64(String var1);
    }
}

