/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.Region;
import software.amazon.awssdk.services.lightsail.model.RegionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetRegionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetRegionsResponse> {
    private final List<Region> regions;

    private GetRegionsResponse(BuilderImpl builder) {
        this.regions = builder.regions;
    }

    public List<Region> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.regions() == null ? 0 : this.regions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegionsResponse)) {
            return false;
        }
        GetRegionsResponse other = (GetRegionsResponse)((Object)obj);
        if (other.regions() == null ^ this.regions() == null) {
            return false;
        }
        return other.regions() == null || other.regions().equals(this.regions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.regions() != null) {
            sb.append("Regions: ").append(this.regions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "regions": {
                return Optional.of(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Region> regions;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegionsResponse model) {
            this.regions(model.regions);
        }

        public final Collection<Region.Builder> getRegions() {
            return this.regions != null ? (Collection)this.regions.stream().map(Region::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regions(Collection<Region> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Region ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<Region.BuilderImpl> regions) {
            this.regions = RegionListCopier.copyFromBuilder(regions);
        }

        public GetRegionsResponse build() {
            return new GetRegionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetRegionsResponse> {
        public Builder regions(Collection<Region> var1);

        public Builder regions(Region ... var1);
    }
}

