/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.Instance;
import software.amazon.awssdk.services.lightsail.transform.InstanceHardwareUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.InstanceNetworkingUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.InstanceStateUnmarshaller;
import software.amazon.awssdk.services.lightsail.transform.ResourceLocationUnmarshaller;

public class InstanceUnmarshaller
implements Unmarshaller<Instance, JsonUnmarshallerContext> {
    private static InstanceUnmarshaller INSTANCE;

    public Instance unmarshall(JsonUnmarshallerContext context) throws Exception {
        Instance.Builder instanceBuilder = Instance.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("supportCode", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.supportCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.createdAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.location(ResourceLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("blueprintId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.blueprintId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("blueprintName", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.blueprintName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("bundleId", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.bundleId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("isStaticIp", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.isStaticIp((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("privateIpAddress", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.privateIpAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("publicIpAddress", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.publicIpAddress((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ipv6Address", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.ipv6Address((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("hardware", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.hardware(InstanceHardwareUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("networking", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.networking(InstanceNetworkingUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.state(InstanceStateUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("username", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.username((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("sshKeyName", targetDepth)) {
                    context.nextToken();
                    instanceBuilder.sshKeyName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Instance)instanceBuilder.build();
    }

    public static InstanceUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstanceUnmarshaller();
        }
        return INSTANCE;
    }
}

