/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.Instance;
import software.amazon.awssdk.services.lightsail.model.InstanceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetInstancesResponse> {
    private final List<Instance> instances;
    private final String nextPageToken;

    private GetInstancesResponse(BuilderImpl builder) {
        this.instances = builder.instances;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instances() == null ? 0 : this.instances().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancesResponse)) {
            return false;
        }
        GetInstancesResponse other = (GetInstancesResponse)((Object)obj);
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Instance> instances;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancesResponse model) {
            this.setInstances(model.instances);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<Instance> getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
        }

        @SafeVarargs
        public final void setInstances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public GetInstancesResponse build() {
            return new GetInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetInstancesResponse> {
        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder nextPageToken(String var1);
    }
}

