/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.lightsail.model.InstanceMetricName;
import software.amazon.awssdk.services.lightsail.model.MetricStatistic;
import software.amazon.awssdk.services.lightsail.model.MetricStatisticListCopier;
import software.amazon.awssdk.services.lightsail.model.MetricUnit;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInstanceMetricDataRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetInstanceMetricDataRequest> {
    private final String instanceName;
    private final String metricName;
    private final Integer period;
    private final Instant startTime;
    private final Instant endTime;
    private final String unit;
    private final List<String> statistics;

    private GetInstanceMetricDataRequest(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.metricName = builder.metricName;
        this.period = builder.period;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.unit = builder.unit;
        this.statistics = builder.statistics;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String metricName() {
        return this.metricName;
    }

    public Integer period() {
        return this.period;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String unit() {
        return this.unit;
    }

    public List<String> statistics() {
        return this.statistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceName() == null ? 0 : this.instanceName().hashCode());
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.period() == null ? 0 : this.period().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.unit() == null ? 0 : this.unit().hashCode());
        hashCode = 31 * hashCode + (this.statistics() == null ? 0 : this.statistics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceMetricDataRequest)) {
            return false;
        }
        GetInstanceMetricDataRequest other = (GetInstanceMetricDataRequest)((Object)obj);
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.period() == null ^ this.period() == null) {
            return false;
        }
        if (other.period() != null && !other.period().equals(this.period())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        if (other.unit() != null && !other.unit().equals(this.unit())) {
            return false;
        }
        if (other.statistics() == null ^ this.statistics() == null) {
            return false;
        }
        return other.statistics() == null || other.statistics().equals(this.statistics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.period() != null) {
            sb.append("Period: ").append(this.period()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.unit() != null) {
            sb.append("Unit: ").append(this.unit()).append(",");
        }
        if (this.statistics() != null) {
            sb.append("Statistics: ").append(this.statistics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceName;
        private String metricName;
        private Integer period;
        private Instant startTime;
        private Instant endTime;
        private String unit;
        private List<String> statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceMetricDataRequest model) {
            this.setInstanceName(model.instanceName);
            this.setMetricName(model.metricName);
            this.setPeriod(model.period);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setUnit(model.unit);
            this.setStatistics(model.statistics);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(InstanceMetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final void setMetricName(InstanceMetricName metricName) {
            this.metricName(metricName.toString());
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final void setUnit(MetricUnit unit) {
            this.unit(unit.toString());
        }

        public final Collection<String> getStatistics() {
            return this.statistics;
        }

        @Override
        public final Builder statistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(String ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(MetricStatistic ... statistics) {
            this.statistics(Arrays.asList(statistics).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
        }

        @SafeVarargs
        public final void setStatistics(String ... statistics) {
            this.statistics(Arrays.asList(statistics));
        }

        @SafeVarargs
        public final void setStatistics(MetricStatistic ... statistics) {
            this.statistics(Arrays.asList(statistics).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public GetInstanceMetricDataRequest build() {
            return new GetInstanceMetricDataRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetInstanceMetricDataRequest> {
        public Builder instanceName(String var1);

        public Builder metricName(String var1);

        public Builder metricName(InstanceMetricName var1);

        public Builder period(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder unit(String var1);

        public Builder unit(MetricUnit var1);

        public Builder statistics(Collection<String> var1);

        public Builder statistics(String ... var1);

        public Builder statistics(MetricStatistic ... var1);
    }
}

