/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.services.lightsail.model.OperationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInstancesFromSnapshotResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, CreateInstancesFromSnapshotResponse> {
    private final List<Operation> operations;

    private CreateInstancesFromSnapshotResponse(BuilderImpl builder) {
        this.operations = builder.operations;
    }

    public List<Operation> operations() {
        return this.operations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.operations() == null ? 0 : this.operations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesFromSnapshotResponse)) {
            return false;
        }
        CreateInstancesFromSnapshotResponse other = (CreateInstancesFromSnapshotResponse)((Object)obj);
        if (other.operations() == null ^ this.operations() == null) {
            return false;
        }
        return other.operations() == null || other.operations().equals(this.operations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.operations() != null) {
            sb.append("Operations: ").append(this.operations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Operation> operations;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesFromSnapshotResponse model) {
            this.setOperations(model.operations);
        }

        public final Collection<Operation> getOperations() {
            return this.operations;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
        }

        @SafeVarargs
        public final void setOperations(Operation ... operations) {
            this.operations(Arrays.asList(operations));
        }

        public CreateInstancesFromSnapshotResponse build() {
            return new CreateInstancesFromSnapshotResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateInstancesFromSnapshotResponse> {
        public Builder operations(Collection<Operation> var1);

        public Builder operations(Operation ... var1);
    }
}

